/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.BackgroundTaskManager;
import de.bsvrz.ars.ars.mgmt.QueueParameters;
import de.bsvrz.ars.ars.mgmt.RuntimeControl;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentNode;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentTree;
import de.bsvrz.ars.ars.mgmt.simulation.SimulationResultData;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveInfoQueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveQueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveSettingsTask;
import de.bsvrz.ars.ars.mgmt.tasks.DeletePermanentlyTask;
import de.bsvrz.ars.ars.mgmt.tasks.FlowControlTask;
import de.bsvrz.ars.ars.mgmt.tasks.MultiTaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.QueueTask;
import de.bsvrz.ars.ars.mgmt.tasks.SerializeTask;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.query.QueryHandler;
import de.bsvrz.ars.ars.persistence.CacheManager;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.ars.ars.persistence.writer.ArchiveJob;
import de.bsvrz.ars.ars.persistence.writer.ArchiveOnlineData;
import de.bsvrz.ars.ars.persistence.writer.ArchiveRequestedData;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.ars.ars.persistence.writer.AsyncSerializableDataset;
import de.bsvrz.ars.ars.persistence.writer.CloseContainerObject;
import de.bsvrz.ars.ars.persistence.writer.RequestedDataFinished;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.Dataset;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.archive.ArchiveData;
import de.bsvrz.dav.daf.main.archive.ArchiveQueryPriority;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.util.cron.CronDefinition;
import de.bsvrz.dav.daf.util.cron.CronScheduler;
import de.bsvrz.sys.funclib.dataSerializer.Deserializer;
import de.bsvrz.sys.funclib.dataSerializer.NoSuchVersionException;
import de.bsvrz.sys.funclib.dataSerializer.SerializingFactory;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.losb.util.Util;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import de.bsvrz.sys.funclib.operatingMessage.MessageState;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public final class InQueuesMgr {
    private static final int TM_QRYA_IDX = 0;
    private static final int TM_QRYB_IDX = 1;
    private static final int TM_QRYC_IDX = 2;
    private static final int TM_ARCINF_IDX = 3;
    private static final int TM_QRY_A_NUM_DEFAULT = 3;
    private static final int TM_QRY_B_NUM_DEFAULT = 6;
    private static final int TM_QRY_C_NUM_DEFAULT = 9;
    private static final int TM_ARC_INF_NUM = 4;
    private static final int NUM_OF_MULTITASK_MGR = 4;
    private final int queueCapacity;
    private static final double NONWRITE_SUSPEND_LIMIT = 0.8;
    private static final double NONWRITE_RESUME_LIMIT = 0.7;
    private final SignalingQueue<ResultData> simParamQueue = new SignalingQueue();
    private final SignalingQueue<ResultData> queryQueueA = new SignalingQueue();
    private final SignalingQueue<ResultData> queryQueueB = new SignalingQueue();
    private final SignalingQueue<ResultData> queryQueueC = new SignalingQueue();
    private final SignalingQueue<ResultData> queryQueueInfo = new SignalingQueue();
    private final BackgroundTaskManager backgroundTaskManager;
    private SignalingQueue<ArchiveJob> archiveQueue;
    private final SerializeTask[] serializeTasks;
    private final SignalingQueue<AsyncSerializableDataset> serializeQueue = new SignalingQueue();
    private ArchiveTask archiveTask;
    private final MultiTaskManager[] tskMgrs = new MultiTaskManager[4];
    private final FlowControlTask flowCtrl;
    private final ArchiveManager archMgr;
    private final RuntimeControl runtimeControl;
    private final DataIdentTree didTree;
    private static final Debug logger = Debug.getLogger();
    private boolean terminated;
    private final ArchiveDataReceiver archiveDataReceiver = new ArchiveDataReceiver();
    private final QueryReceiver queryReceiver = new QueryReceiver();
    private final ArchiveSettingsReceiver arsSettingsReceiver = new ArchiveSettingsReceiver();
    private final DataAckSender dataAckSender = new DataAckSender();
    private final AtomicLong receivedCounterOnline = new AtomicLong(0L);
    private final AtomicLong queueCounterRequested = new AtomicLong(0L);
    private final AtomicLong queueCounterOnline = new AtomicLong(0L);
    private volatile boolean suspendReadingTasks;
    private final Object suspendReadingTasksLock = new Object();
    private final Semaphore subscriptionSemaphore;
    private final Set<IdDataIdentification> _pendingSubscriptions = Collections.synchronizedSet(new HashSet());
    private final long _maxWaitNanosPerSubscription;
    private final long _minWaitNanosPerSubscription;
    private final int _queueLimitForSubscriptions;
    private volatile boolean _fastExit;

    public boolean subscribe(ClientDavInterface davCon, SystemObject so, DataDescription dataDescription) throws InterruptedException {
        IdDataIdentification identification = new IdDataIdentification(so, dataDescription);
        long waitTimeNanos = this._minWaitNanosPerSubscription;
        if (this.countDataInQueues() > this._queueLimitForSubscriptions) {
            waitTimeNanos += 10000000L;
        }
        if (waitTimeNanos > 0L) {
            LockSupport.parkNanos(waitTimeNanos);
        }
        boolean semaphoreAcquired = false;
        if (this._pendingSubscriptions.add(identification)) {
            long additionalWait = this._maxWaitNanosPerSubscription - waitTimeNanos;
            if (this.subscriptionSemaphore.tryAcquire(additionalWait, TimeUnit.NANOSECONDS)) {
                semaphoreAcquired = true;
            } else {
                this._pendingSubscriptions.remove(identification);
            }
        }
        try {
            davCon.subscribeReceiver((ClientReceiverInterface)this.archiveDataReceiver, so, dataDescription, ReceiveOptions.delayed(), ReceiverRole.receiver());
            return true;
        }
        catch (Exception e) {
            if (semaphoreAcquired) {
                this._pendingSubscriptions.remove(identification);
                this.subscriptionSemaphore.release();
            }
            logger.fine("Empfangsanmeldung fuer " + String.valueOf(so) + ", " + String.valueOf(dataDescription) + " fehlgeschlagen: " + e.getMessage());
            return false;
        }
    }

    public InQueuesMgr(ArchiveManager aMgr, RuntimeControl runtimeControl, DataIdentTree dTree, QueueParameters parameters) {
        int i;
        this.archMgr = aMgr;
        this.runtimeControl = runtimeControl;
        this.didTree = dTree;
        this._minWaitNanosPerSubscription = parameters.getMinWaitNanosPerSubscription();
        this._maxWaitNanosPerSubscription = parameters.getMaxWaitNanosPerSubscription();
        this.archMgr.getArchivConfig().setSimConfigQueue(this.simParamQueue);
        this.backgroundTaskManager = new BackgroundTaskManager(this.archMgr);
        this.assignMultitasks();
        this.flowCtrl = new FlowControlTask();
        this.setQueryTaskNumbers(3, 6, 9);
        for (i = 0; i < 4; ++i) {
            this.tskMgrs[3].addTask(new ArchiveInfoQueryTask(this.tskMgrs[3]));
        }
        this.serializeTasks = new SerializeTask[this.archMgr.getNumOfArchTasks()];
        for (i = 0; i < this.serializeTasks.length; ++i) {
            this.serializeTasks[i] = new SerializeTask(this.archMgr, this.serializeQueue);
        }
        this.queueCapacity = parameters.getTotalCapacityOfOnlineQueues();
        this._queueLimitForSubscriptions = Math.min(parameters.getTotalCapacityOfOnlineQueues() / 2, 100000);
        if (this.queueCapacity < 1) {
            throw new IllegalArgumentException("Gr\u00f6\u00dfe der Queues ist zu klein.");
        }
        this.assignArchiveTasks();
        this.subscriptionSemaphore = new Semaphore(parameters.getSubscriptionSlidingWindowSize());
    }

    private void assignArchiveTasks() {
        this.archiveQueue = new SignalingQueue();
        this.archiveTask = new ArchiveTask(this.archMgr, this.archiveQueue);
    }

    private void assignMultitasks() {
        this.tskMgrs[0] = new MultiTaskManager(this.archMgr, this.queryQueueA, "QueryPrioA");
        this.tskMgrs[1] = new MultiTaskManager(this.archMgr, this.queryQueueB, "QueryPrioB");
        this.tskMgrs[2] = new MultiTaskManager(this.archMgr, this.queryQueueC, "QueryPrioC");
        this.tskMgrs[3] = new MultiTaskManager(this.archMgr, this.queryQueueInfo, "ArchivInfo");
    }

    public void setQueryTaskNumbers(int numHi, int numMid, int numLo) {
        this.installQueryTask(this.tskMgrs[0], numHi);
        this.installQueryTask(this.tskMgrs[1], numMid);
        this.installQueryTask(this.tskMgrs[2], numLo);
    }

    public int getHiQueryTaskNum() {
        return this.tskMgrs[0].getTaskNum();
    }

    public int getMidQueryTaskNum() {
        return this.tskMgrs[1].getTaskNum();
    }

    public int getLoQueryTaskNum() {
        return this.tskMgrs[2].getTaskNum();
    }

    private void installQueryTask(MultiTaskManager mtm, int anz) {
        if (mtm.shouldTerminate()) {
            return;
        }
        int anzQTasks = mtm.getTaskNum();
        if (anz > anzQTasks) {
            for (int i = 0; i < anz - anzQTasks; ++i) {
                ArchiveQueryTask newTask = new ArchiveQueryTask(this.archMgr, mtm, this.flowCtrl, this.archMgr.getMaximumQueriesPerApplication());
                mtm.addTask(newTask);
            }
        } else {
            for (int i = 0; i < anzQTasks - anz; ++i) {
                mtm.removeTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTaskIfNecessary(Task task) throws InterruptedException {
        this.archMgr.getPersistenceManager().assertNoLocks();
        if (this.suspendReadingTasks) {
            Object object = this.suspendReadingTasksLock;
            synchronized (object) {
                while (this.suspendReadingTasks) {
                    if (this.terminated || task.isTerminated()) {
                        return;
                    }
                    this.suspendReadingTasksLock.wait(10000L);
                    this.suspendNonWriteTasks();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendNonWriteTasks() {
        if (!this.suspendReadingTasks && this.getQueueLoad() > 0.8) {
            this.suspendReadingTasks = true;
            logger.fine("Bearbeitung von Archivanfragen wegen Ueberlast ausgesetzt");
            MessageSender.getInstance().sendMessage(MessageType.APPLICATION_DOMAIN, MessageGrade.INFORMATION, "Die Warteschlangen sind zu 80.0% gef\u00fcllt - das Schreiben von Daten erh\u00e4lt eine h\u00f6here Priorit\u00e4t.");
        } else if (this.suspendReadingTasks && this.getQueueLoad() < 0.7) {
            Object object = this.suspendReadingTasksLock;
            synchronized (object) {
                this.suspendReadingTasks = false;
                this.suspendReadingTasksLock.notifyAll();
                logger.fine("Bearbeitung von Archivanfragen wieder aufgenommen");
                MessageSender.getInstance().sendMessage(MessageType.APPLICATION_DOMAIN, MessageGrade.INFORMATION, "Die Warteschlangen sind nur noch zu 70.0% gef\u00fcllt. Alle Tasks arbeiten wieder mit gleicher Priorit\u00e4t.");
            }
        }
    }

    public void suspendNonWriteTasksDirect() {
        this.suspendReadingTasks = true;
    }

    public void getObjectsFromDav() {
        for (MultiTaskManager tskMgr : this.tskMgrs) {
            tskMgr.getObjectsFromDav();
        }
    }

    public void subscribeSettings() {
        ArchiveSettingsTask.subscribeObjects(this.archMgr, this.arsSettingsReceiver);
    }

    public void subscribeQueries() {
        ArchiveQueryTask.subscribeObjects(this.archMgr, this.queryReceiver);
    }

    public void startAllTasks() {
        this.resetDSCounter();
        for (int i = 0; i < 4; ++i) {
            this.tskMgrs[i].start();
        }
        this.backgroundTaskManager.startBackgroundTasks();
        for (SerializeTask serializeTask : this.serializeTasks) {
            serializeTask.start();
        }
        this.archiveTask.resetDSCounter();
        this.archiveTask.start();
    }

    /*
     * Could not resolve type clashes
     */
    public void stopAllTasks() throws InterruptedException {
        this.terminated = true;
        int totalTasks = 5 + this.backgroundTaskManager.getBackgroundTasks().size() + this.serializeTasks.length;
        this.backgroundTaskManager.stopBackgroundTasks();
        for (MultiTaskManager tskMgr : this.tskMgrs) {
            tskMgr.terminateTask();
        }
        this.waitForEmptyArchiveQueues();
        for (QueueTask serializeTask : this.serializeTasks) {
            serializeTask.terminateTask();
        }
        this.archiveTask.terminateTask();
        this.archiveDataReceiver._cronScheduler.shutdownNow();
        Thread.sleep(100L);
        int debugCounter = 0;
        while (true) {
            int numTasksAlive = 0;
            for (Task singleTsk : this.backgroundTaskManager.getBackgroundTasks()) {
                if (!singleTsk.isAlive()) continue;
                ++numTasksAlive;
            }
            for (MultiTaskManager tskMgr : this.tskMgrs) {
                if (!tskMgr.isAlive()) continue;
                ++numTasksAlive;
            }
            for (QueueTask serializeTask : this.serializeTasks) {
                if (!serializeTask.isAlive()) continue;
                ++numTasksAlive;
            }
            if (this.archiveTask.isAlive()) {
                ++numTasksAlive;
            }
            if (numTasksAlive == 0) break;
            if (debugCounter++ == 100) {
                debugCounter = 0;
                StringBuilder builder = new StringBuilder();
                builder.append("Tasks werden beendet...\n");
                builder.append("Es m\u00fcssen noch ");
                builder.append(numTasksAlive);
                builder.append(" von ");
                builder.append(totalTasks);
                builder.append(" Tasks beendet werden.\n");
                builder.append("Verbleibende Tasks:\n");
                for (Task singleTsk : this.backgroundTaskManager.getBackgroundTasks()) {
                    if (!singleTsk.isAlive()) continue;
                    builder.append(" - ").append(singleTsk.getName()).append("\n");
                }
                for (MultiTaskManager tskMgr : this.tskMgrs) {
                    if (!tskMgr.isAlive()) continue;
                    builder.append(" - ").append(tskMgr.getName()).append("\n");
                }
                for (QueueTask serializeTask : this.serializeTasks) {
                    if (!serializeTask.isAlive()) continue;
                    builder.append(" - ").append(serializeTask.getName()).append("\n");
                }
                if (this.archiveTask.isAlive()) {
                    builder.append(" - ").append(this.archiveTask.getName()).append("\n");
                }
                logger.warning(builder.toString());
            }
            Thread.sleep(100L);
        }
        logger.info("Alle Tasks korrekt beendet");
    }

    private void waitForEmptyArchiveQueues() {
        if (this._fastExit) {
            this.archiveTask.terminateTask();
            this.archiveQueue.clear();
            logger.error("Warten auf leere Archiv-Warteschlange wurde \u00fcbersprungen.");
            return;
        }
        int numOfWaitingData = this.archiveQueue.size();
        if (numOfWaitingData > 0) {
            try {
                logger.info(numOfWaitingData + " Datensaetze in der Warteschlange noch zu archivieren...");
                while (!this._fastExit && !this.archiveQueue.waitUntilEmpty(Duration.ofMinutes(1L))) {
                    logger.info(this.archiveQueue.size() + " Datensaetze in der Warteschlange noch zu archivieren...");
                }
            }
            catch (InterruptedException e) {
                logger.error("Warten auf leere Archiv-Warteschlange unterbrochen.");
                return;
            }
            if (this._fastExit) {
                this.archiveTask.terminateTask();
                this.archiveQueue.clear();
                logger.error("Warten auf leere Archiv-Warteschlange wurde \u00fcbersprungen.");
                return;
            }
            logger.info("Alle Datensaetze archiviert.");
        }
    }

    public void archiveRequestedData(long archiveTime, ArchiveData ad) {
        this.archiveQueue.add(new ArchiveRequestedData(SerializableDataset.createAsync((Dataset)ad, archiveTime, this.serializeQueue), new IdDataIdentification((Dataset)ad), ad.getDataKind().isDelayed()));
        this.queueCounterRequested.incrementAndGet();
    }

    public void insertInSimVarDeleteQueue(ResultData resultData) {
        this.backgroundTaskManager.getDeleteSimVarTask().submit(resultData);
    }

    public void insertSimVarParam(SimulationResultData resultData) {
        this.simParamQueue.add(resultData);
    }

    public void startDeletePermanently() {
        this.backgroundTaskManager.getDeletePermanentlyTask().submit(new DeletePermanentlyTask.DeletePermanentlyToken());
    }

    public void insertInRequestQueue(ResultData resultData) {
        this.backgroundTaskManager.getRequestGapTask().submit(resultData);
    }

    public void insertCloseContainer(CloseContainerObject cco) {
        this.archiveQueue.add(cco);
        this.queueCounterOnline.incrementAndGet();
    }

    public int getArchiveQueueCapacity() {
        return this.queueCapacity;
    }

    public double getQueueLoad() {
        return (double)this.countDataInQueues() / (double)this.getArchiveQueueCapacity();
    }

    public int countDataInQueues() {
        return this.archiveQueue.size();
    }

    public void resetDSCounter() {
        this.receivedCounterOnline.set(0L);
        this.queueCounterRequested.set(0L);
        this.queueCounterOnline.set(0L);
        this.archiveTask.resetDSCounter();
    }

    public ArchiveSettingsTask getArchiveSettingsTask() {
        return this.backgroundTaskManager.getArchiveSettingsTask();
    }

    public ArchiveDataReceiver getArchiveDataReceiver() {
        return this.archiveDataReceiver;
    }

    public DataAckSender getDataAckSender() {
        return this.dataAckSender;
    }

    public void setFastExit(boolean quickExit) {
        this._fastExit = quickExit;
    }

    public DeletePermanentlyTask getDeletePermanentlyTask() {
        return this.backgroundTaskManager.getDeletePermanentlyTask();
    }

    public ArchiveTask getArchiveTask() {
        return this.archiveTask;
    }

    public void insertRequestedDataFinishedNotification() {
        this.archiveQueue.add(new RequestedDataFinished());
    }

    public long estimateQueueMemoryUsage() {
        return 12L + this.archiveQueue.capacityEstimate() * 4L + this.archiveQueue.sumElements(ArchiveJob::estimateMemoryUsage);
    }

    public BackgroundTaskManager getBackgroundTaskManager() {
        return this.backgroundTaskManager;
    }

    private SignalingQueue<ResultData> getArchiveQueue(ArchiveQueryPriority prio) {
        return switch (prio.getCode()) {
            case 1 -> this.queryQueueA;
            case 2 -> this.queryQueueB;
            case 3 -> this.queryQueueC;
            default -> throw new AssertionError();
        };
    }

    public long getReceivedCountOnline() {
        return this.receivedCounterOnline.longValue();
    }

    public long getQueuedCountTotal() {
        return this.getQueuedCountOnline() + this.getQueuesCountRequested();
    }

    public long getQueuedCountOnline() {
        return this.queueCounterOnline.get();
    }

    public long getQueuesCountRequested() {
        return this.queueCounterRequested.get();
    }

    public long getFailedCountTotal() {
        return this.archiveTask.getFailedCount();
    }

    public long getSuccessCountTotal() {
        return this.archiveTask.getSuccessCount();
    }

    public long getFailedCountOnline() {
        return this.archiveTask.getFailedCountOnline();
    }

    public long getSuccessCountOnline() {
        return this.archiveTask.getSuccessCountOnline();
    }

    public long getFailedCountRequested() {
        return this.archiveTask.getFailedCountRequested();
    }

    public long getSuccessCountRequested() {
        return this.archiveTask.getSuccessCountRequested();
    }

    public long getCloseContainerSuccess() {
        return this.archiveTask.getCloseContainerSuccess();
    }

    public RuntimeControl getRuntimeControl() {
        return this.runtimeControl;
    }

    public final class ArchiveDataReceiver
    extends DataReceiver {
        public static final String MSG_PID_ATBACKSTEP_SUSPEND = "Archivzeit-Ruecksprung (suspend)";
        public static final String MSG_PID_ATBACKSTEP_RESUME = "Archivzeit-Ruecksprung (resume)";
        public static final String MSG_PID_ATFWSTEP_SUSPEND = "Archivzeit-Vorwaertssprung (suspend)";
        public static final String MSG_PID_ATFWSTEP_RESUME = "Archivzeit-Vorwaertssprung (resume)";
        private boolean suspendArchMessageSentBS;
        private boolean resumeArchMessageSentBS;
        private boolean suspendArchMessageSentFS;
        private boolean resumeArchMessageSentFS;
        private boolean firstData;
        private long tMaxATimeForwardStep;
        private volatile long _statisticLastTotalReceivedDataSetCount;
        private volatile long _statisticLastTotalQueuedDataSetCount;
        private volatile long _statisticLastTotalSuccessDataSetCount;
        private volatile long _statisticLastTotalFailedDataSetCount;
        private volatile long _statisticLastTotalQueuedDataSetCountRequested;
        private volatile long _statisticLastTotalSuccessDataSetCountRequested;
        private volatile long _statisticLastTotalFailedDataSetCountRequested;
        private long[] _statisticLastCacheCounts;
        private final CronScheduler _cronScheduler;

        public ArchiveDataReceiver() {
            this.firstData = true;
            this.tMaxATimeForwardStep = 3600000L;
            this._statisticLastCacheCounts = new long[]{0L, 0L, 0L, 0L};
            this._cronScheduler = new CronScheduler(1, r -> {
                Thread statistics = new Thread(r, "Statistics");
                statistics.setDaemon(true);
                return statistics;
            });
            this._cronScheduler.schedule(this::printStatistics, CronDefinition.EVERY_MINUTE);
        }

        @Override
        public void update(ResultData[] rds) {
            for (ResultData rd : rds) {
                if (InQueuesMgr.this._pendingSubscriptions.isEmpty() || !InQueuesMgr.this._pendingSubscriptions.remove(new IdDataIdentification(rd.getObject(), rd.getDataDescription()))) continue;
                InQueuesMgr.this.subscriptionSemaphore.release();
            }
            super.update(rds);
        }

        @Override
        public void processData(ResultData rd) {
            long aTime = InQueuesMgr.this.runtimeControl.getSystemTime();
            InQueuesMgr.this.receivedCounterOnline.incrementAndGet();
            if (InQueuesMgr.this.runtimeControl.archiveOnlyData() && !rd.hasData()) {
                return;
            }
            DataIdentNode din = InQueuesMgr.this.didTree.get((Dataset)rd);
            if (din.arSParamIsArchivieren() && din.isArSParameterized()) {
                long delta;
                long lastArchiveTime = ArchiveTask.getLastArchiveTime();
                if (aTime < lastArchiveTime && (delta = lastArchiveTime - aTime) < 10000L) {
                    try {
                        System.out.println(delta);
                        Thread.sleep(delta);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    aTime = InQueuesMgr.this.runtimeControl.getSystemTime();
                }
                if (!this.testForArchiveTimeBackstep(aTime, lastArchiveTime) && !this.testForArchiveTimeForwardStep(aTime, lastArchiveTime)) {
                    this.putDataInQueue(rd, aTime);
                    ArchiveTask.setLastArchiveTime(aTime);
                    InQueuesMgr.this.suspendNonWriteTasks();
                }
            }
        }

        public void printStatistics() {
            StringBuilder message = new StringBuilder();
            message.append("Aktivit\u00e4t der Warteschlange im letzten Ausgabeintervall:");
            long totalReceivedDataSetCount = InQueuesMgr.this.getReceivedCountOnline();
            message.append(String.format("%n%20d Datens\u00e4tze empfangen", totalReceivedDataSetCount - this._statisticLastTotalReceivedDataSetCount));
            this._statisticLastTotalReceivedDataSetCount = totalReceivedDataSetCount;
            long totalQueuedDataSetCount = InQueuesMgr.this.getQueuedCountOnline();
            message.append(String.format("%n%20d Datens\u00e4tze weitergeleitet", totalQueuedDataSetCount - this._statisticLastTotalQueuedDataSetCount));
            this._statisticLastTotalQueuedDataSetCount = totalQueuedDataSetCount;
            long totalSuccessDataSetCount = InQueuesMgr.this.getSuccessCountOnline();
            message.append(String.format("%n%20d Datens\u00e4tze erfolgreich archiviert", totalSuccessDataSetCount - this._statisticLastTotalSuccessDataSetCount));
            this._statisticLastTotalSuccessDataSetCount = totalSuccessDataSetCount;
            long totalFailedDataSetCount = InQueuesMgr.this.getFailedCountOnline();
            message.append(String.format("%n%20d Datens\u00e4tze nicht erfolgreich archiviert", totalFailedDataSetCount - this._statisticLastTotalFailedDataSetCount));
            this._statisticLastTotalFailedDataSetCount = totalFailedDataSetCount;
            long totalQueuedDataSetCountRequested = InQueuesMgr.this.getQueuesCountRequested();
            message.append(String.format("%n%20d nachgeforderte Datens\u00e4tze empfangen", totalQueuedDataSetCountRequested - this._statisticLastTotalQueuedDataSetCountRequested));
            this._statisticLastTotalQueuedDataSetCountRequested = totalQueuedDataSetCountRequested;
            long totalSuccessDataSetCountRequested = InQueuesMgr.this.getSuccessCountRequested();
            message.append(String.format("%n%20d nachgeforderte Datens\u00e4tze erfolgreich archiviert", totalSuccessDataSetCountRequested - this._statisticLastTotalSuccessDataSetCountRequested));
            this._statisticLastTotalSuccessDataSetCountRequested = totalSuccessDataSetCountRequested;
            long totalFailedDataSetCountRequested = InQueuesMgr.this.getFailedCountRequested();
            message.append(String.format("%n%20d nachgeforderte Datens\u00e4tze nicht erfolgreich archiviert", totalFailedDataSetCountRequested - this._statisticLastTotalFailedDataSetCountRequested));
            this._statisticLastTotalFailedDataSetCountRequested = totalFailedDataSetCountRequested;
            PersistenceManager.Statistics statistics = InQueuesMgr.this.archMgr.getPersistenceManager().getStatistics();
            long queueSize = statistics.getQueueSize();
            int queueLoad = (int)((double)queueSize / (double)InQueuesMgr.this.getArchiveQueueCapacity() * 100.0);
            message.append(String.format("%n%20d Datens\u00e4tze noch in der Warteschlange befindlich", queueSize));
            message.append(String.format("%n%19d%% Auslastung der Warteschlange", queueLoad));
            message.append("\nAktivit\u00e4t der Zwischenspeicherung in geschlossenen Cache-Objekten: ");
            long[] cacheCounts = CacheManager.getInstance().getCounts();
            message.append(String.format("%n%20d Datei-Schreibvorg\u00e4nge", cacheCounts[0] - this._statisticLastCacheCounts[0]));
            message.append(String.format("%n%20d verarbeitete Datenbl\u00f6cke", cacheCounts[1] - this._statisticLastCacheCounts[1]));
            message.append(String.format("%n%20d zwischengespeicherte Datenbl\u00f6cke", cacheCounts[2] - this._statisticLastCacheCounts[2]));
            message.append(String.format("%n%20d nicht zwischengespeicherte Datenbl\u00f6cke", cacheCounts[3] - this._statisticLastCacheCounts[3]));
            this._statisticLastCacheCounts = cacheCounts;
            message.append("\nAktueller Arbeitsspeicherverbrauch: ");
            Runtime runtime = Runtime.getRuntime();
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            message.append(String.format("%n%20.3f MB insgesamt, davon", (double)usedMemory / 1048576.0));
            message.append(String.format("%n%20.3f MB zur Synchronisierung", (double)statistics.getLockMemory() / 1048576.0));
            message.append(String.format("%n%20.3f MB f\u00fcr %d Datenknoten", (double)statistics.getNodeMemory() / 1048576.0, statistics.getNumNodes()));
            message.append(String.format("%n%20.3f MB f\u00fcr %d offene Container", (double)statistics.getActiveMemory() / 1048576.0, statistics.getNumOpenContainerData()));
            message.append(String.format("%n%20.3f MB f\u00fcr %d Datens\u00e4tze in der Warteschlange", (double)statistics.getQueueMemory() / 1048576.0, queueSize));
            message.append(String.format("%n%20.3f MB zwischengespeichert f\u00fcr Archivierungs-Cache (davon %.0f%% ungenutzt)", (double)statistics.getCachedMemory().totalBytesUsed() / 1048576.0, 100.0 - 100.0 * (double)statistics.getCachedMemory().cachedBytes() / (double)statistics.getCachedMemory().totalBytesUsed()));
            Set<de.bsvrz.ars.ars.mgmt.tasks.base.Task> tasks = TaskManager.getActiveTasks();
            message.append("\nLaufende Tasks: ");
            int i = 1;
            for (de.bsvrz.ars.ars.mgmt.tasks.base.Task task : tasks) {
                message.append(String.format("%n%19d) %s", i++, task.getName()));
            }
            if (tasks.isEmpty()) {
                message.append(String.format("%n%20s Keine aktiven Tasks", "---"));
            }
            logger.info(message.toString());
        }

        private boolean testForArchiveTimeForwardStep(long aTime, long lastArchiveTime) {
            if (this.firstData) {
                this.firstData = false;
                return false;
            }
            if (aTime - lastArchiveTime > this.tMaxATimeForwardStep) {
                if (!this.suspendArchMessageSentFS) {
                    this.sendArchiveSuspendMsgFS(aTime);
                    this.suspendArchMessageSentFS = true;
                    this.resumeArchMessageSentFS = false;
                }
                return true;
            }
            if (this.suspendArchMessageSentFS && !this.resumeArchMessageSentFS) {
                this.sendArchiveResumeMsgFS(aTime);
                this.resumeArchMessageSentFS = true;
                this.suspendArchMessageSentFS = false;
            }
            return false;
        }

        private boolean testForArchiveTimeBackstep(long aTime, long lastArchiveTime) {
            if (aTime < lastArchiveTime) {
                if (!this.suspendArchMessageSentBS) {
                    this.sendArchiveSuspendMsgBS(aTime);
                    this.suspendArchMessageSentBS = true;
                    this.resumeArchMessageSentBS = false;
                }
                return true;
            }
            if (this.suspendArchMessageSentBS && !this.resumeArchMessageSentBS) {
                this.sendArchiveResumeMsgBS(aTime);
                this.resumeArchMessageSentBS = true;
                this.suspendArchMessageSentBS = false;
            }
            return false;
        }

        private void putDataInQueue(ResultData resultData, long archiveTime) {
            InQueuesMgr.this.archiveQueue.add(new ArchiveOnlineData(SerializableDataset.createAsync((Dataset)resultData, archiveTime, InQueuesMgr.this.serializeQueue), new IdDataIdentification((Dataset)resultData), resultData.getDataKind().isDelayed()));
            InQueuesMgr.this.queueCounterOnline.incrementAndGet();
        }

        private void sendArchiveSuspendMsgFS(long aTime) {
            String msg = "Es ist ein Vorwaertssprung der Archivzeit aufgetreten: die Archivzeit des soeben erhaltenen Datensatzes (" + Util.timestrMillisFormatted((long)aTime) + ") liegt mehr als " + this.tMaxATimeForwardStep / 1000L + "sec (" + Util.relTimestrMillis((long)this.tMaxATimeForwardStep) + ") nach der Archivzeit des zuletzt archivierten Datensatzes (" + Util.timestrMillisFormatted((long)ArchiveTask.getLastArchiveTime()) + "). Das Archivsystem stellt die Archivierung ein, bis die Archivzeit wieder innerhalb der zulaessigen Spanne liegt.";
            MessageSender.getInstance().sendMessage(MSG_PID_ATFWSTEP_SUSPEND, MessageType.APPLICATION_DOMAIN, "", MessageGrade.FATAL, MessageState.MESSAGE, msg);
            logger.info("Betriebsmeldung:" + Debug.NEWLINE + msg);
        }

        private void sendArchiveResumeMsgFS(long aTime) {
            String msg = "Der Vorwaertssprung der Archivzeit ist behoben: die Archivzeit des soeben erhaltenen Datensatzes (" + Util.timestrMillisFormatted((long)aTime) + ") liegt wieder innerhalb der zulaessigen Spanne von " + this.tMaxATimeForwardStep / 1000L + "sec (" + Util.relTimestrMillis((long)this.tMaxATimeForwardStep) + ") seit der Archivzeit des zuletzt archivierten Datensatzes (" + Util.timestrMillisFormatted((long)ArchiveTask.getLastArchiveTime()) + ". Das Archivsystem hat die Archivierung wieder aufgenommen.";
            MessageSender.getInstance().sendMessage(MSG_PID_ATFWSTEP_RESUME, MessageType.APPLICATION_DOMAIN, "", MessageGrade.INFORMATION, MessageState.MESSAGE, msg);
            logger.info("Betriebsmeldung:" + Debug.NEWLINE + msg);
        }

        private void sendArchiveSuspendMsgBS(long aTime) {
            String msg = "Es ist ein Ruecksprung der Archivzeit aufgetreten: die Archivzeit des zuletzt archivierten Datensatzes (" + Util.timestrMillisFormatted((long)ArchiveTask.getLastArchiveTime()) + ") liegt nach der Archivzeit des soeben erhaltenen Datensatzes (" + Util.timestrMillisFormatted((long)aTime) + "). Das Archivsystem stellt die Archivierung ein, bis die Archivzeit wieder nach der Archivzeit des zuletzt archivierten Datensatzes liegt.";
            MessageSender.getInstance().sendMessage(MSG_PID_ATBACKSTEP_SUSPEND, MessageType.APPLICATION_DOMAIN, "", MessageGrade.FATAL, MessageState.MESSAGE, msg);
            logger.info("Betriebsmeldung:" + Debug.NEWLINE + msg);
        }

        private void sendArchiveResumeMsgBS(long aTime) {
            String msg = "Der Ruecksprung der Archivzeit ist behoben: die Archivzeit des zuletzt archivierten Datensatzes (" + Util.timestrMillisFormatted((long)ArchiveTask.getLastArchiveTime()) + ") liegt wieder vor der Archivzeit des soeben erhaltenen Datensatzes (" + Util.timestrMillisFormatted((long)aTime) + "). Das Archivsystem hat die Archivierung wieder aufgenommen.";
            MessageSender.getInstance().sendMessage(MSG_PID_ATBACKSTEP_RESUME, MessageType.APPLICATION_DOMAIN, "", MessageGrade.INFORMATION, MessageState.MESSAGE, msg);
            logger.info("Betriebsmeldung:" + Debug.NEWLINE + msg);
        }

        public void setTMaxATimeForwardStep(long tMaxSeconds) {
            this.tMaxATimeForwardStep = tMaxSeconds * 1000L;
        }

        public long getTMaxATimeForwardStep() {
            return this.tMaxATimeForwardStep;
        }
    }

    public final class QueryReceiver
    extends DataReceiver {
        private Deserializer deserializer;

        @Override
        public void processData(ResultData rd) {
            if (rd.hasData()) {
                int msgType = rd.getData().getUnscaledValue("nachrichtenTyp").intValue();
                switch (msgType) {
                    case 1: {
                        ArchiveQueryPriority prio;
                        try {
                            prio = this.getQueryPrio(rd);
                        }
                        catch (Exception e) {
                            logger.warning("Die Priorit\u00e4t einer Archivanfrage konnte nicht ermittelt werden: " + String.valueOf(rd), (Object)e.getMessage());
                            prio = ArchiveQueryPriority.MEDIUM;
                        }
                        SignalingQueue<ResultData> archQueue = InQueuesMgr.this.getArchiveQueue(prio);
                        archQueue.add(rd);
                        break;
                    }
                    case 5: {
                        InQueuesMgr.this.queryQueueInfo.add(rd);
                        break;
                    }
                    case 7: {
                        InQueuesMgr.this.backgroundTaskManager.getDeleteSimVarTask().submit(rd);
                        break;
                    }
                    case 4: {
                        InQueuesMgr.this.flowCtrl.processFlowCtrl(rd);
                        break;
                    }
                    case 17: 
                    case 19: {
                        InQueuesMgr.this.backgroundTaskManager.getRequestGapTask().submit(rd);
                        break;
                    }
                    case 21: {
                        InQueuesMgr.this.backgroundTaskManager.getNumQueriesInfoTask().submit(rd);
                        break;
                    }
                    default: {
                        logger.warning("Nachrichtentyp erhalten, der nicht bearbeitet werden kann: " + msgType + " aus: " + Util.rd2Str((ResultData)rd));
                        QueryHandler handler = new QueryHandler("InQueuesMgr", InQueuesMgr.this.archMgr, msgType + 1, rd.getData());
                        handler.sendErrorResponse("Nachrichtentyp erhalten, der nicht bearbeitet werden kann: \"" + rd.getData().getTextValue("nachrichtenTyp").getText() + "\". Die Funktion wird von dieser Version des Archivsystems nicht unterst\u00fctzt.");
                    }
                }
            }
        }

        private ArchiveQueryPriority getQueryPrio(ResultData rd) throws IOException, NoSuchVersionException {
            byte[] data = rd.getData().getUnscaledArray("daten").getByteArray();
            ByteArrayInputStream stream = new ByteArrayInputStream(data, 4, data.length - 4);
            int deserVersion = Util.getSerVersion((byte[])data);
            if (this.deserializer == null || this.deserializer.getVersion() != deserVersion) {
                this.deserializer = SerializingFactory.createDeserializer((int)deserVersion, (InputStream)stream);
            } else {
                this.deserializer.setInputStream((InputStream)stream);
            }
            return ArchiveQueryPriority.getInstance((int)this.deserializer.readInt());
        }
    }

    public final class ArchiveSettingsReceiver
    extends DataReceiver {
        @Override
        public void processData(ResultData rd) {
            logger.finer("Archiveinstellung erhalten: ", (Object)rd);
            if (rd.hasData()) {
                InQueuesMgr.this.backgroundTaskManager.getArchiveSettingsTask().submit(rd);
            }
        }
    }

    public final class DataAckSender
    implements ClientSenderInterface {
        public void sendAck(ResultData rd, long qAspID) throws DataNotSubscribedException, SendSubscriptionNotConfirmed {
            ResultData qRd = new ResultData(rd.getObject(), new DataDescription(rd.getDataDescription().getAttributeGroup(), InQueuesMgr.this.archMgr.getAsp(qAspID)), InQueuesMgr.this.runtimeControl.getSystemTime(), rd.getData());
            InQueuesMgr.this.archMgr.getDavCon().sendData(new ResultData[]{qRd});
        }

        public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
            return true;
        }

        public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
            if (state == 3) {
                logger.warning("Sendesteuerung fuer Quittung '" + String.valueOf(object) + ", " + String.valueOf(dataDescription) + "': STOP_SENDING_NOT_A_VALID_SUBSCRIPTION" + Debug.NEWLINE + "Moeglicherweise ist unter dieser Datenidentifikation bereits eine Quelle angemeldet.");
            } else if (state == 2) {
                logger.warning("Sendesteuerung fuer Quittung " + String.valueOf(object) + ", " + String.valueOf(dataDescription) + " : STOP_SENDING_NO_RIGHTS");
            }
        }
    }

    public abstract sealed class DataReceiver
    implements ClientReceiverInterface
    permits ArchiveDataReceiver, QueryReceiver, ArchiveSettingsReceiver {
        public void update(ResultData[] rds) {
            logger.finer(() -> this.getClass().getSimpleName() + " update(): ResultData[] mit " + rds.length + " Datensaetzen erhalten");
            for (ResultData rd : rds) {
                long dataIndexOffset = InQueuesMgr.this.runtimeControl.getDataIndexOffset();
                if (dataIndexOffset != 0L || InQueuesMgr.this.runtimeControl.fixNoSourceDataTime()) {
                    byte errorFlag = (byte)(rd.getDataType().getCode() - 1);
                    long dataTime = rd.getDataTime();
                    if (InQueuesMgr.this.runtimeControl.fixNoSourceDataTime() && rd.getDataType().equals(DataState.NO_SOURCE)) {
                        dataTime = InQueuesMgr.this.runtimeControl.getSystemTime();
                    }
                    rd = new ResultData(rd.getObject(), rd.getDataDescription(), rd.isDelayedData(), rd.getDataIndex() + dataIndexOffset, dataTime, errorFlag, rd.getData());
                }
                if (InQueuesMgr.this.terminated) {
                    return;
                }
                if (this.isInitialNoSourceDS(rd)) continue;
                this.processData(rd);
            }
        }

        private boolean isInitialNoSourceDS(ResultData rd) {
            return Util.dIdxSrcSubscrTime((ResultData)rd) == 0L && Util.dIdxLfdnr((ResultData)rd) == 0;
        }

        public abstract void processData(ResultData var1);
    }
}

