/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt;

import de.bsvrz.ars.ars.mgmt.simulation.SimulationResultData;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.AttributeGroupUsage;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectCollection;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.dataIdentificationSettings.DataIdentification;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SimVarParamExtracter {
    /*
     * WARNING - void declaration
     */
    public static void extractSettings(SimulationResultData result, DataModel configuration, Map<DataIdentification, Data> newSettings, short simVar) {
        Data data = result.getData();
        Debug.getLogger().finer("Parametrierte Daten fuer Simulationsvariante " + result.getSimVar() + " = " + String.valueOf(data));
        if (data == null) {
            return;
        }
        Data parameterArray = data.getItem("ParameterSatz");
        for (Data parameter : parameterArray) {
            SystemObject[] specifiedConfigAreas = parameter.getReferenceArray("Bereich").getSystemObjectArray();
            specifiedConfigAreas = SimVarParamExtracter.removeNullReferences(specifiedConfigAreas);
            Data ack = parameter.getItem("Quittieren");
            for (Data dataSpec : parameter.getItem("Eingangsdaten")) {
                ArrayList<Object> objectList;
                SystemObject[] specifiedObjects = dataSpec.getReferenceArray("Objekt").getSystemObjectArray();
                specifiedObjects = SimVarParamExtracter.removeNullReferences(specifiedObjects);
                Object[] specifiedAtgs = dataSpec.getReferenceArray("AttributGruppe").getSystemObjectArray();
                specifiedAtgs = SimVarParamExtracter.removeNullReferences((SystemObject[])specifiedAtgs);
                Arrays.sort(specifiedAtgs);
                Object[] specifiedAspects = dataSpec.getReferenceArray("Aspekt").getSystemObjectArray();
                specifiedAspects = SimVarParamExtracter.removeNullReferences((SystemObject[])specifiedAspects);
                Arrays.sort(specifiedAspects);
                if (specifiedObjects.length == 0) {
                    dynamicObjects = Objects.requireNonNull(configuration.getType("typ.dynamischesObjekt"), "typ.dynamischesObjekt unbekannt").getObjects();
                    List configurationObjects = Objects.requireNonNull(configuration.getType("typ.konfigurationsObjekt"), "typ.konfigurationsObjekt unbekannt").getObjects();
                    objectList = new ArrayList(dynamicObjects.size() + configurationObjects.size());
                    objectList.addAll((Collection<Object>)dynamicObjects);
                    objectList.addAll(configurationObjects);
                } else {
                    void var18_20;
                    objectList = new ArrayList<Object>(specifiedObjects.length);
                    dynamicObjects = specifiedObjects;
                    int configurationObjects = dynamicObjects.length;
                    boolean bl = false;
                    while (var18_20 < configurationObjects) {
                        SystemObject systemObject = dynamicObjects[var18_20];
                        if (systemObject instanceof SystemObjectCollection) {
                            SystemObjectCollection collection = (SystemObjectCollection)systemObject;
                            objectList.addAll(collection.getElements());
                        } else {
                            objectList.add(systemObject);
                        }
                        ++var18_20;
                    }
                }
                if (specifiedConfigAreas.length > 0) {
                    List<SystemObject> specifiedConfigAreaList = Arrays.asList(specifiedConfigAreas);
                    LinkedList<SystemObject> newObjectList = new LinkedList<SystemObject>();
                    for (SystemObject systemObject : objectList) {
                        ConfigurationArea configurationArea = systemObject.getConfigurationArea();
                        if (!specifiedConfigAreaList.contains(configurationArea)) continue;
                        newObjectList.add(systemObject);
                    }
                    objectList.clear();
                    objectList.addAll(newObjectList);
                }
                TreeMap<SystemObjectType, Collection> type2objectSetMap = new TreeMap<SystemObjectType, Collection>();
                for (SystemObject systemObject : objectList) {
                    SystemObjectType systemObjectType = systemObject.getType();
                    type2objectSetMap.computeIfAbsent(systemObjectType, k -> new LinkedList()).add(systemObject);
                }
                objectList.clear();
                for (Map.Entry entry : type2objectSetMap.entrySet()) {
                    SystemObjectType systemObjectType = (SystemObjectType)entry.getKey();
                    Collection objectCollection = (Collection)entry.getValue();
                    List typeAtgs = systemObjectType.getAttributeGroups();
                    for (AttributeGroup typeAtg : typeAtgs) {
                        if (specifiedAtgs.length > 0 && Arrays.binarySearch(specifiedAtgs, typeAtg) < 0) continue;
                        Collection atgUsages = typeAtg.getAttributeGroupUsages();
                        for (AttributeGroupUsage atgUsage : atgUsages) {
                            if (atgUsage.isConfigurating() || specifiedAspects.length > 0 && Arrays.binarySearch(specifiedAspects, atgUsage.getAspect()) < 0) continue;
                            for (SystemObject object : objectCollection) {
                                DataIdentification key = new DataIdentification(object, new DataDescription(typeAtg, atgUsage.getAspect(), simVar));
                                newSettings.put(key, ack);
                            }
                        }
                    }
                }
            }
        }
    }

    private static SystemObject[] removeNullReferences(SystemObject[] objects) {
        int numberOfNonNullObjects = 0;
        for (SystemObject object1 : objects) {
            if (object1 == null) continue;
            ++numberOfNonNullObjects;
        }
        if (numberOfNonNullObjects != objects.length) {
            SystemObject[] trimmedObjects = new SystemObject[numberOfNonNullObjects];
            int trimmedIndex = 0;
            for (SystemObject object : objects) {
                if (object == null) continue;
                trimmedObjects[trimmedIndex++] = object;
            }
            return trimmedObjects;
        }
        return objects;
    }
}

