/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.commands.ArSCmdInterface;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ArSQuitCmdSender {
    public static void main(String[] args) {
        int portNum = 0;
        String host = "localhost";
        if (args.length == 1) {
            try {
                portNum = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.out.println("Fehler: keine gueltige Portnummer: " + args[0]);
                System.exit(1);
            }
        } else if (args.length == 2) {
            host = args[0];
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("Fehler: keine gueltige Portnummer: " + args[1]);
                System.exit(1);
            }
        } else {
            System.out.println("Fehler: falsche Parameterzahl. Korrekte Verwendung\n  " + ArSQuitCmdSender.class.getSimpleName() + " [host] port");
            System.exit(1);
        }
        try {
            ArSCmdInterface.sendQuitCmd(host, portNum);
        }
        catch (UnknownHostException e) {
            System.out.println("Fehler: Host '" + host + "' nicht gefunden");
            System.exit(1);
        }
        catch (SocketTimeoutException e) {
            System.out.println("Fehler: Keine Antwort vom Archivsystem unter " + host + ":" + portNum + " nach 300 Sekunden");
            System.exit(1);
        }
        catch (IOException e) {
            if (e.getMessage().endsWith("Connection reset")) {
                System.out.println("OK - Archivsystem unter " + host + ":" + portNum + " beendet.");
                System.exit(0);
            }
            System.out.println("Fehler: Kommunikation zum Archivsystem unter " + host + ":" + portNum + " fehlgeschlagen: " + e.getMessage());
            System.exit(1);
        }
    }
}

