/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ArchiveMonitor
extends Thread {
    private static final String BAR = "##################################################";
    private static final String BLANK = "                                                  ";
    private static final ThreadLocal<DateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd.MM.yyyy  HH:mm:ss,SSS"));
    private final int uInt;
    private final ArchiveManager aMgr;
    private final Command cmd;
    private boolean terminated;

    public ArchiveMonitor(ArchiveManager am, int updateInterval, Command command) {
        this.aMgr = am;
        this.uInt = updateInterval;
        this.cmd = command;
    }

    public void terminate() {
        this.terminated = true;
        this.interrupt();
    }

    @Override
    public void run() {
        int oldQueueLoad = -1;
        while (!this.terminated) {
            try {
                int queueLoad = this.aMgr.getInQueuesMgr().countDataInQueues();
                if (queueLoad != oldQueueLoad) {
                    try {
                        this.cmd.printlnPlain("               ------------- " + dateFormat.get().format(new Date()) + " -------------");
                        double loadFraction = (double)queueLoad / (double)this.aMgr.getInQueuesMgr().getArchiveQueueCapacity();
                        int filledBarLength = (int)(loadFraction * (double)BAR.length());
                        this.cmd.printlnPlain(String.format("Queue: %12d ", queueLoad) + "[" + BAR.substring(0, filledBarLength) + BLANK.substring(0, BLANK.length() - filledBarLength) + "] " + String.format("%3d%%", (int)(loadFraction * 100.0)));
                    }
                    catch (Exception e) {
                        break;
                    }
                    oldQueueLoad = queueLoad;
                }
                ArchiveMonitor.sleep(this.uInt);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

