/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentNode;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentTree;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public final class DataIdentInfo
extends Command {
    private static final String PAGER = " (vor: [enter], zurueck: <[enter])";
    private final ArchiveManager archMgr;
    private final DataIdentTree tree;
    private DataModel model;
    private boolean stopCmd;
    private static final int linesPerPage = 40;
    private static final int maxPerLine = 77;
    @Nullable
    private List<SystemObject> _objects;
    private int _selectedObject = -1;
    @Nullable
    private List<SystemObject> _atgs;
    private int _selectedAtg = -1;
    @Nullable
    private List<SystemObject> _asps;
    private int _selectedAsp = -1;
    @Nullable
    private int[] _simVars;
    private int _selectedSimVar = -2;

    public DataIdentInfo(ArchiveManager am) {
        super("Informationen zu einer Datenidentifikation", "Detailierte Informationen zu einer bestimmten Datenidentifikation abrufen.");
        this.archMgr = am;
        this.tree = this.archMgr.getPersistenceManager().getDataIdentTree();
        this.resetInput();
    }

    public void execute() throws Exception {
        this.resetInput();
        this.println("");
        this.printlnPlain("    Bedienung:");
        this.printlnPlain("      <Zahl>           Auswahl");
        this.printlnPlain("      obj,atg,asp,sv   Direktauswahl (ID oder PID)");
        this.printlnPlain("      q                Abbrechen");
        this.printlnPlain("      ^                Neue Auswahl");
        this.printBlank(2);
        this.printlnPlain("Weiter mit [Enter]");
        this.model = this.archMgr.getDataModel();
        if (this.model == null) {
            this.printlnPlain("Abbruch (Datenverteiler nicht bereit).");
            this.stopCmd = true;
        }
        String input = this.getUserInput();
        try {
            this.getDirectNavigation(input);
        }
        catch (Exception confEx) {
            this.printlnPlain("Datenidentifikation ist teilweise ungueltig,");
        }
        if (!this.stopCmd && this._selectedObject == -1) {
            this._objects = DataIdentInfo.sortArray(this.tree.getObjects(this.model));
            this._selectedObject = this.getObject(this._objects);
            if (this._selectedObject == -1) {
                this.stopCmd = true;
            }
        }
        if (!this.stopCmd && this._selectedAtg == -1) {
            this._atgs = DataIdentInfo.sortArray(this.tree.getAtgs(this._objects.get(this._selectedObject).getId(), this.model));
            this._selectedAtg = this.getAtg(this._atgs);
            if (this._selectedAtg == -1) {
                this.stopCmd = true;
            }
        }
        if (!this.stopCmd && this._selectedAsp == -1) {
            this._asps = DataIdentInfo.sortArray(this.tree.getAsps(this._objects.get(this._selectedObject).getId(), this._atgs.get(this._selectedAtg).getId(), this.model));
            this._selectedAsp = this.getAsp(this._asps);
            if (this._selectedAsp == -1) {
                this.stopCmd = true;
            }
        }
        if (!this.stopCmd && this._selectedSimVar == -2) {
            this._simVars = this.tree.getSimVars(this._objects.get(this._selectedObject).getId(), this._atgs.get(this._selectedAtg).getId(), this._asps.get(this._selectedAsp).getId());
            this._selectedSimVar = this.getSelectedSimVar();
            if (this._selectedSimVar == -2) {
                this.stopCmd = true;
            }
        }
        Vector<String[]> info = new Vector<String[]>(4);
        if (!this.stopCmd) {
            info.add(new String[]{this._objects.get(this._selectedObject).getName(), this._objects.get(this._selectedObject).getPid(), String.valueOf(this._objects.get(this._selectedObject).getId())});
            info.add(new String[]{this._atgs.get(this._selectedAtg).getName(), this._atgs.get(this._selectedAtg).getPid(), String.valueOf(this._atgs.get(this._selectedAtg).getId())});
            info.add(new String[]{this._asps.get(this._selectedAsp).getName(), this._asps.get(this._selectedAsp).getPid(), String.valueOf(this._asps.get(this._selectedAsp).getId())});
            info.add(new String[]{String.valueOf(this._selectedSimVar)});
        }
        if (!this.stopCmd) {
            this.printInfo(this._objects.get(this._selectedObject).getId(), this._atgs.get(this._selectedAtg).getId(), this._asps.get(this._selectedAsp).getId(), this._selectedSimVar, info);
        }
    }

    public void resetInput() {
        this.stopCmd = false;
        this._objects = null;
        this._selectedObject = -1;
        this._atgs = null;
        this._selectedAtg = -1;
        this._asps = null;
        this._selectedAsp = -1;
        this._simVars = null;
        this._selectedSimVar = -2;
    }

    public void getDirectNavigation(@Nullable String input) {
        if (input != null) {
            String[] di = input.split(",");
            if (!di[0].isEmpty()) {
                long objId;
                try {
                    objId = Long.parseLong(di[0]);
                }
                catch (NumberFormatException nfEx) {
                    objId = this.model.getObject(di[0]).getId();
                }
                if (objId != 0L) {
                    this._objects = this.tree.getObjects(this.model);
                    for (int i = 0; i < this._objects.size(); ++i) {
                        if (this._objects.get(i).getId() != objId) continue;
                        this._selectedObject = i;
                    }
                }
            }
            if (di.length > 1 && !di[1].isEmpty()) {
                long atgId;
                try {
                    atgId = Long.parseLong(di[1]);
                }
                catch (NumberFormatException nfEx) {
                    atgId = this.model.getObject(di[1]).getId();
                }
                if (atgId != -10L) {
                    this._atgs = this.tree.getAtgs(this._objects.get(this._selectedObject).getId(), this.model);
                    for (int i = 0; i < this._atgs.size(); ++i) {
                        if (this._atgs.get(i).getId() != atgId) continue;
                        this._selectedAtg = i;
                    }
                }
            }
            if (di.length > 2 && !di[2].isEmpty()) {
                long aspId;
                try {
                    aspId = Long.parseLong(di[2]);
                }
                catch (NumberFormatException nfEx) {
                    aspId = this.model.getObject(di[2]).getId();
                }
                if (aspId != -10L) {
                    this._asps = this.tree.getAsps(this._objects.get(this._selectedObject).getId(), this._atgs.get(this._selectedAtg).getId(), this.model);
                    for (int i = 0; i < this._asps.size(); ++i) {
                        if (this._asps.get(i).getId() != aspId) continue;
                        this._selectedAsp = i;
                    }
                }
            }
            if (di.length > 3) {
                block21: {
                    try {
                        this._selectedSimVar = Integer.parseInt(di[3]);
                    }
                    catch (NumberFormatException nfEx) {
                        if (!di[3].isEmpty()) break block21;
                        this._selectedSimVar = 0;
                    }
                }
                if (this._selectedSimVar != -2) {
                    this._simVars = this.tree.getSimVars(this._objects.get(this._selectedObject).getId(), this._atgs.get(this._selectedAtg).getId(), this._asps.get(this._selectedAsp).getId());
                    for (int i = 0; i < this._simVars.length; ++i) {
                        if (this._simVars.length != this._selectedSimVar) continue;
                        this._selectedSimVar = i;
                    }
                }
            }
        }
    }

    public int getObject(List<SystemObject> objects) throws Exception {
        this.printlnPlain("Objekt waehlen (" + objects.size() + "):");
        int obj = -1;
        int page = 0;
        for (int i = 0; i < objects.size() && !this.stopCmd; ++i) {
            String objOut = "  " + i + ":\t" + objects.get(i).getId() + ", " + objects.get(i).getPid() + ", " + objects.get(i).getName();
            objOut = objOut.length() > 77 ? objOut.substring(0, 74) + "..." : objOut;
            this.printlnPlain(objOut);
            if ((i + 1) % 40 == 0 || i + 1 == objects.size()) {
                String input;
                ++page;
                if (1 + (objects.size() - 1) / 40 > 1) {
                    this.printlnPlain("Seite " + page + " von " + (1 + (objects.size() - 1) / 40) + PAGER);
                }
                if ((input = this.getUserInput()) == null) break;
                if (input.equals("<")) {
                    page = i > 40 ? page - 2 : 0;
                    i = i > 40 ? i - 80 : -1;
                } else if (input.equals(">") || input.isEmpty()) {
                    if (objects.size() == 1) {
                        obj = 0;
                    }
                } else if (input.equals("^")) {
                    this.execute();
                    this.stopCmd = true;
                } else {
                    try {
                        obj = Integer.parseInt(input);
                        if (obj < objects.size()) break;
                        obj = this.getObject(objects);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (i != objects.size() - 1 || obj != -1) continue;
            i = 0;
            page = 0;
        }
        return obj;
    }

    public int getAtg(List<SystemObject> atgs) throws Exception {
        this.printlnPlain("Attributgruppe waehlen (" + atgs.size() + "):");
        int atg = -1;
        int page = 0;
        for (int i = 0; i < atgs.size() && !this.stopCmd; ++i) {
            String objOut = "  " + i + ":\t" + atgs.get(i).getId() + ", " + atgs.get(i).getPid() + ", " + atgs.get(i).getName();
            objOut = objOut.length() > 77 ? objOut.substring(0, 74) + "..." : objOut;
            this.printlnPlain(objOut);
            if ((i + 1) % 40 == 0 || i + 1 == atgs.size()) {
                String input;
                ++page;
                if (1 + (atgs.size() - 1) / 40 > 1) {
                    this.printlnPlain("Seite " + page + " von " + (1 + (atgs.size() - 1) / 40) + PAGER);
                }
                if ((input = this.getUserInput()) == null) break;
                if (input.equals("<")) {
                    page = i > 40 ? page - 2 : 0;
                    i = i > 40 ? i - 80 : -1;
                } else if (input.equals(">") || input.isEmpty()) {
                    if (atgs.size() == 1) {
                        atg = 0;
                    }
                } else if (input.equals("^")) {
                    this.execute();
                    this.stopCmd = true;
                } else {
                    try {
                        atg = Integer.parseInt(input);
                        if (atg < atgs.size()) break;
                        atg = this.getAtg(atgs);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (i != atgs.size() - 1 || atg != -1) continue;
            i = 0;
            page = 0;
        }
        return atg;
    }

    public int getAsp(List<SystemObject> asps) throws Exception {
        this.printlnPlain("Aspekt waehlen (" + asps.size() + "):");
        int asp = -1;
        int page = 0;
        for (int i = 0; i < asps.size() && !this.stopCmd; ++i) {
            String objOut = "  " + i + ":\t" + asps.get(i).getId() + ", " + asps.get(i).getPid() + ", " + asps.get(i).getName();
            objOut = objOut.length() > 77 ? objOut.substring(0, 74) + "..." : objOut;
            this.printlnPlain(objOut);
            if ((i + 1) % 40 == 0 || i + 1 == asps.size()) {
                String input;
                ++page;
                if (1 + (asps.size() - 1) / 40 > 1) {
                    this.printlnPlain("Seite " + page + " von " + (1 + (asps.size() - 1) / 40) + PAGER);
                }
                if ((input = this.getUserInput()) == null) break;
                if (input.equals("<")) {
                    page = i > 40 ? page - 2 : 0;
                    i = i > 40 ? i - 80 : -1;
                } else if (input.equals(">") || input.isEmpty()) {
                    if (asps.size() == 1) {
                        asp = 0;
                    }
                } else if (input.equals("^")) {
                    this.execute();
                    this.stopCmd = true;
                } else {
                    try {
                        asp = Integer.parseInt(input);
                        if (asp < asps.size()) break;
                        asp = this.getAsp(asps);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (i != asps.size() - 1 || asp != -1) continue;
            i = -1;
            page = 0;
        }
        return asp;
    }

    public int getSelectedSimVar() throws Exception {
        assert (this._simVars != null);
        this.printlnPlain("Simulationsvariante waehlen (" + this._simVars.length + "):");
        int simVar = -2;
        int page = 0;
        for (int i = 0; i < this._simVars.length && !this.stopCmd; ++i) {
            this.printlnPlain("  " + i + ":\tSimVar " + this._simVars[i]);
            if ((i + 1) % 40 == 0 || i + 1 == this._simVars.length) {
                String input;
                ++page;
                if (1 + (this._simVars.length - 1) / 40 > 1) {
                    this.printlnPlain("Seite " + page + " von " + (1 + (this._simVars.length - 1) / 40) + PAGER);
                }
                if ((input = this.getUserInput()) == null) break;
                if (input.equals("<")) {
                    page = i > 40 ? page - 2 : 0;
                    i = i > 40 ? i - 80 : -1;
                } else if (input.equals(">") || input.isEmpty()) {
                    if (this._simVars.length == 1) {
                        simVar = 0;
                    }
                } else if (input.equals("^")) {
                    this.execute();
                    this.stopCmd = true;
                } else {
                    try {
                        simVar = Integer.parseInt(input);
                        if (simVar < this._simVars.length) break;
                        simVar = this.getSelectedSimVar();
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (i != this._simVars.length - 1 || simVar != -2) continue;
            i = 0;
            page = 0;
        }
        return simVar;
    }

    public void printInfo(long objId, long atgId, long aspId, int simVar, Vector<String[]> info) throws Exception {
        this.printlnPlain("Datenidentifikation:");
        try {
            int p = 20;
            this.printlnPlain(Util.sr((String)"  Objekt", (int)p) + info.get(0)[0]);
            this.printlnPlain(Util.sr((String)"", (int)p) + info.get(0)[2]);
            this.printlnPlain(Util.sr((String)"", (int)p) + info.get(0)[1]);
            this.printlnPlain(Util.sr((String)"  AttGrp", (int)p) + info.get(1)[0]);
            this.printlnPlain(Util.sr((String)"", (int)p) + info.get(1)[2]);
            this.printlnPlain(Util.sr((String)"", (int)p) + info.get(1)[1]);
            this.printlnPlain(Util.sr((String)"  Aspekt", (int)p) + info.get(2)[0]);
            this.printlnPlain(Util.sr((String)"", (int)p) + info.get(2)[2]);
            this.printlnPlain(Util.sr((String)"", (int)p) + info.get(2)[1]);
            this.printlnPlain(Util.sr((String)"  SimVar", (int)p) + info.get(3)[0]);
            DataIdentNode din = this.tree.get(new IdDataIdentification(objId, atgId, aspId, simVar));
            this.printlnPlain(Util.sr((String)"  Archivieren", (int)p) + (din.arSParamIsArchivieren() ? "ja" : "nein"));
            if (din.arSParamIsNachfordern()) {
                this.printlnPlain(Util.sr((String)"  Nachfordern", (int)p) + din.arSParamGetNachfordern(0));
                for (int i = 1; i < din.arSParamGetAnzNachfordern(); ++i) {
                    this.printlnPlain(Util.sr((String)"", (int)p) + din.arSParamGetNachfordern(i));
                }
            } else {
                this.printlnPlain(Util.sr((String)"  Nachfordern", (int)p) + "nein");
            }
            if (din.arSParamIsQuittieren()) {
                SystemObject object = this.model.getObject(din.arSParamGetQuittieren());
                if (object == null) {
                    this.printlnPlain(Util.sr((String)"  Quittieren", (int)p) + din.arSParamGetQuittieren() + " (unbekannt!)");
                } else {
                    String quitAspPid = object.getPid();
                    this.printlnPlain(Util.sr((String)"  Quittieren", (int)p) + din.arSParamGetQuittieren() + " (" + quitAspPid + ")");
                    if (din.arSParamIsArchivieren()) {
                        this.printlnPlain(Util.sr((String)"    gueltig", (int)p) + (din.arSParamIsQuittierenValid() ? "ja" : "nein"));
                    }
                }
            } else {
                this.printlnPlain(Util.sr((String)"  Quittieren", (int)p) + "nein");
            }
            this.printlnPlain(Util.sr((String)"  Parametriert", (int)p) + (din.isArSParameterized() ? "ja" : "nein"));
            this.printlnPlain("");
            this.printlnPlain("Beenden mit [Enter], Neustart mit [^].");
            if (this.readln().equalsIgnoreCase("^")) {
                this.execute();
            }
        }
        catch (Exception e) {
            this.printlnPlain("Fehler: (" + e.getMessage() + ")");
        }
    }

    private static ArrayList<SystemObject> sortArray(Collection<? extends SystemObject> in) {
        ArrayList<SystemObject> result = new ArrayList<SystemObject>(in);
        result.sort((a, b) -> a.getPid().compareToIgnoreCase(b.getPid()));
        return result;
    }

    public String getUserInput() throws Exception {
        String input = this.readln();
        if (input.equals("q")) {
            this.stopCmd = true;
            return null;
        }
        return input;
    }

    public void printBlank(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            this.printlnPlain("");
        }
    }
}

