/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.commands;

import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.TimeBasedPersistenceDirectoryManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.ars.ars.persistence.sequence.AllDataSpecification;
import de.bsvrz.sys.funclib.losb.util.cmdinterface.Command;
import java.util.List;

public class ListPersistenceDirectoriesCommand<T extends TimeRange<T>>
extends Command {
    private final TimeBasedPersistenceDirectoryManager<T> directoryManager;

    public ListPersistenceDirectoriesCommand(TimeBasedPersistenceDirectoryManager<T> directoryManager) {
        super("Verzeichnisse auflisten", "");
        this.directoryManager = directoryManager;
    }

    public void execute() throws Exception {
        List<PersistenceDirectory> persistenceDirectories = this.directoryManager.getPersistenceDirectories(0, AllDataSpecification.Instance);
        TimeRange prevTimeRange = null;
        for (PersistenceDirectory persistenceDirectory : persistenceDirectories) {
            T timeRange = this.directoryManager.getId(persistenceDirectory.getBasePath());
            while (prevTimeRange != null && !((TimeRange)prevTimeRange.next()).equals(timeRange)) {
                prevTimeRange = (TimeRange)prevTimeRange.next();
                this.printlnPlain("  " + String.valueOf(this.directoryManager.getDomain().getPath(prevTimeRange)) + ": Verzeichnis fehlt.");
            }
            prevTimeRange = timeRange;
            this.printlnPlain("  " + String.valueOf(this.directoryManager.getDomain().getPath(timeRange)) + " mit mind. " + persistenceDirectory.estimate() + " Datenidentifikationen, davon " + persistenceDirectory.getLargeDataIdentifications().size() + " mit vielen Containerdateien.");
        }
    }
}

