/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.datatree;

import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;

public final class DataIdentNode {
    private static final byte INVALID = -1;
    private static final int FLAG_INVALID_ACK_ID = 1;
    private static final int FLAG_FIRST_OA_DATA_AFTER_SUBSCRIPTION = 2;
    private static final int FLAG_FIRST_ON_DATA_AFTER_SUBSCRIPTION = 4;
    private static final int FLAG_LAST_DATA_NO_SOURCE_ASSIGNED = 128;
    private static final int FLAG_LAST_DATA_NO_SOURCE = 256;
    private static final int FLAG_HAS_VALID_DATA = 512;
    private int _flags;
    private final IdDataIdentification _dataIdentification;
    private long _unsubscriptionTime = -1L;
    @Nullable
    private Data _arsParams;

    public DataIdentNode(IdDataIdentification dataIdentification) {
        this._dataIdentification = dataIdentification;
    }

    public boolean lastDataNoSourceAssigned() {
        return this.getFlag(128);
    }

    public boolean lastDataWasNoSource() {
        return this.getFlag(256);
    }

    public void setLastOAWasNoSource(boolean lastOADataWasNoSource) {
        this.setFlag(128, true);
        this.setFlag(256, lastOADataWasNoSource);
    }

    public void setFirstDataAfterSubscription(ArchiveDataKind adk, boolean value) {
        if (adk == ArchiveDataKind.ONLINE) {
            this.setFlag(2, value);
        } else if (adk == ArchiveDataKind.ONLINE_DELAYED) {
            this.setFlag(4, value);
        }
    }

    private void setFlag(int flag, boolean value) {
        this._flags = value ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    private boolean getFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    public boolean isFirstDataAfterSubscription(ArchiveDataKind adk) {
        if (adk == ArchiveDataKind.ONLINE) {
            return this.getFlag(2);
        }
        if (adk == ArchiveDataKind.ONLINE_DELAYED) {
            return this.getFlag(4);
        }
        return false;
    }

    public void arsParamSetParams(@Nullable Data params) {
        this._arsParams = params;
    }

    public boolean arSParamIsArchivieren() {
        if (this._arsParams == null) {
            return false;
        }
        try {
            return this._arsParams.getUnscaledValue("Archivieren").intValue() > 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean arSParamIsNachfordern() {
        if (this._arsParams == null) {
            return false;
        }
        try {
            return this._arsParams.getArray("Nachfordern").getLength() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int arSParamGetAnzNachfordern() {
        if (this._arsParams == null) {
            return 0;
        }
        try {
            return this._arsParams.getArray("Nachfordern").getLength();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Nullable
    public String arSParamGetNachfordern(int at) {
        if (this.arSParamIsNachfordern()) {
            assert (this._arsParams != null);
            return this._arsParams.getArray("Nachfordern").getItem(at).asTextValue().getValueText();
        }
        return null;
    }

    public long arSParamGetQuittieren() {
        if (this._arsParams == null) {
            return -1L;
        }
        try {
            Data.Array qt = this._arsParams.getArray("Quittieren");
            if (qt == null || qt.getLength() <= 0) {
                return -1L;
            }
            SystemObject so = qt.getItem(0).asReferenceValue().getSystemObject();
            return so == null ? -1L : so.getId();
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    public boolean arSParamIsQuittieren() {
        return this.arSParamGetQuittieren() != -1L;
    }

    public boolean arSParamIsQuittierenValid() {
        return this.arSParamIsQuittieren() && !this.getFlag(1);
    }

    public void arSParamMarkQuittierenInvalid(boolean invalid) {
        this.setFlag(1, invalid);
    }

    public boolean isArSParameterized() {
        return this._arsParams != null;
    }

    public void setValidData(boolean value) {
        this.setFlag(512, value);
    }

    public boolean hasValidData() {
        return this.getFlag(512);
    }

    public long getUnsubscriptionTime() {
        return this._unsubscriptionTime;
    }

    public void setUnsubscriptionTime(long value) {
        this._unsubscriptionTime = value;
    }

    public String toString() {
        String erg = "DataIdentNode " + String.valueOf(this._dataIdentification) + " mit ArchivParam: a=" + (this.arSParamIsArchivieren() ? "T" : "F");
        StringBuilder list = new StringBuilder();
        if (this.arSParamIsNachfordern()) {
            for (int i = 0; i < this.arSParamGetAnzNachfordern(); ++i) {
                list.append(this.arSParamGetNachfordern(i)).append(",");
            }
        }
        erg = erg + " n=[" + Util.removeLastChar((String)list.toString()) + "]";
        erg = erg + " q=" + this.arSParamGetQuittieren();
        return erg;
    }

    public IdDataIdentification getDataIdentification() {
        return this._dataIdentification;
    }
}

