/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.datatree;

import de.bsvrz.ars.ars.mgmt.datatree.IndexId;
import de.bsvrz.ars.ars.mgmt.datatree.IndexImpl;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.RebuildResult;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndex;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndexImpl;
import de.bsvrz.ars.ars.persistence.index.ContainerManagementIndex;
import de.bsvrz.ars.ars.persistence.index.CorruptIndexException;
import de.bsvrz.ars.ars.persistence.index.DataIndexAndArchiveTimeIndex;
import de.bsvrz.ars.ars.persistence.index.DataIndexIndex;
import de.bsvrz.ars.ars.persistence.index.DataIndexIndexImpl;
import de.bsvrz.ars.ars.persistence.index.DataTimeIndex;
import de.bsvrz.ars.ars.persistence.index.DataTimeIndexImpl;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.backend.management.BaseIndex;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class IndexTree {
    private static final Debug _debug = Debug.getLogger();
    public static final long ENTRIES_WARN_LIMIT = 32767L;
    private final ThreadLocal<Map<IndexId, Object>> _cache = ThreadLocal.withInitial(HashMap::new);
    private static final Object NO_INDEX = new Object();
    private final PersistenceDirectory _persistenceDirectory;
    private final int _dataTimeSize;
    private final int _dataIndexSize;
    private final int _archiveTimeSize;
    private final int _managementIndexSize;

    public IndexTree(int maximumIndexSizeBytes, PersistenceDirectory persistenceDirectory) {
        this._dataTimeSize = Math.min(1, maximumIndexSizeBytes / DataTimeIndexImpl.entrySize());
        this._dataIndexSize = Math.min(1, maximumIndexSizeBytes / DataIndexIndexImpl.entrySize());
        this._archiveTimeSize = Math.min(1, maximumIndexSizeBytes / ArchiveTimeIndexImpl.entrySize());
        this._managementIndexSize = Math.min(1, maximumIndexSizeBytes / ContainerManagementIndex.entrySize());
        this._persistenceDirectory = persistenceDirectory;
    }

    public void closeIndexes() {
        Map<IndexId, Object> indexMap = this._cache.get();
        for (Object value : indexMap.values()) {
            if (!(value instanceof BaseIndex)) continue;
            BaseIndex baseIndex = (BaseIndex)value;
            try {
                baseIndex.close();
            }
            catch (IndexException e) {
                _debug.warning("Fehler beim Schlie\u00dfen eines Index", (Throwable)e);
            }
        }
        indexMap.clear();
    }

    private Optional<? extends BaseIndex<? extends Enum<?>>> loadIndexFromDisk(@NotNull IndexId key, LockedContainerDirectory containerDirectory) throws IndexException {
        ContainerManagementIndex cmi;
        BaseIndex<? extends Enum<?>> baseIndex;
        Optional<BaseIndex<Enum<?>>> index = this.loadIndexFromDiskHelper(key, containerDirectory);
        if (index.isPresent() && (baseIndex = index.get()) instanceof ContainerManagementIndex && (cmi = (ContainerManagementIndex)baseIndex).numEntries() > 32767L) {
            this._persistenceDirectory.warnAboutHugeContainerDirectory(this._persistenceDirectory.getLayoutInstance().getContainerDirectory(cmi), cmi.numEntries());
        }
        return index;
    }

    private Optional<? extends BaseIndex<? extends Enum<?>>> loadIndexFromDiskHelper(@NotNull IndexId key, LockedContainerDirectory containerDirectory) throws IndexException {
        Path indexFile = key.toFile(this._persistenceDirectory);
        if (!Files.exists(indexFile, new LinkOption[0])) {
            if (!Files.exists(indexFile.getParent(), new LinkOption[0])) {
                return Optional.empty();
            }
            return this.rebuildIndex(key, indexFile, containerDirectory);
        }
        try {
            return Optional.of(this.openIndex(key, indexFile));
        }
        catch (CorruptIndexException e) {
            try {
                Files.deleteIfExists(indexFile);
            }
            catch (IOException ioException) {
                IndexException subExp = new IndexException("Defekter Index konnte nicht gel\u00f6scht werden", indexFile, ioException);
                subExp.addSuppressed(e);
                throw subExp;
            }
            return this.rebuildIndex(key, indexFile, containerDirectory);
        }
    }

    private Optional<? extends BaseIndex<? extends Enum<?>>> rebuildIndex(IndexId indexId, Path indexFile, LockedContainerDirectory containerDirectory) throws IndexException {
        if (indexId.getIndexClass() == IndexImpl.ManagementData) {
            return this.rebuildContainerHeaderIndex(indexId, indexFile, null);
        }
        return this.rebuildStandardIndex(indexId, indexFile, containerDirectory);
    }

    private Optional<BaseIndex<IndexValues>> rebuildStandardIndex(IndexId indexId, Path indexFile, LockedContainerDirectory containerDirectory) throws IndexException {
        IndexId managementId = new IndexId(indexId.getContainerFileDir(), IndexImpl.ManagementData);
        Optional managementIndex = this.cacheIndex(managementId, () -> this.loadIndexFromDisk(managementId, containerDirectory));
        if (managementIndex.isEmpty()) {
            return Optional.empty();
        }
        return this.rebuildStandardIndex(indexId, indexFile, (ContainerManagementIndex)managementIndex.get(), containerDirectory);
    }

    private Optional<BaseIndex<IndexValues>> rebuildStandardIndex(IndexId indexId, Path indexFile, ContainerManagementIndex managementIndex, LockedContainerDirectory containerDirectory) throws IndexException {
        this.deleteIndex(indexId);
        Optional<BaseIndex<IndexValues>> index = this.cacheIndex(indexId, () -> Optional.of(this.openIndex(indexId, indexFile)));
        if (index.isPresent()) {
            this._persistenceDirectory.rebuildStandardIndex(managementIndex, index.get(), containerDirectory);
        }
        return index;
    }

    private Optional<ContainerManagementIndex> rebuildContainerHeaderIndex(IndexId indexId, Path indexFile, @Nullable RebuildResult rebuildResult) throws IndexException {
        this.deleteIndex(indexId);
        Optional<ContainerManagementIndex> index = this.cacheIndex(indexId, () -> Optional.of(this.openIndex(indexId, indexFile)));
        if (index.isPresent()) {
            this._persistenceDirectory.rebuildContainerHeaderIndex(indexId.getContainerFileDir(), index.get(), rebuildResult);
        }
        return index;
    }

    private void invalidateNow(IndexId indexId) throws IndexException {
        Object removed = this._cache.get().remove(indexId);
        if (removed instanceof BaseIndex) {
            BaseIndex index = (BaseIndex)removed;
            index.close();
        }
    }

    private BaseIndex<? extends Enum<?>> openIndex(IndexId indexId, Path indexFile) throws CorruptIndexException {
        switch (indexId.getIndexClass()) {
            case DataTime: {
                return new DataTimeIndexImpl(this._dataTimeSize, indexFile);
            }
            case DataIndex: {
                assert (indexId.getContainerFileDir().archiveDataKind().isRequested());
                return new DataIndexIndexImpl(this._dataIndexSize, indexFile);
            }
            case ArchiveTime: {
                if (indexId.getContainerFileDir().archiveDataKind().isRequested()) {
                    return new ArchiveTimeIndexImpl(this._archiveTimeSize, indexFile);
                }
                return new DataIndexAndArchiveTimeIndex(this._archiveTimeSize, indexFile);
            }
            case ManagementData: {
                return new ContainerManagementIndex(this._managementIndexSize, indexFile);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)indexId.getIndexClass()));
    }

    public Optional<? extends ContainerManagementIndex> getContainerManagementIndex(LockedContainerDirectory containerDirectory) throws IndexException {
        assert (containerDirectory.lock().isValid());
        IndexId key = new IndexId(containerDirectory, IndexImpl.ManagementData);
        return this.cacheIndex(key, () -> this.loadIndexFromDisk(key, containerDirectory));
    }

    public Optional<? extends DataIndexIndex> getDataIndexIndex(LockedContainerDirectory containerDirectory) throws IndexException {
        assert (containerDirectory.lock().isValid());
        if (!containerDirectory.archiveDataKind().isRequested()) {
            return this.getArchiveTimeIndex(containerDirectory);
        }
        IndexId key = new IndexId(containerDirectory, IndexImpl.DataIndex);
        return this.cacheIndex(key, () -> this.loadIndexFromDisk(key, containerDirectory));
    }

    public Optional<? extends DataTimeIndex> getDataTimeIndex(LockedContainerDirectory containerDirectory) throws IndexException {
        assert (containerDirectory.lock().isValid());
        IndexId key = new IndexId(containerDirectory, IndexImpl.DataTime);
        return this.cacheIndex(key, () -> this.loadIndexFromDisk(key, containerDirectory));
    }

    public Optional<? extends ArchiveTimeIndex> getArchiveTimeIndex(LockedContainerDirectory containerDirectory) throws IndexException {
        assert (containerDirectory.lock().isValid());
        IndexId key = new IndexId(containerDirectory, IndexImpl.ArchiveTime);
        return this.cacheIndex(key, () -> this.loadIndexFromDisk(key, containerDirectory));
    }

    private <T extends BaseIndex<?>> Optional<T> cacheIndex(IndexId key, IndexCreator indexCreator) throws IndexException {
        Map<IndexId, Object> cacheMap = this._cache.get();
        Object index = cacheMap.get(key);
        if (index != null) {
            if (index == NO_INDEX) {
                return Optional.empty();
            }
            return Optional.of((BaseIndex)index);
        }
        if (cacheMap.containsKey(key)) {
            throw new IllegalArgumentException("key mehrfach initialisiert");
        }
        Optional<BaseIndex<?>> indexToCache = indexCreator.create();
        if (indexToCache.isPresent()) {
            cacheMap.put(key, indexToCache.get());
        } else {
            cacheMap.put(key, NO_INDEX);
        }
        return indexToCache;
    }

    public void recreateIndex(LockedContainerDirectory containerDirectory, @Nullable RebuildResult result) throws IndexException {
        Optional<ContainerManagementIndex> managementIndex = this.rebuildContainerHeaderIndex(containerDirectory, result);
        if (managementIndex.isEmpty()) {
            return;
        }
        if (containerDirectory.archiveDataKind().isRequested()) {
            this.rebuildStandardIndex(containerDirectory, IndexImpl.DataIndex, managementIndex.get());
        }
        this.rebuildStandardIndex(containerDirectory, IndexImpl.ArchiveTime, managementIndex.get());
        this.rebuildStandardIndex(containerDirectory, IndexImpl.DataTime, managementIndex.get());
    }

    private Optional<ContainerManagementIndex> rebuildContainerHeaderIndex(LockedContainerDirectory containerDirectory, @Nullable RebuildResult rebuildResult) throws IndexException {
        IndexId indexId = new IndexId(containerDirectory, IndexImpl.ManagementData);
        return this.rebuildContainerHeaderIndex(indexId, indexId.toFile(this._persistenceDirectory), rebuildResult);
    }

    private Optional<BaseIndex<IndexValues>> rebuildStandardIndex(LockedContainerDirectory containerDirectory, IndexImpl indexClass, ContainerManagementIndex managementIndex) throws IndexException {
        IndexId indexId = new IndexId(containerDirectory, indexClass);
        return this.rebuildStandardIndex(indexId, indexId.toFile(this._persistenceDirectory), managementIndex, containerDirectory);
    }

    public void deleteIndex(LockedContainerDirectory containerDirectory, @Nullable RebuildResult result) throws IndexException {
        int sum = 0;
        sum += this.deleteIndex(new IndexId(containerDirectory, IndexImpl.ManagementData));
        if (containerDirectory.archiveDataKind().isRequested()) {
            sum += this.deleteIndex(new IndexId(containerDirectory, IndexImpl.DataIndex));
        }
        sum += this.deleteIndex(new IndexId(containerDirectory, IndexImpl.ArchiveTime));
        sum += this.deleteIndex(new IndexId(containerDirectory, IndexImpl.DataTime));
        if (result != null) {
            result.indexesDeleted += (long)sum;
        }
    }

    private int deleteIndex(IndexId indexId) throws IndexException {
        this.invalidateNow(indexId);
        Path file = indexId.toFile(this._persistenceDirectory);
        try {
            return Files.deleteIfExists(file) ? 1 : 0;
        }
        catch (IOException e) {
            throw new IndexException("Kann vorhandenen Index nicht l\u00f6schen", file, e);
        }
    }

    public void closeIndexes(LockedContainerDirectory containerDirectory) throws IndexException {
        for (IndexImpl value : IndexImpl.values()) {
            this.invalidateNow(new IndexId(containerDirectory, value));
        }
    }

    public void flushIndexes(LockedContainerDirectory containerDirectory) {
        for (Map.Entry<IndexId, Object> entry : this._cache.get().entrySet()) {
            Object baseIndex;
            IdContainerFileDir containerFileDir = entry.getKey().getContainerFileDir();
            if (!containerFileDir.dataIdentification().equals(containerDirectory.dataIdentification()) || containerFileDir.archiveDataKind() != containerDirectory.archiveDataKind() || !((baseIndex = entry.getValue()) instanceof BaseIndex)) continue;
            BaseIndex index = (BaseIndex)baseIndex;
            try {
                index.flush();
            }
            catch (IndexException e) {
                _debug.warning("Fehler beim Speichern eines Index", (Throwable)e);
            }
        }
    }

    public void ensureNoCached() {
        if (!this._cache.get().isEmpty()) {
            throw new IllegalStateException("Cache nicht leer: " + String.valueOf(this._cache.get()));
        }
    }

    static interface IndexCreator {
        public Optional<? extends BaseIndex<?>> create() throws IndexException;
    }
}

