/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.datatree.synchronization;

import com.google.common.collect.SetMultimap;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationManager;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.time.Duration;

public class DebuggingSynchronizationManager<T>
implements SynchronizationManager<T> {
    private static final Debug _debug = Debug.getLogger();
    private final SynchronizationManager<T> _delegate;

    public DebuggingSynchronizationManager(SynchronizationManager<T> delegate) {
        this._delegate = delegate;
    }

    @Override
    @NotNull
    public SyncKey<T> acquireWriteKey(T element) {
        while (true) {
            try {
                return this.acquireWriteKey(element, Duration.ofSeconds(60L));
            }
            catch (SynchronizationFailedException e) {
                _debug.warning("Thread " + Thread.currentThread().getName() + " wartet beim schreibenden Zugriff auf " + String.valueOf(element) + " da ein anderer Thread den Zugriff blockiert.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    @Override
    @NotNull
    public SyncKey<T> acquireWriteKey(T element, Duration timeout) throws SynchronizationFailedException {
        return this._delegate.acquireWriteKey(element, timeout);
    }

    @Override
    public SetMultimap<T, SyncKey<T>> getLocks() {
        return this._delegate.getLocks();
    }

    public String toString() {
        return "DebuggingSynchronizationManager{_delegate=" + String.valueOf(this._delegate) + "}";
    }
}

