/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.datatree.synchronization;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationManager;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public class SynchronizationManagerImpl<T>
implements SynchronizationManager<T> {
    private static final Debug _debug = Debug.getLogger();
    private static final FinalizableReferenceQueue REFERENCE_QUEUE = new FinalizableReferenceQueue();
    private static final Set<Reference<?>> REFERENCES = Sets.newConcurrentHashSet();
    private final HashMultimap<T, SyncKey<T>> _keyStorage = HashMultimap.create();
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _condition = this._lock.newCondition();
    private final Consumer<T> _onOpenAction;
    private final Consumer<T> _onCloseAction;

    public SynchronizationManagerImpl(Consumer<T> onOpenAction, Consumer<T> onCloseAction) {
        this._onCloseAction = onCloseAction;
        this._onOpenAction = onOpenAction;
    }

    @Override
    @NotNull
    public SyncKey<T> acquireWriteKey(T element) throws SynchronizationFailedException {
        this._lock.lock();
        try {
            while (this.isWriteBlocked(element)) {
                this._condition.await();
            }
            if (this._keyStorage.get(element).isEmpty()) {
                this._onOpenAction.accept(element);
            }
            SyncKey<T> writeKey = this.createWriteKey(element);
            this._keyStorage.put(element, writeKey);
            this.attachPhantomReference(writeKey);
            SyncKey<T> syncKey = writeKey;
            return syncKey;
        }
        catch (InterruptedException e) {
            throw new SynchronizationFailedException(null, element, this.getLocks(element), e);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    @NotNull
    public SyncKey<T> acquireWriteKey(T element, Duration timeout) throws SynchronizationFailedException {
        long nanosRemaining = timeout.toNanos();
        this._lock.lock();
        try {
            while (this.isWriteBlocked(element)) {
                if ((nanosRemaining = this._condition.awaitNanos(nanosRemaining)) > 0L) continue;
                throw new SynchronizationFailedException(timeout, element, this.getLocks(element), null);
            }
            if (this._keyStorage.get(element).isEmpty()) {
                this._onOpenAction.accept(element);
            }
            SyncKey<T> writeKey = this.createWriteKey(element);
            this._keyStorage.put(element, writeKey);
            this.attachPhantomReference(writeKey);
            SyncKey<T> syncKey = writeKey;
            return syncKey;
        }
        catch (InterruptedException e) {
            throw new SynchronizationFailedException(timeout, element, this.getLocks(element), e);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void attachPhantomReference(SyncKey<T> writeKey) {
        final BooleanSupplier notClosed = writeKey.notClosed();
        final Thread thread = writeKey.getThread();
        final T element = writeKey.getElement();
        REFERENCES.add((Reference<?>)new FinalizablePhantomReference<SyncKey<T>>(this, writeKey, REFERENCE_QUEUE){

            public void finalizeReferent() {
                REFERENCES.remove((Object)this);
                if (notClosed.getAsBoolean()) {
                    _debug.error("Element " + String.valueOf(element) + " von Thread " + String.valueOf(thread) + " wurde nicht korrekt geschlossen.");
                }
            }
        });
    }

    private SyncKey<T> createWriteKey(T element) {
        return new SyncKeyImpl(element);
    }

    private boolean isWriteBlocked(T element) {
        Set<SyncKey<T>> values = this.getLocks(element);
        if (values.isEmpty()) {
            return false;
        }
        Iterator<SyncKey<T>> iterator = values.iterator();
        while (iterator.hasNext()) {
            SyncKey<T> it = iterator.next();
            if (!it.getThread().isAlive()) {
                iterator.remove();
                this._condition.signalAll();
                _debug.error("SyncKey wurde nicht korrekt geschlossen: " + String.valueOf(it));
                continue;
            }
            if (it.getThread() != Thread.currentThread()) continue;
            return false;
        }
        return true;
    }

    private Set<SyncKey<T>> getLocks(T element) {
        return this._keyStorage.get(element);
    }

    @Override
    public SetMultimap<T, SyncKey<T>> getLocks() {
        this._lock.lock();
        try {
            ImmutableSetMultimap immutableSetMultimap = ImmutableSetMultimap.copyOf(this._keyStorage);
            return immutableSetMultimap;
        }
        finally {
            this._lock.unlock();
        }
    }

    public String toString() {
        return "SynchronizationManagerImpl";
    }

    private class SyncKeyImpl
    implements SyncKey<T> {
        private final T _element;
        private final Thread _thread;
        private final AtomicBoolean _open = new AtomicBoolean(true);

        public SyncKeyImpl(T element) {
            this._element = element;
            this._thread = Thread.currentThread();
        }

        @Override
        public T getElement() {
            return this._element;
        }

        @Override
        public Thread getThread() {
            return this._thread;
        }

        @Override
        public void close() {
            if (!this._open.get()) {
                return;
            }
            SynchronizationManagerImpl.this._lock.lock();
            try {
                if (!this._open.get()) {
                    return;
                }
                this._open.set(false);
                Set set = SynchronizationManagerImpl.this.getLocks(this._element);
                set.remove(this);
                if (set.isEmpty()) {
                    SynchronizationManagerImpl.this._onCloseAction.accept(this._element);
                    SynchronizationManagerImpl.this._condition.signalAll();
                }
            }
            finally {
                SynchronizationManagerImpl.this._lock.unlock();
            }
        }

        public String toString() {
            StringWriter out = new StringWriter();
            return String.valueOf(this._thread) + " (alive: " + this._thread.isAlive() + ") e: " + String.valueOf(this._element) + " " + String.valueOf(out) + " valid: " + this.isValid();
        }

        @Override
        public boolean isValid() {
            return this._open.get() && this._thread.equals(Thread.currentThread());
        }

        @Override
        public BooleanSupplier notClosed() {
            return this._open::get;
        }
    }
}

