/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.losb.util.ByteIO;

public class ArchiveDataSerializer {
    private static final Debug _debug = Debug.getLogger();
    private byte[] actualWriteBuf;
    private int totalWriteDataSize;
    private final byte[] writeBuf = new byte[4096];

    private static byte[] getBuf(byte[] defaultBuffer, int desiredSize) {
        return desiredSize <= defaultBuffer.length ? defaultBuffer : new byte[desiredSize];
    }

    public int serializeData(SerializableDataset dataset) {
        long arcTime = dataset.archiveTime();
        long dataTime = dataset.dataTime();
        long dataIdx = dataset.dataIndex();
        if ((dataTime & 0xFFFFFFFFFFFFL) != dataTime) {
            _debug.warning("Ung\u00fcltige Datenzeit: " + dataTime + ". Datensatz wird stattdessen mit Datenzeit 0 archiviert: " + String.valueOf(dataset));
            dataTime = 0L;
        }
        byte[] serData = dataset.serializedData();
        int origLength = dataset.uncompressedSize();
        boolean isAlreadyCompressed = origLength != 0;
        this.actualWriteBuf = ArchiveDataSerializer.getBuf(this.writeBuf, ContainerFile.getTotalDataOverhead() + serData.length);
        byte[] dest = this.actualWriteBuf;
        int p = 4;
        p += ByteIO.writeUnsignedLong6Byte((byte[])dest, (int)p, (long)arcTime);
        p += ByteIO.writeUnsignedLong6Byte((byte[])dest, (int)p, (long)dataTime);
        p += ByteIO.writeSignedLong8Byte((byte[])dest, (int)p, (long)dataIdx);
        int chkSumPos = p;
        p += 4;
        p = !isAlreadyCompressed ? (p += ByteIO.writeSignedInt4Bytes((byte[])dest, (int)p, (int)0)) : (p += ByteIO.writeSignedInt4Bytes((byte[])dest, (int)p, (int)origLength));
        p += ByteIO.writeBytes((byte[])dest, (int)p, (byte[])serData);
        this.totalWriteDataSize = ContainerFile.getTotalDataOverhead() + serData.length;
        int lengthBytes = this.totalWriteDataSize - 4;
        int checkSum = (int)((long)lengthBytes + arcTime + dataTime + dataIdx);
        ByteIO.writeSignedInt4Bytes((byte[])dest, (int)0, (int)lengthBytes);
        ByteIO.writeSignedInt4Bytes((byte[])dest, (int)chkSumPos, (int)checkSum);
        ByteIO.writeSeparator((byte[])dest, (int)p);
        return this.totalWriteDataSize;
    }

    public byte[] getActualWriteBuf() {
        return this.actualWriteBuf;
    }

    public int getTotalWriteDataSize() {
        return this.totalWriteDataSize;
    }
}

