/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.tasks.MultiTaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.QueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.QueryDataSequence;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.IOException;

public class ArchiveInfoQueryTask
extends QueryTask {
    private static final boolean GAP = true;
    private static final boolean NO_GAP = false;
    private static final boolean NO_DIR_ACCESS = false;
    private static final int NO_MEDIUM_ID = -1;
    private ArchiveDataSpecification[] adsList;
    private int entryCounter;

    public ArchiveInfoQueryTask(MultiTaskManager tMgr) {
        super(tMgr.getArchMgr(), tMgr);
    }

    private void analyze() throws Exception {
        this.createQueryData();
        this.adsList = ArchiveInfoQueryTask.parseArchiveDataSpec(this.deserializer, this.getArchMgr().getDataModel());
    }

    private void sendResponse() throws IOException {
        this.bosResult.reset();
        this.serializer.writeByte(1);
        this.serializer.writeInt(0);
        this.entryCounter = 0;
        int adsCounter = 0;
        for (ArchiveDataSpecification ads : this.adsList) {
            this.suspendTaskIfNecessary();
            if (this.shouldTerminate()) break;
            IdDataIdentification dataIdentification = new IdDataIdentification(ads);
            ArchiveTimeSpecification ats = ads.getTimeSpec();
            try {
                QueryDataSequence sequence = new QueryDataSequence(this.getPersistenceManager(), ads.getDataKinds(), ats, ads.getSortOrder(), dataIdentification);
                try (DataIterator iterator = sequence.iterator();){
                    ContainerDataResult result = new ContainerDataResult();
                    TimingType tt = ats.getTimingType();
                    long curDIdx = -1L;
                    long curATime = -1L;
                    long curDTime = -1L;
                    long lastDIdx = -1L;
                    long lastDTime = -1L;
                    long lastATime = -1L;
                    long lbDIdx = -1L;
                    long lbATime = -1L;
                    long lbDTime = -1L;
                    boolean curDirAccess = true;
                    while (!iterator.isEmpty()) {
                        if (this.shouldTerminate()) {
                            throw new IllegalStateException("Das Archivsystem wurde beendet.");
                        }
                        iterator.peek(result);
                        curDIdx = result.getDataIndex();
                        curATime = result.getArchiveTime();
                        curDTime = result.getDataTime();
                        if (lbDIdx == -1L) {
                            lbDIdx = curDIdx;
                            lbATime = curATime;
                            lbDTime = curDTime;
                        }
                        boolean blockAlreadyWritten = false;
                        if (ArchiveInfoQueryTask.isGap(result, lastDIdx)) {
                            if (!blockAlreadyWritten) {
                                this.addEntry(ArchiveInfoQueryTask.ttVal(tt, lbDIdx, lbATime, lbDTime), ArchiveInfoQueryTask.ttVal(tt, lastDIdx, lastATime, lastDTime), tt, false, curDirAccess, -1, adsCounter);
                            }
                            this.addEntry(ArchiveInfoQueryTask.ttVal(tt, lastDIdx, lastATime, lastDTime), ArchiveInfoQueryTask.ttVal(tt, curDIdx, curATime, curDTime), tt, true, false, -1, adsCounter);
                            lbDIdx = curDIdx;
                            lbATime = curATime;
                            lbDTime = curDTime;
                        }
                        lastDIdx = curDIdx;
                        lastATime = curATime;
                        lastDTime = curDTime;
                        iterator.remove();
                    }
                    if (lbDIdx != -1L) {
                        this.addEntry(ArchiveInfoQueryTask.ttVal(tt, lbDIdx, lbATime, lbDTime), ArchiveInfoQueryTask.ttVal(tt, curDIdx, curATime, curDTime), tt, false, curDirAccess, -1, adsCounter);
                    }
                }
            }
            catch (Exception e) {
                _debug.error("Fehler beim Bearbeiten der Archivinformationsanfrage", (Throwable)e);
                this.printError("Fehler beim Bearbeiten der Archivinformationsanfrage: " + e.getMessage());
                this.sendResultData(this.bosResult.toByteArray(), 6);
                return;
            }
            ++adsCounter;
        }
        this.sendResultData(this.insertNumOfEntries(this.entryCounter), 6);
    }

    private static boolean isGap(ContainerDataResult result, long lastDIdx) {
        return lastDIdx != -1L && Util.dIdxNoModBits((long)result.getDataIndex()) - Util.dIdxNoModBits((long)lastDIdx) > 1L && !result.getDataKind().isDelayed();
    }

    private static long ttVal(TimingType tt, long dIdx, long aTime, long dTime) {
        return tt.equals(TimingType.DATA_TIME) ? dTime : (tt.equals(TimingType.ARCHIVE_TIME) ? aTime : dIdx);
    }

    private byte[] insertNumOfEntries(int numOfEntries) throws IOException {
        byte[] resultBytes = this.bosResult.toByteArray();
        this.bosResult.reset();
        this.serializer.writeInt(numOfEntries);
        System.arraycopy(this.bosResult.toByteArray(), 0, resultBytes, 1, 4);
        return resultBytes;
    }

    private void printError(String msg) throws IOException {
        this.bosResult.reset();
        this.serializer.writeByte(0);
        this.serializer.writeString(msg);
    }

    private void addEntry(long from, long to, TimingType tt, boolean gap, boolean direct, int volID, int idx) throws IOException {
        this.serializer.writeLong(from);
        this.serializer.writeLong(to);
        this.serializer.writeByte(tt.equals(TimingType.DATA_TIME) ? 1 : (tt.equals(TimingType.ARCHIVE_TIME) ? 2 : 3));
        this.serializer.writeByte(gap ? 1 : 0);
        this.serializer.writeByte(direct ? 1 : 0);
        this.serializer.writeInt(volID);
        this.serializer.writeInt(idx);
        ++this.entryCounter;
    }

    @Override
    public void work() {
        this.init();
        try {
            this.analyze();
            this.subscribeSender();
            QueryTask.SendingState state = this.waitForSendControl();
            if (state == QueryTask.SendingState.SEND) {
                TaskManager.run("Archivinfoanfrage", tpi -> this.sendResponse());
            }
        }
        catch (InterruptedException e) {
            _debug.finer(this.getName() + " Task durch Interrupt beendet.");
        }
        catch (Exception e) {
            _debug.error(this.getName() + " Fehler beim Bearbeiten der Archiv-Informationsanfrage: " + e.getMessage() + ", Anfrage: " + this.resultData.toString());
        }
        finally {
            this.unsubscribeSender();
            this.adsList = null;
            this.bosResult.reset();
        }
    }
}

