/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import com.google.common.collect.ImmutableList;
import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.dav.daf.util.cron.CronDefinition;
import de.bsvrz.dav.daf.util.cron.CronScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CronTask
extends Task {
    private final CronScheduler _cronScheduler;
    private String _name;
    private final List<CronTaskDefinition> _cronTaskDefinitions = new ArrayList<CronTaskDefinition>();
    private List<ScheduledFuture<?>> _scheduledFutures = ImmutableList.of();
    private boolean _started;

    public CronTask(ArchiveManager archiveManager) {
        super(archiveManager);
        this._cronScheduler = new CronScheduler();
    }

    @Override
    public void start() {
        this._started = true;
        ArrayList scheduledFutures = new ArrayList();
        for (CronTaskDefinition cronTaskDefinition : this._cronTaskDefinitions) {
            scheduledFutures.add(this._cronScheduler.schedule(cronTaskDefinition.runnable(), cronTaskDefinition.cronDefinition()));
        }
        this._scheduledFutures = scheduledFutures;
    }

    public void setCronTaskDefinitions(List<CronTaskDefinition> definitions) {
        this._scheduledFutures.forEach(it -> it.cancel(false));
        this._cronTaskDefinitions.clear();
        this._cronTaskDefinitions.addAll(definitions);
        if (this._started && !this.shouldTerminate()) {
            this.start();
        }
    }

    @Override
    public void terminateTask() {
        super.terminateTask();
        this._cronScheduler.shutdownNow();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void join() throws InterruptedException {
        while (!this._cronScheduler.awaitTermination(1L, TimeUnit.MINUTES)) {
            _debug.fine("CronTask.join() hat sich noch nicht terminiert.");
        }
    }

    @Override
    public boolean isAlive() {
        return !this._cronScheduler.isTerminating() && !this._cronScheduler.isTerminated();
    }

    @Override
    public boolean isTerminated() {
        return this._cronScheduler.isTerminated();
    }

    public record CronTaskDefinition(CronDefinition cronDefinition, Runnable runnable) {
    }
}

