/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.communicationStreams.StreamMultiplexer;
import de.bsvrz.sys.funclib.dataSerializer.Deserializer;
import de.bsvrz.sys.funclib.dataSerializer.SerializingFactory;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class FlowControlTask {
    private final Object syncObj = new Object();
    private final Debug logger = Debug.getLogger();
    private final Map<SystemObject, Map<Integer, StreamMultiplexer>> ctrlMap = new HashMap<SystemObject, Map<Integer, StreamMultiplexer>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlowCtrl(ResultData resultData) {
        Data data = resultData.getData();
        SystemObject queryAppObj = data.getReferenceValue("absender").getSystemObject();
        int queryIdx = data.getUnscaledValue("anfrageIndex").intValue();
        byte[] dataArray = data.getUnscaledArray("daten").getByteArray();
        Object object = this.syncObj;
        synchronized (object) {
            StreamMultiplexer mux;
            Map<Integer, StreamMultiplexer> map = this.ctrlMap.get(queryAppObj);
            if (map != null && (mux = map.get(queryIdx)) != null) {
                try {
                    mux.setMaximumStreamTicketIndexForStream(dataArray);
                }
                catch (IOException e) {
                    this.logger.warning("Flusskontroll-Steuerungspaket konnte nicht an StreamMultiplexer uebergeben werden.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(SystemObject queryAppObj, int queryIdx, StreamMultiplexer mux) {
        Object object = this.syncObj;
        synchronized (object) {
            Map map = this.ctrlMap.computeIfAbsent(queryAppObj, k -> new HashMap());
            map.put(queryIdx, mux);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(SystemObject queryAppObj, int queryIdx) {
        Object object = this.syncObj;
        synchronized (object) {
            Map<Integer, StreamMultiplexer> map = this.ctrlMap.get(queryAppObj);
            if (map != null) {
                map.remove(queryIdx);
            }
        }
    }

    private void log(byte[] streamTicketPacket) {
        ByteArrayInputStream in = new ByteArrayInputStream(streamTicketPacket);
        Deserializer deserializer = SerializingFactory.createDeserializer((InputStream)in);
        int indexOfStream = 0;
        int maximumStreamTicketIndex = 0;
        try {
            indexOfStream = deserializer.readInt();
            maximumStreamTicketIndex = deserializer.readInt();
        }
        catch (IOException e) {
            this.logger.error("Fehler", (Throwable)e);
        }
        this.logger.info("Payload: Stream-Idx=" + indexOfStream + " MaxStreamTicketIdx=" + maximumStreamTicketIndex);
    }

    private void log(SystemObject queryAppObj, int queryIdx, byte[] streamTicketPacket) {
        ByteArrayInputStream in = new ByteArrayInputStream(streamTicketPacket);
        Deserializer deserializer = SerializingFactory.createDeserializer((InputStream)in);
        int indexOfStream = 0;
        int maximumStreamTicketIndex = 0;
        try {
            indexOfStream = deserializer.readInt();
            maximumStreamTicketIndex = deserializer.readInt();
        }
        catch (IOException e) {
            this.logger.error("Fehler", (Throwable)e);
        }
        if (maximumStreamTicketIndex <= 0) {
            this.logger.info("FlowControlTask: app: " + queryAppObj.getId() + ", query: " + queryIdx + " streamIndex: " + indexOfStream + " MaxStreamTicketIdx: " + maximumStreamTicketIndex);
        }
    }
}

