/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.MultiTaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.QueueTask;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.dav.daf.main.ResultData;

public abstract class MultiTask
extends QueueTask<ResultData> {
    private final MultiTaskManager taskMgr;
    protected ResultData resultData;

    public MultiTask(ArchiveManager archiveMgr, MultiTaskManager tMgr) {
        super(archiveMgr, new SignalingQueue());
        this.taskMgr = tMgr;
    }

    public void setTaskIndex(int idx) {
        this.setName(this.taskMgr.getName() + ":" + this.getClass().getSimpleName() + "_" + idx);
    }

    @Override
    protected final void work(ResultData step) {
        try {
            this.resultData = step;
            this.work();
        }
        finally {
            this.resultData = null;
            this.taskMgr.pushFreeTask(this);
        }
    }

    protected abstract void work();

    public void getObjectsFromDav() {
    }
}

