/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.tasks.SimpleArchiveData;
import de.bsvrz.ars.ars.mgmt.tasks.Task;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.QueryDataSequence;
import de.bsvrz.ars.ars.persistence.writer.ArchiveTask;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestOption;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.util.Arrays;

public class Query
implements AutoCloseable {
    private final ArchiveDataSpecification arcDataSpec;
    private final ArchiveTimeSpecification timeSpec;
    volatile boolean done;
    private SimpleArchiveData lastDataForDelta;
    private final ContainerDataResult _result = new ContainerDataResult();
    private boolean _eoaReturned;
    private final PersistenceManager persMgr;
    private final DataIterator _iterator;

    Query(ArchiveManager archMgr, ArchiveDataSpecification ads, boolean requestedIntervalError) throws PersistenceException {
        this.arcDataSpec = ads;
        this.timeSpec = ads.getTimeSpec();
        this.persMgr = archMgr.getPersistenceManager();
        IdDataIdentification dataIdentification = new IdDataIdentification(ads);
        try {
            this._iterator = this.getDataIterator(requestedIntervalError, dataIdentification);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    private DataIterator getDataIterator(boolean requestedIntervalError, IdDataIdentification idDataIdentification) throws PersistenceException, SynchronizationFailedException {
        DataIterator iterator;
        if (requestedIntervalError) {
            iterator = DataIterator.empty();
        } else {
            QueryDataSequence sequence = new QueryDataSequence(this.persMgr, this.arcDataSpec.getDataKinds(), this.timeSpec, this.arcDataSpec.getSortOrder(), idDataIdentification);
            iterator = sequence.iterator();
        }
        return iterator;
    }

    @Nullable
    private SimpleArchiveData getNextData(DataIterator dataIterator) {
        if (this.arcDataSpec.getRequestOption() == ArchiveRequestOption.DELTA) {
            SimpleArchiveData tmp = this.getNextDataRegular(dataIterator);
            while (Query.containSameData(this.lastDataForDelta, tmp)) {
                tmp = this.getNextDataRegular(dataIterator);
            }
            this.lastDataForDelta = tmp;
            return tmp;
        }
        return this.getNextDataRegular(dataIterator);
    }

    @Nullable
    private SimpleArchiveData getNextDataRegular(DataIterator iterator) {
        String medId;
        boolean deleted;
        try {
            if (iterator.isEmpty()) {
                return this.getEndOfArchive(iterator);
            }
            deleted = iterator.getContainerManagementData().getContainerHeaderParamAsBoolean(ContainerManagementInformation.CHP_DELETED);
            medId = iterator.getContainerManagementData().getContainerHeaderParamAsString(ContainerManagementInformation.CHP_MEDIUM_ID);
            iterator.peek(this._result);
            iterator.remove();
        }
        catch (SynchronizationFailedException | PersistenceException e) {
            Task._debug.error("Fehler beim Durchf\u00fchren der Archivanfrage", (Throwable)e);
            return null;
        }
        if (deleted) {
            DataState dataState = medId.equals("unsaved   ") || medId.equals("destroyed ") ? DataState.DELETED_BLOCK : DataState.UNAVAILABLE_BLOCK;
            return new SimpleArchiveData(this._result.getArchiveTime(), this._result.getDataTime(), this._result.getDataIndex(), this._result.getDataKind(), dataState, false, null);
        }
        return new SimpleArchiveData(this._result.getArchiveTime(), this._result.getDataTime(), this._result.getDataIndex(), this._result.getDataKind(), this._result.getDataState(), this._result.isCompressed(), this._result.getData());
    }

    @Nullable
    private SimpleArchiveData getEndOfArchive(DataIterator iterator) throws PersistenceException, SynchronizationFailedException {
        if (!this._eoaReturned) {
            this._eoaReturned = true;
            ContainerDataResult next = iterator.peekNext();
            if (next != null) {
                long endATime = next.getArchiveTime();
                long endDTime = next.getDataTime();
                long endIndex = this._result.getDataIndex();
                if (this.timeSpec.getTimingType() == TimingType.ARCHIVE_TIME) {
                    endATime = Math.min(endATime, this.timeSpec.getIntervalEnd());
                }
                if (this.timeSpec.getTimingType() == TimingType.DATA_TIME) {
                    endDTime = Math.min(endDTime, this.timeSpec.getIntervalEnd());
                }
                if (this.timeSpec.getTimingType() == TimingType.DATA_INDEX) {
                    endIndex = Math.min(endIndex, this.timeSpec.getIntervalEnd());
                }
                return new SimpleArchiveData(endATime, endDTime, Util.dIdxSetArSBit((long)endIndex), next.getDataKind(), DataState.END_OF_ARCHIVE, false, null);
            }
            if (this._result.getDataKind() == null) {
                ArchiveDataKindCombination dataKinds = this.arcDataSpec.getDataKinds();
                ArchiveDataKind dataKind = dataKinds.isEmpty() ? ArchiveDataKind.ONLINE : (ArchiveDataKind)dataKinds.iterator().next();
                long time = ArchiveTask.getLastArchiveTime();
                return new SimpleArchiveData(time, time, Util.dIdxSetArSBit((long)0L), dataKind, DataState.END_OF_ARCHIVE, false, null);
            }
            long endATime = ArchiveTask.getLastArchiveTime();
            long endDTime = this._result.getDataTime();
            long endIndex = this._result.getDataIndex();
            if (this.timeSpec.getTimingType() == TimingType.ARCHIVE_TIME) {
                endATime = Math.min(endATime, this.timeSpec.getIntervalEnd());
            }
            if (this.timeSpec.getTimingType() == TimingType.DATA_TIME) {
                endDTime = Math.min(endDTime, this.timeSpec.getIntervalEnd());
            }
            if (this.timeSpec.getTimingType() == TimingType.DATA_INDEX) {
                endIndex = Math.min(endIndex, this.timeSpec.getIntervalEnd());
            }
            return new SimpleArchiveData(endATime, endDTime, Util.dIdxSetArSBit((long)endIndex), this._result.getDataKind(), DataState.END_OF_ARCHIVE, false, null);
        }
        return null;
    }

    @Override
    public void close() {
        this._iterator.close();
        this.done = true;
    }

    private static boolean containSameData(SimpleArchiveData arcData1, SimpleArchiveData arcData2) {
        return arcData1 != null && arcData2 != null && arcData1.dataState().equals(arcData2.dataState()) && arcData1.dataState() == DataState.DATA && !arcData1.dataKind().isDelayed() && !arcData2.dataKind().isDelayed() && Arrays.equals(arcData1.rawData(), arcData2.rawData());
    }

    public SimpleArchiveData take() {
        return this.getNextData(this._iterator);
    }
}

