/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.ArchiveQueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.Query;
import de.bsvrz.ars.ars.mgmt.tasks.QueryError;
import de.bsvrz.ars.ars.mgmt.tasks.QueryList;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.sys.funclib.communicationStreams.StreamMultiplexer;
import java.io.IOException;

public sealed interface QueryData
extends AutoCloseable
permits QueryList, QueryError {
    public static QueryData createQueryData(ArchiveManager archMgr, ArchiveDataSpecification[] ads, int archivQueryCountForApplication, int maximumRequestsPerApplication, Object queryAppObj) {
        if (archivQueryCountForApplication > maximumRequestsPerApplication) {
            return new QueryError("Zu viele parallele Archivanfragen (" + archivQueryCountForApplication + ") von der Applikation '" + String.valueOf(queryAppObj) + "'. Maximum ist: " + maximumRequestsPerApplication);
        }
        if (ads.length == 0) {
            return new QueryError("Kein Intervall gegeben");
        }
        try {
            return new QueryList(archMgr, ads);
        }
        catch (Exception e) {
            return new QueryError("Fehler beim Auswerten der Archivanfrage", e);
        }
    }

    public int size();

    public void sendReply(ArchiveQueryTask.ResponseSender var1, StreamMultiplexer var2) throws IOException, InterruptedException;

    public Query get(int var1);
}

