/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import com.google.common.collect.Range;
import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentNode;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.mgmt.tasks.DataIndexRangeSet;
import de.bsvrz.ars.ars.mgmt.tasks.QueryTask;
import de.bsvrz.ars.ars.mgmt.tasks.SingleTask;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.ars.ars.mgmt.tasks.base.TimeoutManager;
import de.bsvrz.ars.ars.mgmt.tasks.query.QueryHandler;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.gap.GapFile;
import de.bsvrz.ars.ars.persistence.gap.RemoteArchive;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.QueryDataSequence;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.archive.ArchiveData;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.archive.ArchiveDataQueryResult;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.archive.ArchiveDataStream;
import de.bsvrz.dav.daf.main.archive.ArchiveOrder;
import de.bsvrz.dav.daf.main.archive.ArchiveQueryPriority;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestOption;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ObjectLookup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.dataSerializer.Deserializer;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class RequestGapTask
extends SingleTask {
    private static final ArchiveQueryPriority REQUEST_PRIO = ArchiveQueryPriority.LOW;
    private final ArchiveDataKindCombination requestAdk = ArchiveDataKindCombination.all();
    private ArchiveDataSpecification[] archDataSpecs;
    private List<RemoteArchive> archiveList;
    private final AtomicInteger totalGapsFound = new AtomicInteger(0);
    private ArchiveTimeSpecification archTimeSpec;
    private final ReentrantLock archiveRequestedDataFinishedLock = new ReentrantLock();
    private final Condition archiveRequestedDataFinishedCondition = this.archiveRequestedDataFinishedLock.newCondition();
    private boolean requestedDataFinished = false;

    public RequestGapTask(ArchiveManager archiveMgr) {
        super(archiveMgr);
    }

    public static RequestGapResultData getRequestGapResultData() {
        return new RequestGapResultData();
    }

    @Override
    protected void work(ResultData resultData) {
        long t = Util.startTimer();
        this.totalGapsFound.set(0);
        long anzReqDS = this.getArchMgr().getInQueuesMgr().getQueuesCountRequested();
        if (resultData instanceof RequestGapResultData) {
            _debug.info(this.getName() + ": Automatische Nachforderung gestartet.");
            this.archTimeSpec = null;
            this.archDataSpecs = new ArchiveDataSpecification[0];
            this.archiveList = new ArrayList<RemoteArchive>(0);
            try {
                this.performRequest();
                anzReqDS = this.getArchMgr().getInQueuesMgr().getQueuesCountRequested() - anzReqDS;
                _debug.info(this.getName() + ": Automatische Nachforderung beendet (Zeit: " + Util.stopTimer((long)t) + ", Luecken: " + this.totalGapsFound.get() + ", erhaltene Datensaetze: " + anzReqDS + ")");
            }
            catch (Exception e) {
                _debug.warning("Nachforderung fehlgeschlagen.", (Throwable)e);
            }
        } else {
            if (!resultData.hasData()) {
                return;
            }
            int msgType = resultData.getData().getUnscaledValue("nachrichtenTyp").intValue();
            if (msgType == 17) {
                int messageTypeResult = 18;
                _debug.info(this.getName() + ": Manuelle Nachforderung gestartet.");
                QueryHandler queryHandler = new QueryHandler(this.getName(), this.getArchMgr(), messageTypeResult, resultData.getData());
                try {
                    this.archTimeSpec = null;
                    Deserializer deserializer = queryHandler.getDeserializer();
                    this.archDataSpecs = QueryTask.parseArchiveDataSpec(deserializer, this.getArchMgr().getDataModel());
                    this.archiveList = this.parseArchiveList(deserializer);
                    this.performRequest();
                    queryHandler.sendSuccessResponse(messageTypeResult);
                    anzReqDS = this.getArchMgr().getInQueuesMgr().getQueuesCountRequested() - anzReqDS;
                    _debug.info(this.getName() + ": Manuelle Nachforderung beendet (Zeit: " + Util.stopTimer((long)t) + ", Luecken: " + this.totalGapsFound.get() + ", erhaltene Datensaetze: " + anzReqDS + ")");
                }
                catch (Exception e) {
                    _debug.warning("Nachforderung fehlgeschlagen.", (Throwable)e);
                    queryHandler.sendErrorResponse(messageTypeResult, "Nachforderung fehlgeschlagen: " + e.getMessage());
                }
            } else if (msgType == 19) {
                int messageTypeResult = 20;
                QueryHandler queryHandler = new QueryHandler(this.getName(), this.getArchMgr(), messageTypeResult, resultData.getData());
                try {
                    _debug.info(this.getName() + ": Manueller Ansto\u00df der automatischen Nachforderung.");
                    this.archDataSpecs = new ArchiveDataSpecification[0];
                    Deserializer deserializer = queryHandler.getDeserializer();
                    long startTime = deserializer.readLong();
                    long endTime = deserializer.readLong();
                    this.archTimeSpec = new ArchiveTimeSpecification(TimingType.ARCHIVE_TIME, false, startTime, endTime);
                    this.archiveList = this.parseArchiveList(deserializer);
                    this.performRequest();
                    queryHandler.sendSuccessResponse(messageTypeResult);
                    anzReqDS = this.getArchMgr().getInQueuesMgr().getQueuesCountRequested() - anzReqDS;
                    _debug.info(this.getName() + ": Manueller Ansto\u00df der automatischen Nachforderung beendet (Zeit: " + Util.stopTimer((long)t) + ", Luecken: " + this.totalGapsFound.get() + ", erhaltene Datensaetze: " + anzReqDS + ")");
                }
                catch (Exception e) {
                    _debug.warning("Nachforderung fehlgeschlagen.", (Throwable)e);
                    queryHandler.sendErrorResponse(messageTypeResult, "Manueller Ansto\u00df der automatischen Nachforderung fehlgeschlagen: " + e.getMessage());
                }
            } else {
                _debug.error("Ung\u00fcltiger Nachrichtentyp f\u00fcr die Nachforderung: " + msgType);
            }
        }
        this.archDataSpecs = null;
    }

    private List<RemoteArchive> parseArchiveList(Deserializer ds) throws Exception {
        int anzArchives = ds.readInt();
        ArrayList<RemoteArchive> result = new ArrayList<RemoteArchive>(anzArchives);
        HashSet<SystemObject> singleEntries = new HashSet<SystemObject>();
        for (int i = 0; i < anzArchives; ++i) {
            SystemObject foreignArS = ds.readObjectReference((ObjectLookup)this.getArchMgr().getDataModel());
            if (foreignArS == null) {
                throw new IllegalArgumentException("Archivsystem-Objekt[" + i + "] == null");
            }
            if (singleEntries.contains(foreignArS) || this.getArchMgr().getArchiveObject().getPid().equals(foreignArS.getPid())) continue;
            result.add(RemoteArchive.open(foreignArS));
            singleEntries.add(foreignArS);
        }
        return result;
    }

    private void performRequest() throws PersistenceException {
        if (this.archDataSpecs.length == 0) {
            for (DataIdentNode dataIdentNode : this.getDidTree()) {
                if (!dataIdentNode.isArSParameterized() || !dataIdentNode.arSParamIsNachfordern()) continue;
                this.requestDID(dataIdentNode.getDataIdentification(), dataIdentNode, this.archTimeSpec);
            }
        } else {
            for (ArchiveDataSpecification archDataSpec : this.archDataSpecs) {
                this.requestDID(new IdDataIdentification(archDataSpec), null, archDataSpec.getTimeSpec());
            }
        }
    }

    private void requestDID(IdDataIdentification dataIdentification, @Nullable DataIdentNode dinIfKnown, @Nullable ArchiveTimeSpecification ats) throws PersistenceException {
        try {
            DataIdentNode din;
            this.suspendTaskIfNecessary();
            if (dinIfKnown != null) {
                din = dinIfKnown;
            } else {
                din = this.getDidTree().getIfPresent(dataIdentification);
                if (din == null) {
                    _debug.fine("DIN ist nicht parametriert f\u00fcr " + String.valueOf(dataIdentification) + ".");
                    return;
                }
            }
            if (!din.arSParamIsNachfordern()) {
                _debug.fine("Nachfordern ist nicht parametriert f\u00fcr " + String.valueOf(dataIdentification) + ".");
                return;
            }
            List<RemoteArchive> requestArchives = !this.archiveList.isEmpty() ? this.archiveList : this.copyReqArSFromDIN(din);
            requestArchives.removeIf(it -> {
                ArchiveRequestManager requestManager = it.createRequestManager(this.getArchMgr().getDavCon());
                return requestManager == null || !requestManager.isArchiveAvailable();
            });
            if (requestArchives.isEmpty()) {
                _debug.fine("Es ist kein Archiv verf\u00fcgbar, um " + String.valueOf(dataIdentification) + " nachzufordern.");
                return;
            }
            AttributeGroup atg = this.getArchMgr().getAtg(dataIdentification.getAtgId());
            Aspect asp = this.getArchMgr().getAsp(dataIdentification.getAspectId());
            SystemObject object = this.getArchMgr().getObj(dataIdentification.getObjectId());
            DataDescription dataDesc = new DataDescription(atg, asp);
            DataIndexRangeSet gaps = TaskManager.compute("Nachfordern: Ermittlung von Datenl\u00fccken", it -> this.getGapRanges(dataIdentification, ats));
            if (gaps == null) {
                return;
            }
            if (gaps.isEmpty()) {
                _debug.fine("Keine Datenl\u00fccken vorhanden f\u00fcr '" + String.valueOf(dataIdentification) + "'");
                return;
            }
            this.requestGaps(gaps, requestArchives, dataIdentification, dataDesc, object);
        }
        catch (Exception e) {
            _debug.warning("Fehler beim Nachfordern von '" + String.valueOf(dataIdentification), (Throwable)e);
        }
        try {
            _debug.fine("Warte auf Fertigstellung der Nachforderung.");
            this.getArchMgr().getInQueuesMgr().insertRequestedDataFinishedNotification();
            this.awaitNotification();
            _debug.fine("Nachforderung fertig.");
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Warten auf Nachfordern wurde unterbrochen");
        }
    }

    private void awaitNotification() throws InterruptedException {
        this.archiveRequestedDataFinishedLock.lock();
        try {
            while (!this.requestedDataFinished) {
                this.archiveRequestedDataFinishedCondition.await();
            }
            this.requestedDataFinished = false;
        }
        finally {
            this.archiveRequestedDataFinishedLock.unlock();
        }
    }

    public void signalNotification() {
        this.archiveRequestedDataFinishedLock.lock();
        try {
            this.requestedDataFinished = true;
            this.archiveRequestedDataFinishedCondition.signalAll();
        }
        finally {
            this.archiveRequestedDataFinishedLock.unlock();
        }
    }

    @Nullable
    private DataIndexRangeSet getGapRanges(IdDataIdentification dataIdentification, @Nullable ArchiveTimeSpecification ats) throws PersistenceException, SynchronizationFailedException {
        DataIndexRangeSet gaps = new DataIndexRangeSet();
        QueryDataSequence dataSequence = new QueryDataSequence(this.getPersistenceManager(), ArchiveDataKindCombination.all(), ats, ArchiveOrder.BY_INDEX, dataIdentification);
        try (DataIterator iterator = dataSequence.iteratorWithoutTimeFilter();){
            if (iterator.isEmpty()) {
                _debug.fine("Es sind keine bestehenden Daten archiviert, " + String.valueOf(dataIdentification) + " kann daher nicht nachgefordert werden.");
                DataIndexRangeSet dataIndexRangeSet = null;
                return dataIndexRangeSet;
            }
            TimingType timingType = ats == null ? TimingType.DATA_INDEX : ats.getTimingType();
            long lowDidx = -1L;
            long lowFilterValue = -1L;
            while (!iterator.isEmpty()) {
                if (this.shouldTerminate()) {
                    DataIndexRangeSet dataIndexRangeSet = null;
                    return dataIndexRangeSet;
                }
                long hiDidx = iterator.peekDataIndex();
                long highFilterValue = RequestGapTask.peekFilterValue(timingType, iterator);
                if (RequestGapTask.isGap(lowDidx, hiDidx) && RequestGapTask.isInRange(ats, lowFilterValue, highFilterValue)) {
                    this.totalGapsFound.incrementAndGet();
                    gaps.addRange(RequestGapTask.noModBits(lowDidx) + 1L, RequestGapTask.noModBits(hiDidx));
                }
                lowDidx = hiDidx;
                lowFilterValue = highFilterValue;
                iterator.remove();
            }
        }
        return gaps;
    }

    private static boolean isInRange(@Nullable ArchiveTimeSpecification ats, long a, long b) {
        if (ats == null) {
            return true;
        }
        long start = ats.getIntervalStart();
        long end = ats.getIntervalEnd();
        if (a <= b) {
            return a <= end && b >= start;
        }
        return b <= end && a >= start;
    }

    private static long peekFilterValue(TimingType timingType, DataIterator iterator) {
        if (timingType == TimingType.DATA_TIME) {
            return iterator.peekDataTime();
        }
        if (timingType == TimingType.ARCHIVE_TIME) {
            return iterator.peekArchiveTime();
        }
        if (timingType == TimingType.DATA_INDEX) {
            return iterator.peekDataIndex();
        }
        throw new IllegalArgumentException("TimingType: " + String.valueOf(timingType));
    }

    private void requestGaps(DataIndexRangeSet gaps, List<RemoteArchive> archivesToRequestFrom, IdDataIdentification dataIdentification, DataDescription dataDesc, SystemObject object) {
        _debug.fine("Starte Nachforderung von " + gaps.size() + " L\u00fccken bei " + String.valueOf(archivesToRequestFrom));
        DataIndexRangeSet remainingGaps = new DataIndexRangeSet(gaps);
        DataIndexRangeSet allClosedGaps = new DataIndexRangeSet();
        GapFile gapFile = GapFile.getInstance(this.getPersistenceManager(), dataIdentification);
        HashMap previouslyFailedGapsPerArs = new HashMap();
        gapFile.readGaps(previouslyFailedGapsPerArs);
        HashMap<RemoteArchive, DataIndexRangeSet> failedGapsPerArs = new HashMap<RemoteArchive, DataIndexRangeSet>(previouslyFailedGapsPerArs);
        for (RemoteArchive archiveObject : archivesToRequestFrom) {
            DataIndexRangeSet closedGaps;
            DataIndexRangeSet previouslyFailedGaps = (DataIndexRangeSet)previouslyFailedGapsPerArs.get(archiveObject);
            if (previouslyFailedGaps == null) {
                previouslyFailedGaps = new DataIndexRangeSet();
            }
            DataIndexRangeSet gapsToRequest = new DataIndexRangeSet(remainingGaps);
            if (this.archiveList.isEmpty()) {
                gapsToRequest.removeAll(previouslyFailedGaps);
            }
            if ((closedGaps = this.requestGapsFromArchive(gapsToRequest, archiveObject, dataDesc, object)) == null) continue;
            allClosedGaps.addAll(closedGaps);
            DataIndexRangeSet failedGaps = new DataIndexRangeSet(gapsToRequest);
            failedGaps.addAll(previouslyFailedGaps);
            failedGaps.removeAll(closedGaps);
            failedGapsPerArs.put(archiveObject, failedGaps);
            remainingGaps.removeAll(closedGaps);
            if (remainingGaps.isEmpty()) {
                _debug.fine("Alle L\u00fccken sind beim Nachfordern geschlossen worden, weitere Archivsysteme werden ignoriert.");
                break;
            }
            if (!this.shouldTerminate()) continue;
            _debug.fine("Nachforderung abgebrochen.");
            break;
        }
        for (DataIndexRangeSet value : failedGapsPerArs.values()) {
            value.removeAll(allClosedGaps);
        }
        gapFile.writeGaps(failedGapsPerArs);
    }

    @Nullable
    private DataIndexRangeSet requestGapsFromArchive(DataIndexRangeSet gaps, RemoteArchive archiveSystem, DataDescription dataDesc, SystemObject object) {
        DataIndexRangeSet closedGaps = new DataIndexRangeSet();
        if (gaps.isEmpty()) {
            return closedGaps;
        }
        ArchiveRequestManager arm = archiveSystem.createRequestManager(this.getArchMgr().getDavCon());
        if (arm == null) {
            _debug.info("Nachfordern: Archivsystem '" + String.valueOf(archiveSystem) + "' ist nicht erreichbar");
            return null;
        }
        for (Range<Long> gap : gaps) {
            this.suspendTaskIfNecessary();
            long lowBnd = Util.dIdxAppendZeroModBits((long)((Long)gap.lowerEndpoint()));
            long upBnd = Util.dIdxAppendZeroModBits((long)((Long)gap.upperEndpoint()));
            try {
                DataIndexRangeSet requestedGaps = this.requestSingleGapFromArchive(archiveSystem, dataDesc, object, arm, lowBnd, upBnd);
                if (requestedGaps == null) {
                    return null;
                }
                closedGaps.addAll(requestedGaps);
            }
            catch (IllegalStateException | InterruptedException | TimeoutException e) {
                _debug.warning("Nachfordern: Problem bei Anfrage an '" + String.valueOf(archiveSystem) + "'", (Throwable)e);
                return null;
            }
            if (!this.shouldTerminate()) continue;
            break;
        }
        return closedGaps;
    }

    @Nullable
    private DataIndexRangeSet requestSingleGapFromArchive(RemoteArchive archiveSystem, DataDescription dataDesc, SystemObject object, ArchiveRequestManager arm, long lowBnd, long upBnd) throws TimeoutException, InterruptedException {
        return TimeoutManager.callWithTimeout(timeout -> {
            DataIndexRangeSet innerClosedGaps = new DataIndexRangeSet();
            ArchiveDataQueryResult res = arm.request(REQUEST_PRIO, this.buildRequest(lowBnd, upBnd, dataDesc, object));
            if (!res.isRequestSuccessful()) {
                _debug.warning("Nachforderungsanfrage an Archivsystem '" + String.valueOf(archiveSystem) + "' fehlgeschlagen", (Object)res.getErrorMessage());
                return null;
            }
            timeout.tick();
            ArchiveDataStream ads = res.getStreams()[0];
            try {
                ArchiveData ad;
                while ((ad = ads.take()) != null) {
                    timeout.tick();
                    if (RequestGapTask.idx(ad) >= upBnd) {
                        break;
                    }
                    if (RequestGapTask.idx(ad) < lowBnd || !RequestGapTask.properDataState(ad)) continue;
                    this.getArchMgr().getInQueuesMgr().archiveRequestedData(System.currentTimeMillis(), ad);
                    innerClosedGaps.addRange(RequestGapTask.noModBits(ad.getDataIndex()), RequestGapTask.noModBits(ad.getDataIndex()) + 1L);
                }
            }
            catch (IOException e) {
                _debug.warning("Fehler beim Empfang eines Nachforderungs-Datensatzes von '" + String.valueOf(archiveSystem) + "'", (Throwable)e);
            }
            finally {
                ads.abort();
            }
            return innerClosedGaps;
        });
    }

    private List<RemoteArchive> copyReqArSFromDIN(DataIdentNode din) {
        ArrayList<RemoteArchive> otherArchives = new ArrayList<RemoteArchive>();
        HashSet<String> singleEntries = new HashSet<String>();
        for (int i = 0; i < din.arSParamGetAnzNachfordern(); ++i) {
            String pid = din.arSParamGetNachfordern(i);
            if (pid == null || pid.isEmpty() || pid.equals("0") || singleEntries.contains(pid) || this.getArchMgr().getConfigAuth().getPid().equals(pid)) continue;
            otherArchives.add(RemoteArchive.open(pid));
            singleEntries.add(pid);
        }
        return otherArchives;
    }

    private ArchiveDataSpecification buildRequest(long startIdx, long endIdx, DataDescription dataDesc, SystemObject object) {
        return new ArchiveDataSpecification(new ArchiveTimeSpecification(TimingType.DATA_INDEX, false, startIdx, endIdx), this.requestAdk, ArchiveOrder.BY_INDEX, ArchiveRequestOption.NORMAL, dataDesc, object);
    }

    private static boolean isGap(long start, long end) {
        return start != -1L && RequestGapTask.noModBits(end) - RequestGapTask.noModBits(start) > 1L;
    }

    private static boolean properDataState(ArchiveData ad) {
        DataState ds = ad.getDataType();
        return ds.equals(DataState.DATA) || ds.equals(DataState.NO_DATA) || ds.equals(DataState.NO_SOURCE);
    }

    private static long idx(ArchiveData ad) {
        return ad.getDataIndex();
    }

    private static long noModBits(long dataIndex) {
        return Util.dIdxNoModBits((long)dataIndex);
    }

    public static class RequestGapResultData
    extends ResultData {
        public RequestGapResultData() {
            super(null, null, 0L, null);
        }
    }
}

