/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.TaskManager;
import de.bsvrz.ars.ars.mgmt.TaskManagerInterface;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentTree;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.sys.funclib.debug.Debug;

public abstract class Task {
    protected static final Debug _debug = Debug.getLogger();
    protected volatile boolean _shouldTerminate;
    private final TaskManagerInterface taskManagerInterface;
    private final PersistenceManager persMgr;

    public Task(TaskManager taskManagerInterface) {
        this.taskManagerInterface = taskManagerInterface;
        this.persMgr = this.taskManagerInterface != null ? taskManagerInterface.getPersistenceManager() : null;
    }

    public Task(PersistenceManager persistenceManager) {
        this.taskManagerInterface = persistenceManager;
        this.persMgr = persistenceManager;
    }

    public abstract void start();

    public void terminateTask() {
        this._shouldTerminate = true;
    }

    public boolean shouldTerminate() {
        return this._shouldTerminate;
    }

    public final void suspendTaskIfNecessary() {
        try {
            TaskManagerInterface archiveManager = this.getArchMgr();
            if (archiveManager != null) {
                archiveManager.suspendTaskIfNecessary(this);
            }
        }
        catch (InterruptedException e) {
            _debug.warning("Thread wurde beim Warten unterbrochen", (Throwable)e);
        }
    }

    public abstract String getName();

    public abstract void join() throws InterruptedException;

    public abstract boolean isAlive();

    public abstract boolean isTerminated();

    public TaskManagerInterface getArchMgr() {
        return this.taskManagerInterface;
    }

    public DataIdentTree getDidTree() {
        return this.persMgr.getDataIdentTree();
    }

    public PersistenceManager getPersistenceManager() {
        return this.persMgr;
    }
}

