/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks.scheduler;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.tasks.RequestGapTask;
import de.bsvrz.ars.ars.mgmt.tasks.scheduler.TimeIntervalCron;
import de.bsvrz.sys.funclib.debug.Debug;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class TaskScheduler {
    private static final ThreadLocal<DateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd.MM.yyyy HH:mm:ss"));
    private static final int ONE_MINUTE = 60000;
    private static final long ONE_HOUR = 3600000L;
    private static Debug logger;
    private final Timer timer;
    private final ArchiveManager archiveManager;
    private final TimeIntervalCron deletePermanentlyTimeInterval = new TimeIntervalCron();
    private final TimeIntervalCron requestTimeInterval = new TimeIntervalCron();
    private Date deletePermanentlyLastRun;
    private Date requestLastRun;
    private final CronTask deletePermanentlyCronTask;
    private final CronTask requestCronTask;
    private final TimerTask saveUnsubscriptionTimeTask;

    public TaskScheduler(ArchiveManager archiveManager) {
        logger = Debug.getLogger();
        this.timer = new Timer();
        this.archiveManager = archiveManager;
        this.deletePermanentlyCronTask = new CronTask(this.deletePermanentlyTimeInterval);
        this.requestCronTask = new CronTask(this.requestTimeInterval);
        this.saveUnsubscriptionTimeTask = new UnsubscriptionTimerTask();
    }

    public void start() {
        long start = 60000L - System.currentTimeMillis() % 60000L;
        start = start < 100L ? 0L : start;
        this.timer.scheduleAtFixedRate((TimerTask)this.deletePermanentlyCronTask, start, 60000L);
        this.timer.scheduleAtFixedRate((TimerTask)this.requestCronTask, start, 60000L);
        this.timer.scheduleAtFixedRate(this.saveUnsubscriptionTimeTask, start, 3600000L);
    }

    public void setIntervals(String request) {
        this.requestTimeInterval.setFields(request);
        if (this.requestTimeInterval.hasParseErrors()) {
            logger.warning("'" + request + "' ist kein g\u00fcltiger ZeitIntervallCron f\u00fcr das Nachforderungsintervall. Automatischer Start f\u00fcr das Nachfordern DEAKTIVIERT");
        } else {
            logger.fine("Setze Nachforderungsintervall auf: " + String.valueOf(this.requestTimeInterval));
        }
    }

    public void setDeletePermanentlyInterval(String permanentlyDeleteCron, boolean enabled) {
        if (!enabled) {
            this.deletePermanentlyTimeInterval.setFields("");
        } else {
            this.deletePermanentlyTimeInterval.setFields(permanentlyDeleteCron);
        }
        if (this.deletePermanentlyTimeInterval.hasParseErrors()) {
            logger.warning("'" + permanentlyDeleteCron + "' ist kein g\u00fcltiger ZeitIntervallCron f\u00fcr das endg\u00fcltige L\u00f6schintervall. Automatischer Start f\u00fcr das endg\u00fcltige L\u00f6schen DEAKTIVIERT");
        } else {
            logger.fine("Setze Intervall f\u00fcr das endg\u00fcltige L\u00f6schen auf: " + String.valueOf(this.deletePermanentlyTimeInterval));
        }
    }

    public String getDeletePermanentlyIntervals() {
        return this.deletePermanentlyTimeInterval.toString();
    }

    public String getDeletePermanentlyLastRun() {
        if (this.deletePermanentlyLastRun != null) {
            return dateFormat.get().format(this.deletePermanentlyLastRun);
        }
        return "(wurde noch nie gestartet)";
    }

    public String getDeletePermanentlyNextRun() {
        if (this.deletePermanentlyTimeInterval.hasValues()) {
            Calendar deletePermanentlyNextRun = this.deletePermanentlyTimeInterval.getNextRun(null);
            if (deletePermanentlyNextRun != null) {
                return dateFormat.get().format(deletePermanentlyNextRun.getTime());
            }
            return "> 1 Jahr";
        }
        return "---";
    }

    public String getRequestIntervals() {
        return this.requestTimeInterval.toString();
    }

    public String getRequestLastRun() {
        if (this.requestLastRun != null) {
            return dateFormat.get().format(this.requestLastRun);
        }
        return "(wurde noch nie gestartet)";
    }

    public String getRequestNextRun() {
        if (this.requestTimeInterval.hasValues()) {
            Calendar requestNextRun = this.requestTimeInterval.getNextRun(null);
            if (requestNextRun != null) {
                return dateFormat.get().format(requestNextRun.getTime());
            }
            return "> 1 Jahr";
        }
        return "---";
    }

    public void terminate() {
        if (this.deletePermanentlyCronTask != null) {
            this.deletePermanentlyCronTask.cancel();
        }
        if (this.requestCronTask != null) {
            this.requestCronTask.cancel();
        }
        if (this.saveUnsubscriptionTimeTask != null) {
            this.saveUnsubscriptionTimeTask.cancel();
        }
        this.timer.cancel();
    }

    private class CronTask
    extends TimerTask {
        private final TimeIntervalCron tic;

        public CronTask(TimeIntervalCron tic) {
            this.tic = tic;
        }

        @Override
        public void run() {
            Date d = new Date(this.scheduledExecutionTime());
            if (this.tic.shouldRun(d)) {
                if (this.tic == TaskScheduler.this.deletePermanentlyTimeInterval) {
                    logger.info("Starte endgueltiges Loeschen");
                    try {
                        TaskScheduler.this.archiveManager.getInQueuesMgr().startDeletePermanently();
                        TaskScheduler.this.deletePermanentlyLastRun = d;
                    }
                    catch (RuntimeException e) {
                        logger.warning("Fehler beim Start des des endg\u00fcltigen L\u00f6schens", (Throwable)e);
                    }
                } else if (this.tic == TaskScheduler.this.requestTimeInterval) {
                    logger.info("Starte Nachforderung fehlender Archivdaten");
                    try {
                        TaskScheduler.this.archiveManager.getInQueuesMgr().insertInRequestQueue(RequestGapTask.getRequestGapResultData());
                        TaskScheduler.this.requestLastRun = d;
                    }
                    catch (RuntimeException e) {
                        logger.warning("Fehler beim Start der Nachforderung fehlender Archivdaten", (Throwable)e);
                    }
                }
            }
        }
    }

    private class UnsubscriptionTimerTask
    extends TimerTask {
        private UnsubscriptionTimerTask() {
        }

        @Override
        public void run() {
            TaskScheduler.this.archiveManager.getPersistenceManager().saveUnsubscriptionTime();
        }
    }
}

