/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.mgmt.tasks.scheduler;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public final class TimeIntervalCron {
    private static final HashMap<String, Integer> DAYNAMES = new HashMap(7);
    private boolean hasParseErrors;
    private String originalTimeIntervalCron = "";
    private boolean[] minute;
    private boolean[] hour;
    private boolean[] dayOfMonth;
    private boolean[] month;
    private boolean[] dayOfWeek;
    private final Calendar c = Calendar.getInstance();

    public TimeIntervalCron() {
        this.init();
    }

    public TimeIntervalCron(String fields) {
        this.setFields(fields);
    }

    public void setFields(String fields) {
        this.init();
        this.originalTimeIntervalCron = fields;
        this.hasParseErrors = false;
        if (fields.isEmpty()) {
            return;
        }
        String[] field = fields.split("\\s+");
        if (field.length != 5) {
            this.hasParseErrors = true;
            return;
        }
        try {
            TimeIntervalCron.parseField(field[0], this.minute, 0);
            TimeIntervalCron.parseField(field[1], this.hour, 0);
            TimeIntervalCron.parseField(field[2], this.dayOfMonth, 1);
            TimeIntervalCron.parseField(field[3], this.month, 1);
            TimeIntervalCron.parseField(field[4], this.dayOfWeek, 0);
        }
        catch (ParseException e) {
            this.init();
            this.hasParseErrors = true;
        }
    }

    public boolean shouldRun(Date date) {
        this.c.setTime(date);
        int min = this.c.get(12);
        int h = this.c.get(11);
        int dom = this.c.get(5) - 1;
        int mon = this.c.get(2);
        int dow = switch (this.c.get(7)) {
            case 2 -> 1;
            case 3 -> 2;
            case 4 -> 3;
            case 5 -> 4;
            case 6 -> 5;
            case 7 -> 6;
            case 1 -> 0;
            default -> throw new AssertionError();
        };
        return this.minute[min] && this.hour[h] && this.dayOfMonth[dom] && this.month[mon] && this.dayOfWeek[dow];
    }

    public Calendar getNextRun(Calendar startingFrom) {
        Calendar nextRun = Calendar.getInstance();
        if (startingFrom != null) {
            nextRun.setTime(startingFrom.getTime());
        } else {
            nextRun.add(12, 1);
        }
        nextRun.set(13, 0);
        Calendar lastTry = Calendar.getInstance();
        lastTry.setTime(nextRun.getTime());
        lastTry.add(1, 1);
        lastTry.add(5, 1);
        while (!nextRun.after(lastTry)) {
            if (this.shouldRun(nextRun.getTime())) {
                return nextRun;
            }
            if (!this.month[nextRun.get(2)]) {
                nextRun.set(12, 0);
                nextRun.set(11, 0);
                nextRun.set(5, 1);
                nextRun.add(2, 1);
                continue;
            }
            if (!this.dayOfWeek[nextRun.get(7) - 1]) {
                nextRun.set(12, 0);
                nextRun.set(11, 0);
                nextRun.add(5, 1);
                continue;
            }
            if (!this.dayOfMonth[nextRun.get(5) - 1]) {
                nextRun.set(12, 0);
                nextRun.set(11, 0);
                nextRun.add(5, 1);
                continue;
            }
            if (!this.hour[nextRun.get(11)]) {
                nextRun.set(12, 0);
                nextRun.add(11, 1);
                continue;
            }
            nextRun.add(12, 1);
        }
        return null;
    }

    public boolean hasValues() {
        if (this.hasParseErrors) {
            return false;
        }
        for (boolean aMinute : this.minute) {
            if (!aMinute) continue;
            return true;
        }
        for (boolean aHour : this.hour) {
            if (!aHour) continue;
            return true;
        }
        for (boolean aDayOfMonth : this.dayOfMonth) {
            if (!aDayOfMonth) continue;
            return true;
        }
        for (boolean aMonth : this.month) {
            if (!aMonth) continue;
            return true;
        }
        for (int i = 0; i < this.dayOfWeek.length; ++i) {
            if (!this.dayOfMonth[i]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.hasParseErrors) {
            return this.originalTimeIntervalCron + " (deaktiviert - ParseErrors)";
        }
        return this.originalTimeIntervalCron.isEmpty() ? "(deaktiviert)" : this.originalTimeIntervalCron;
    }

    public String getParsedInterval() {
        StringBuilder sb = new StringBuilder();
        this.appendItem(sb, this.minute, 0);
        sb.append("   ");
        this.appendItem(sb, this.hour, 0);
        sb.append("   ");
        this.appendItem(sb, this.dayOfMonth, 1);
        sb.append("   ");
        this.appendItem(sb, this.month, 1);
        sb.append("   ");
        this.appendItem(sb, this.dayOfWeek, 0);
        if (sb.length() == 12) {
            return "(deaktiviert)";
        }
        return sb.toString();
    }

    private void appendItem(StringBuilder sb, boolean[] dayOfWeek, int increment) {
        for (int i = 0; i < dayOfWeek.length; ++i) {
            if (!dayOfWeek[i]) continue;
            sb.append(i + increment).append(",");
        }
        if (!sb.isEmpty() && sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
    }

    public boolean hasParseErrors() {
        return this.hasParseErrors;
    }

    private static void parseField(String field, boolean[] destArray, int offset) throws ParseException {
        if (field.equals("*")) {
            Arrays.fill(destArray, true);
            return;
        }
        if (field.indexOf(44) > 0) {
            String[] subField;
            for (String aSubField : subField = field.split(",")) {
                TimeIntervalCron.parseField(aSubField, destArray, offset);
            }
            return;
        }
        int index = field.indexOf(45);
        if (index > 0) {
            int max;
            int min;
            try {
                min = Integer.parseInt(field.substring(0, index));
            }
            catch (NumberFormatException e) {
                min = TimeIntervalCron.nameToNumber(field.substring(0, index));
            }
            try {
                max = Integer.parseInt(field.substring(index + 1));
            }
            catch (NumberFormatException e) {
                max = TimeIntervalCron.nameToNumber(field.substring(index + 1));
            }
            if (max < 0 || min < 0) {
                throw new ParseException("Fehler beim Parsen des Felders '" + field + "'", 0);
            }
            if ((max = Math.min(max - offset, destArray.length)) < (min = Math.max(min - offset, 0))) {
                int i;
                for (i = max; i <= destArray.length - 1; ++i) {
                    destArray[i] = true;
                }
                for (i = 0; i <= min; ++i) {
                    destArray[i] = true;
                }
            } else {
                for (int i = min; i <= max; ++i) {
                    destArray[i] = true;
                }
            }
            return;
        }
        try {
            index = Integer.parseInt(field);
            destArray[index - offset] = true;
        }
        catch (Exception e) {
            index = TimeIntervalCron.nameToNumber(field);
            if (index > -1) {
                destArray[index] = true;
            }
            throw new ParseException("Fehler beim Parsen des Felders '" + field + "'", 0);
        }
    }

    private static int nameToNumber(String s) {
        return DAYNAMES.getOrDefault(s.toLowerCase(), -1);
    }

    private void init() {
        this.minute = new boolean[60];
        this.hour = new boolean[24];
        this.dayOfMonth = new boolean[31];
        this.month = new boolean[12];
        this.dayOfWeek = new boolean[7];
    }

    static {
        DAYNAMES.put("so", 0);
        DAYNAMES.put("mo", 1);
        DAYNAMES.put("di", 2);
        DAYNAMES.put("mi", 3);
        DAYNAMES.put("do", 4);
        DAYNAMES.put("fr", 5);
        DAYNAMES.put("sa", 6);
    }
}

