/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class CacheManager {
    private static final int MINIMUM_BUFFER_SIZE = 0;
    private static final int DEFAULT_BUFFER_SIZE = 5120;
    private static final int MAXIMUM_BUFFER_SIZE = 33792;
    private static final CacheManager _cacheManager = new CacheManager();
    private final HashMap<Long, Cache> _containerId2Cache = new HashMap();
    private int _defaultBufferSize = 5120;
    private final HashSet<IdDataIdentification> _disabledCacheIdentifications = new HashSet();
    private static final Debug _debug = Debug.getLogger();
    private long _writeCountSum;
    private long _processedCountSum;
    private long _bufferedCountSum;
    private long _unbufferedCountSum;
    private boolean _cacheEnabled = true;

    private CacheManager() {
    }

    public static CacheManager getInstance() {
        return _cacheManager;
    }

    public void init(ArgumentList argumentList) {
        _debug.fine("CacheManager.init " + String.valueOf(argumentList));
        this._writeCountSum = 0L;
        this._processedCountSum = 0L;
        this._bufferedCountSum = 0L;
        this._unbufferedCountSum = 0L;
        this._containerId2Cache.clear();
        this._disabledCacheIdentifications.clear();
        this._defaultBufferSize = argumentList.fetchArgument("-cachePufferGroesse=5120").intValue();
        if (this._defaultBufferSize < 0) {
            this._defaultBufferSize = 0;
        }
        if (this._defaultBufferSize > 33792) {
            this._defaultBufferSize = 33792;
        }
        String info = "Cache wurde initialisiert. Puffergr\u00f6\u00dfe wurde auf " + this._defaultBufferSize + " Bytes je Container eingestellt.";
        if (!this.isCacheEnabled()) {
            info = info + " Cache ist momentan deaktiviert.";
        }
        _debug.info(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        long start;
        ArrayList<Cache> caches;
        _debug.fine("CacheManager.close");
        _debug.info("Cache wird geschlossen. Alle Puffer werden auf Platte geschrieben.");
        this._disabledCacheIdentifications.clear();
        HashMap<Long, Cache> hashMap = this._containerId2Cache;
        synchronized (hashMap) {
            caches = new ArrayList<Cache>(this._containerId2Cache.values());
            this._containerId2Cache.clear();
        }
        int goodFlushCount = 0;
        int badFlushCount = 0;
        long lastPrintTime = start = System.currentTimeMillis();
        int count = caches.size();
        for (Cache cache : caches) {
            long now = System.currentTimeMillis();
            if (now - lastPrintTime > 60000L) {
                lastPrintTime = now;
                String runtimeProgress = StatusPrinter.estimateRuntime(Duration.ofMillis(now - start), badFlushCount + goodFlushCount, count);
                if (badFlushCount == 0) {
                    _debug.info(goodFlushCount + " von " + count + " Puffer wurden bisher geschrieben...\n" + runtimeProgress);
                } else {
                    _debug.info(goodFlushCount + " von " + count + " Puffer wurden bisher geschrieben. " + badFlushCount + " Puffer konnten nicht geschrieben werden...\n" + runtimeProgress);
                }
            }
            try {
                cache.flush();
                this.aggregateCounts(cache);
                ++goodFlushCount;
            }
            catch (PersistenceException e) {
                ++badFlushCount;
                _debug.warning("Fehler beim Schreiben von gecachten Daten eines Containers: " + String.valueOf(cache), (Throwable)e);
            }
        }
        this.logCloseMessage(badFlushCount, goodFlushCount);
    }

    private void logCloseMessage(int badFlushCount, int goodFlushCount) {
        Object message = "CacheManager wurde geschlossen.\n";
        message = badFlushCount == 0 ? (String)message + "Alle " + goodFlushCount + " Puffer wurden auf Platte geschrieben.\n" : (String)message + goodFlushCount + " Puffer wurden auf Platte geschrieben. " + badFlushCount + " Puffer konnten nicht geschrieben werden\n";
        message = (String)message + this._processedCountSum + " Datenbl\u00f6cke wurden verarbeitet.\n";
        message = (String)message + this._bufferedCountSum + " Datenbl\u00f6cke wurden zwischengespeichert.\n";
        message = (String)message + this._unbufferedCountSum + " Datenbl\u00f6cke wurden nicht zwischengespeichert.\n";
        message = (String)message + this._writeCountSum + " Schreibzugriffe.";
        _debug.info((String)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        ArrayList<Cache> caches;
        _debug.fine("CacheManager.flushAll");
        _debug.info("Alle Puffer werden auf Platte geschrieben.");
        HashMap<Long, Cache> hashMap = this._containerId2Cache;
        synchronized (hashMap) {
            caches = new ArrayList<Cache>(this._containerId2Cache.values());
        }
        int goodFlushCount = 0;
        int badFlushCount = 0;
        for (Cache cache : caches) {
            try {
                cache.flush();
                ++goodFlushCount;
            }
            catch (PersistenceException e) {
                ++badFlushCount;
                _debug.warning("Fehler beim Schreiben von gecachten Daten eines Containers: " + String.valueOf(cache), (Throwable)e);
            }
        }
        Object message = "";
        message = badFlushCount == 0 ? (String)message + "Alle " + goodFlushCount + " Puffer wurden auf Platte geschrieben.\n" : (String)message + goodFlushCount + " Puffer wurden auf Platte geschrieben. " + badFlushCount + " Puffer konnten nicht geschrieben werden\n";
        _debug.info((String)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheMemoryUsage getCachedMemory() {
        long bufferSum = 0L;
        long usedSum = 0L;
        long overheadSum = 100L;
        HashMap<Long, Cache> hashMap = this._containerId2Cache;
        synchronized (hashMap) {
            for (Cache cache : this._containerId2Cache.values()) {
                bufferSum += (long)cache._out.bufSize();
                usedSum += (long)cache._out.size();
                overheadSum += 77L;
            }
        }
        return new CacheMemoryUsage(bufferSum + overheadSum, usedSum);
    }

    public Cache getCache(ContainerFile containerFile) {
        return this.getCache(containerFile.getContainerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(long containerId) {
        _debug.fine("CacheManager.getCache " + containerId);
        HashMap<Long, Cache> hashMap = this._containerId2Cache;
        synchronized (hashMap) {
            return this._containerId2Cache.get(containerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache createCache(ContainerFile cont, boolean createFile, IdDataIdentification dataIdentification) {
        Path contFile = cont.getContFile();
        if (contFile == null) {
            throw new AssertionError((Object)"Ung\u00fcltige Containerdatei angegeben.");
        }
        if (!this._cacheEnabled) {
            return null;
        }
        HashSet<IdDataIdentification> hashSet = this._disabledCacheIdentifications;
        synchronized (hashSet) {
            if (this._disabledCacheIdentifications.contains(dataIdentification)) {
                _debug.fine("CacheManager.createCache " + String.valueOf(dataIdentification) + " wird nicht gecacht");
                return null;
            }
        }
        _debug.fine("CacheManager.createCache " + String.valueOf(dataIdentification) + " wird gecacht");
        Cache cache = new Cache(contFile.toFile(), createFile, this._defaultBufferSize);
        HashMap<Long, Cache> hashMap = this._containerId2Cache;
        synchronized (hashMap) {
            this._containerId2Cache.put(cont.getContainerId(), cache);
        }
        return cache;
    }

    public void forgetCache(ContainerFile containerFile) {
        this.forgetCache(containerFile.getContainerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetCache(long containerId) {
        _debug.fine("CacheManager.forgetCache " + containerId);
        HashMap<Long, Cache> hashMap = this._containerId2Cache;
        synchronized (hashMap) {
            Cache cache = this._containerId2Cache.remove(containerId);
            if (cache != null) {
                this.aggregateCounts(cache);
            }
        }
    }

    private void aggregateCounts(Cache cache) {
        this._writeCountSum += (long)cache._writeCount;
        this._processedCountSum += (long)cache._processedCount;
        this._bufferedCountSum += (long)cache._bufferedCount;
        this._unbufferedCountSum += (long)cache._unbufferedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getCounts() {
        HashMap<Long, Cache> hashMap = this._containerId2Cache;
        synchronized (hashMap) {
            return new long[]{this._writeCountSum, this._processedCountSum, this._bufferedCountSum, this._unbufferedCountSum};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCachingEnabled(long objectId, long atgId, long aspectId, int simulationVariant, boolean enable) {
        IdDataIdentification identificationIds = new IdDataIdentification(objectId, atgId, aspectId, simulationVariant);
        _debug.fine("CacheManager.setCachingEnabled " + String.valueOf(identificationIds) + (enable ? " ENABLE" : " DISABLE"));
        HashSet<IdDataIdentification> hashSet = this._disabledCacheIdentifications;
        synchronized (hashSet) {
            if (enable) {
                this._disabledCacheIdentifications.remove(identificationIds);
            } else {
                this._disabledCacheIdentifications.add(identificationIds);
            }
        }
    }

    public boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this._cacheEnabled = cacheEnabled;
    }

    long getWriteCountSum() {
        return this._writeCountSum;
    }

    long getProcessedCountSum() {
        return this._processedCountSum;
    }

    long getBufferedCountSum() {
        return this._bufferedCountSum;
    }

    long getUnbufferedCountSum() {
        return this._unbufferedCountSum;
    }

    public static class Cache {
        private static final Debug _debug = Debug.getLogger();
        private final File _file;
        private boolean _createFile;
        private final int _bufferSize;
        private final MyByteArrayOutputStream _out;
        private int _containerSize;
        private int _writeCount;
        private int _processedCount;
        private int _bufferedCount;
        private int _unbufferedCount;

        File getFile() {
            return this._file;
        }

        public int getBufferSize() {
            return this._bufferSize;
        }

        int getWriteCount() {
            return this._writeCount;
        }

        int getProcessedCount() {
            return this._processedCount;
        }

        int getBufferedCount() {
            return this._bufferedCount;
        }

        int getUnbufferedCount() {
            return this._unbufferedCount;
        }

        private Cache(File file, boolean createFile, int bufferSize) {
            _debug.fine("CacheManager$Cache.Cache " + String.valueOf(file) + (createFile ? " create " : " append ") + bufferSize);
            this._file = file;
            this._createFile = createFile;
            this._bufferSize = bufferSize;
            this._containerSize = this._createFile ? 0 : (int)file.length();
            this._out = new MyByteArrayOutputStream();
        }

        public long getContainerSize() {
            _debug.fine("CacheManager$Cache.getContainerSize");
            return this._containerSize;
        }

        public void cache(byte[] data, int length) throws PersistenceException {
            ++this._processedCount;
            int cachedSize = this._out.size();
            if (length + cachedSize <= this._bufferSize) {
                ++this._bufferedCount;
                this._out.write(data, 0, length);
            } else if (length >= this._bufferSize / 2) {
                this.writeCacheAndDataToFile(data, length);
            } else {
                this.writeCacheAndDataToFile(null, 0);
                ++this._bufferedCount;
                this._out.write(data, 0, length);
            }
            this._containerSize += length;
        }

        public void flush() throws PersistenceException {
            _debug.fine("CacheManager$Cache.flush");
            if (this._out.size() > 0) {
                this.writeCacheAndDataToFile(null, 0);
            }
        }

        public String toString() {
            return "Cache f\u00fcr Container-Datei " + this._file.toString();
        }

        private void writeCacheAndDataToFile(byte[] data, int length) throws PersistenceException {
            ContainerFile.writeContainerFileSafely(this._file.toPath(), this._createFile, outputStream -> {
                ++this._writeCount;
                this._createFile = false;
                if (this._out.size() > 0) {
                    this._out.writeTo(outputStream);
                    this._out.reset();
                }
                if (data != null) {
                    ++this._unbufferedCount;
                    outputStream.write(data, 0, length);
                }
            });
        }
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MyByteArrayOutputStream() {
        }

        public int bufSize() {
            return this.buf.length;
        }
    }

    public record CacheMemoryUsage(long totalBytesUsed, long cachedBytes) {
    }
}

