/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.IndexAggregator;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndex;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.result.AggregateIndexResult;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.index.result.LocatedIndexResult;
import de.bsvrz.ars.ars.persistence.sequence.AllDataSpecification;
import de.bsvrz.ars.ars.persistence.sequence.ArchiveTimeSequenceSpecification;
import de.bsvrz.ars.ars.persistence.sequence.SequenceSpecification;
import java.util.List;
import java.util.Map;

public class CompoundArchiveTimeIndex {
    private final List<ArchiveTimeIndex> indexes;
    private final Map<ArchiveTimeIndex, PersistenceDirectory> directories;

    public CompoundArchiveTimeIndex(List<ArchiveTimeIndex> indexes, Map<ArchiveTimeIndex, PersistenceDirectory> directories) {
        this.indexes = indexes;
        this.directories = directories;
    }

    public CompoundArchiveTimeIndex(IndexAggregator<ArchiveTimeIndex> aggregator) {
        this(aggregator.getIndexes(), aggregator.getMap());
    }

    public LocatedIndexResult<IndexValues> getContainerIDByArchiveTime(long minimumTime, long maximumTime) throws IndexException {
        AggregateIndexResult<IndexValues> result = new AggregateIndexResult<IndexValues>();
        for (ArchiveTimeIndex index : this.indexes) {
            IndexResult<IndexValues> time = index.getContainerIDByArchiveTime(minimumTime, maximumTime);
            result.add(time, this.directories.get(index));
        }
        return result;
    }

    public boolean isComplete(SequenceSpecification sequenceSpecification) throws IndexException {
        if (sequenceSpecification instanceof AllDataSpecification) {
            return true;
        }
        if (sequenceSpecification instanceof ArchiveTimeSequenceSpecification) {
            ArchiveTimeSequenceSpecification specification = (ArchiveTimeSequenceSpecification)sequenceSpecification;
            if (this.indexes.isEmpty()) {
                return false;
            }
            if (this.indexes.get(0).getFirst(IndexValues.ArchiveTimeMin) > specification.minimumTime()) {
                return false;
            }
            return this.indexes.get(this.indexes.size() - 1).getLast(IndexValues.ArchiveTimeMax) >= specification.maximumTime();
        }
        throw new UnsupportedOperationException();
    }
}

