/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.IndexAggregator;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.DataIndexIndex;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.result.AggregateIndexResult;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.index.result.LocatedIndexResult;
import de.bsvrz.ars.ars.persistence.sequence.AllDataSpecification;
import de.bsvrz.ars.ars.persistence.sequence.DataIndexSequenceSpecification;
import de.bsvrz.ars.ars.persistence.sequence.SequenceSpecification;
import java.util.List;
import java.util.Map;

public class CompoundDataIndexIndex {
    private final List<DataIndexIndex> indexes;
    private final Map<DataIndexIndex, PersistenceDirectory> directories;

    public CompoundDataIndexIndex(List<DataIndexIndex> indexes, Map<DataIndexIndex, PersistenceDirectory> directories) {
        this.indexes = indexes;
        this.directories = directories;
    }

    public CompoundDataIndexIndex(IndexAggregator<DataIndexIndex> aggregator) {
        this(aggregator.getIndexes(), aggregator.getMap());
    }

    public LocatedIndexResult<IndexValues> getContainerIDByDataIndex(long minimumTime, long maximumTime) throws IndexException {
        AggregateIndexResult<IndexValues> result = new AggregateIndexResult<IndexValues>();
        for (DataIndexIndex index : this.indexes) {
            IndexResult<IndexValues> time = index.getContainerIDByDataIndex(minimumTime, maximumTime);
            result.add(time, this.directories.get(index));
        }
        return result;
    }

    public boolean isComplete(SequenceSpecification sequenceSpecification) throws IndexException {
        if (sequenceSpecification instanceof AllDataSpecification) {
            return true;
        }
        if (sequenceSpecification instanceof DataIndexSequenceSpecification) {
            DataIndexSequenceSpecification specification = (DataIndexSequenceSpecification)sequenceSpecification;
            if (this.indexes.get(0).getFirst(IndexValues.DataIndexMin) > specification.minimumIndex()) {
                return false;
            }
            return this.indexes.get(this.indexes.size() - 1).getLast(IndexValues.DataIndexMax) >= specification.maximumIndex();
        }
        throw new UnsupportedOperationException();
    }
}

