/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.CollectionUtilities;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.StandaloneContainerFileHandle;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.util.CloseableRandomAccessFile;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.ByteIO;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public final class ContainerDataIterator
implements DataIterator {
    private static int OPEN_FILE_LIMIT = 500;
    private boolean finished;
    private final ContainerManagementData containerManagementData;
    private final ContainerDataResult next = new ContainerDataResult();
    private boolean dataRead;
    private final byte[] byte8Buf = new byte[8];
    private final MyCloseableRandomAccessFile randomAccessFile;
    private int nextDataLen;
    private int counter;
    private final long length;

    public static int getOpenFileLimit() {
        return OPEN_FILE_LIMIT;
    }

    public static void setOpenFileLimit(int openFileLimit) {
        OPEN_FILE_LIMIT = openFileLimit;
    }

    ContainerDataIterator(StandaloneContainerFileHandle containerFileHandle) throws PersistenceException {
        this.containerManagementData = new ContainerHeaders(containerFileHandle);
        this.randomAccessFile = new MyCloseableRandomAccessFile(containerFileHandle.getFile().toFile());
        try {
            this.length = this.randomAccessFile.length();
            this.skipContainerHeader();
            this.finished = !this.readNextDataHdr();
        }
        catch (IOException e) {
            throw new PersistenceException("Container " + String.valueOf(containerFileHandle) + " ist nicht lesbar", e);
        }
        if (this.finished) {
            this.close();
        }
    }

    private void skipContainerHeader() throws IOException {
        this.randomAccessFile.readFully(this.byte8Buf, 0, ContainerFile.VERSION_STRING.length + 4);
        this.randomAccessFile.skipBytes(ByteIO.readSignedInt4Bytes((byte[])this.byte8Buf, (int)ContainerFile.VERSION_STRING.length));
    }

    @Override
    public void peek(ContainerDataResult result) throws PersistenceException {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        if (!this.dataRead) {
            try {
                this.next.setData(this.readRawData());
            }
            catch (IOException e) {
                throw new PersistenceException("Datensatz im Container " + String.valueOf(this.containerManagementData) + " ist nicht lesbar", e);
            }
            this.dataRead = true;
        }
        this.next.copyTo(result);
    }

    @Override
    @Nullable
    public ContainerDataResult peekNext() {
        return null;
    }

    @Override
    public long peekDataIndex() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        return this.next.getDataIndex();
    }

    @Override
    public long peekDataTime() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        return this.next.getDataTime();
    }

    @Override
    public long peekArchiveTime() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        return this.next.getArchiveTime();
    }

    @Override
    public void remove() throws PersistenceException {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        if (!this.dataRead) {
            try {
                this.skipData();
            }
            catch (IOException e) {
                throw new PersistenceException("Datensatz im Container " + String.valueOf(this.containerManagementData) + " konnte nicht \u00fcbersprungen werden", e);
            }
        } else {
            this.next.setData(null);
            this.dataRead = false;
        }
        try {
            this.finished = !this.readNextDataHdr();
        }
        catch (IOException e) {
            throw new PersistenceException("N\u00e4chster Datensatz im Container " + String.valueOf(this.containerManagementData) + " ist nicht lesbar", e);
        }
        if (this.finished) {
            this.close();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.finished;
    }

    @Override
    public void close() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException e) {
            Debug.getLogger().error("Container konnte nicht geschlossen werden: " + String.valueOf(this.containerManagementData), (Throwable)e);
        }
        this.next.setData(null);
    }

    @Override
    @NotNull
    public ContainerManagementData getContainerManagementData() {
        return this.containerManagementData;
    }

    private boolean readNextDataHdr() throws IOException, PersistenceException {
        if (this.randomAccessFile.position() == this.length) {
            return false;
        }
        this.nextDataLen = this.randomAccessFile.readInt();
        this.next.setDataKind(this.containerManagementData.getLocation().archiveDataKind());
        this.next.setContainerID(this.containerManagementData.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID));
        this.next.setArchiveTime(this.randomAccessFile.read6ByteUnsigned());
        this.next.setDataTime(this.randomAccessFile.read6ByteUnsigned());
        this.next.setDataIndex(this.randomAccessFile.readLong());
        int checkSum = this.randomAccessFile.readInt();
        int calcCheckSum = (int)((long)this.nextDataLen + this.next.getArchiveTime() + this.next.getDataTime() + this.next.getDataIndex());
        if (checkSum != calcCheckSum) {
            throw new IOException("Pr\u00fcfsumme des Datensatzes an Pos. " + this.counter + " fehlerhaft: " + checkSum + " != dx=" + this.next.getDataIndex() + "+dt=" + this.next.getDataTime() + "+at=" + this.next.getArchiveTime() + "+len=" + this.nextDataLen + "=" + calcCheckSum + "\n" + String.valueOf(this));
        }
        this.next.setDataSize(this.nextDataLen - 4 - 24 - ByteIO.SEPARATOR.length);
        int dataUncompressedSize = this.randomAccessFile.readInt();
        this.next.setDataUncompressedSize(dataUncompressedSize);
        this.next.setCompressed(dataUncompressedSize != 0);
        DataState state = DataState.DATA;
        if (this.next.getDataSize() == 6) {
            long savedPosition = this.randomAccessFile.position();
            byte[] buffer = new byte[6];
            this.randomAccessFile.readFully(buffer);
            this.randomAccessFile.position(savedPosition);
            if (Util.cmpBytes((byte[])buffer, (int)0, (byte[])ContainerFile.NO_DATA)) {
                state = DataState.NO_DATA;
            } else if (Util.cmpBytes((byte[])buffer, (int)0, (byte[])ContainerFile.NO_SOURCE)) {
                state = DataState.NO_SOURCE;
            } else if (Util.cmpBytes((byte[])buffer, (int)0, (byte[])ContainerFile.NO_RIGHTS)) {
                state = DataState.NO_RIGHTS;
            } else if (Util.cmpBytes((byte[])buffer, (int)0, (byte[])ContainerFile.POT_GAP)) {
                state = DataState.POSSIBLE_GAP;
            }
        }
        this.next.setDataState(state);
        ++this.counter;
        return true;
    }

    @Nullable
    private byte[] readRawData() throws IOException {
        int netDataLen = this.nextDataLen - 4 - 24 - ByteIO.SEPARATOR.length;
        if (!this.next.isData()) {
            this.randomAccessFile.skip(netDataLen + ByteIO.SEPARATOR.length);
            return null;
        }
        byte[] buf = new byte[netDataLen];
        this.randomAccessFile.readFully(buf);
        this.randomAccessFile.skip(ByteIO.SEPARATOR.length);
        return buf;
    }

    private void skipData() throws IOException {
        int netDataLen = this.nextDataLen - 4 - 24;
        this.randomAccessFile.skip(netDataLen);
    }

    private static class MyCloseableRandomAccessFile
    extends CloseableRandomAccessFile {
        private static final ThreadLocal<LinkedHashSet<MyCloseableRandomAccessFile>> openFilesInCurrentThread = ThreadLocal.withInitial(LinkedHashSet::new);
        private static final AtomicInteger numOpenFiles = new AtomicInteger(0);

        MyCloseableRandomAccessFile(File file) {
            super(file);
        }

        protected void openFile() throws IOException {
            MyCloseableRandomAccessFile first;
            while (numOpenFiles.get() > ContainerDataIterator.getOpenFileLimit() && (first = CollectionUtilities.removeOldest(openFilesInCurrentThread.get())) != null) {
                first.closeFile(false);
            }
            numOpenFiles.incrementAndGet();
            openFilesInCurrentThread.get().add(this);
            super.openFile();
        }

        public void closeFile() throws IOException {
            this.closeFile(true);
        }

        void closeFile(boolean removeFromQueue) throws IOException {
            if (!this.isOpen()) {
                return;
            }
            numOpenFiles.decrementAndGet();
            if (removeFromQueue) {
                openFilesInCurrentThread.get().remove((Object)this);
            }
            super.closeFile();
        }

        long read6ByteUnsigned() throws IOException {
            return ((long)this.readUnsignedShort() & 0xFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
    }
}

