/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import java.util.EnumMap;

public class ContainerHeaders
implements ContainerManagementData {
    private final EnumMap<ContainerManagementInformation, Object> _data = new EnumMap(ContainerManagementInformation.class);
    private final ContainerDirectory _location;

    public ContainerHeaders(ContainerManagementData data) throws PersistenceException {
        this._location = data.getLocation();
        for (ContainerManagementInformation information : ContainerManagementInformation.values()) {
            if (information.isNumeric()) {
                this._data.put(information, (Object)data.getContainerHeaderParamAsLong(information));
                continue;
            }
            this._data.put(information, (Object)data.getContainerHeaderParamAsString(information));
        }
    }

    public ContainerHeaders(IndexResult<ContainerManagementInformation> indexResult, IdDataIdentification dataIdentification, ArchiveDataKind adk, int resultIndex) {
        this(indexResult, resultIndex, dataIdentification.resolve(adk));
    }

    public ContainerHeaders(IndexResult<ContainerManagementInformation> indexResult, int resultIndex, ContainerDirectory location) {
        this._location = location;
        for (ContainerManagementInformation information : ContainerManagementInformation.values()) {
            if (information.isNumeric()) {
                this._data.put(information, (Object)indexResult.get(resultIndex, information));
                continue;
            }
            this._data.put(information, (Object)indexResult.getString(resultIndex, information));
        }
    }

    @Override
    public String getContainerHeaderParamAsString(ContainerManagementInformation param) {
        return (String)this._data.get((Object)param);
    }

    @Override
    public boolean getContainerHeaderParamAsBoolean(ContainerManagementInformation param) {
        return this.getContainerHeaderParamAsString(param).equals("1");
    }

    @Override
    public long getContainerHeaderParamAsLong(ContainerManagementInformation param) {
        return (Long)this._data.get((Object)param);
    }

    @Override
    public int getContainerHeaderParamAsInt(ContainerManagementInformation param) {
        return (int)this.getContainerHeaderParamAsLong(param);
    }

    @Override
    public ContainerDirectory getLocation() {
        return this._location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerHeaders that = (ContainerHeaders)o;
        if (!this._data.equals((Object)that._data)) {
            return false;
        }
        return this._location.equals(that._location);
    }

    public int hashCode() {
        int result = this._data.hashCode();
        result = 31 * result + this._location.hashCode();
        return result;
    }
}

