/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import com.google.common.collect.ImmutableList;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.layout.DataKinds;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DataIdentificationDir {
    private final Path _dataIdentificationDir;
    private final IdDataIdentification _dataIdentification;
    private Collection<ArchiveDataSpecification> _ads;
    private final PersistenceDirectory _persistenceDirectory;

    private DataIdentificationDir(Path dataIdentificationDir, IdDataIdentification dataIdentification, PersistenceDirectory persistenceDirectory) {
        this._dataIdentificationDir = dataIdentificationDir;
        this._dataIdentification = dataIdentification;
        this._persistenceDirectory = persistenceDirectory;
    }

    public DataIdentificationDir(PersistenceDirectory persistenceDirectory, IdDataIdentification dataIdentificationFromPath, Path dataIdentificationDir) {
        this(dataIdentificationDir, dataIdentificationFromPath, persistenceDirectory);
    }

    public DataIdentificationDir(PersistenceDirectory persistenceDirectory, IdDataIdentification dataIdentification) {
        this(persistenceDirectory.getPath(dataIdentification), dataIdentification, persistenceDirectory);
    }

    public DataIdentificationDir(PersistenceDirectory persistenceDirectory, IdDataIdentification dataIdentification, Collection<ArchiveDataSpecification> archiveDataSpecifications) {
        this(persistenceDirectory, dataIdentification);
        this._ads = ImmutableList.copyOf(archiveDataSpecifications);
    }

    public Path getDataIdentificationDir() {
        return this._dataIdentificationDir;
    }

    public IdDataIdentification getDataIdentification() {
        return this._dataIdentification;
    }

    @Nullable
    public Collection<ArchiveDataSpecification> getArchiveDataSpecifications() {
        return this._ads;
    }

    public String toString() {
        return this._dataIdentification.toString();
    }

    public ArchiveDataKindCombination getArchiveDataKinds() throws PersistenceException {
        if (this._ads != null) {
            List dataKinds = this._ads.stream().flatMap(it -> it.getDataKinds().stream()).collect(Collectors.toList());
            return new ArchiveDataKindCombination(dataKinds);
        }
        return DataKinds.getAvailableDataKinds(this.getDataIdentificationDir());
    }

    public Collection<? extends ContainerDirectory> getContainerDirectories() throws PersistenceException {
        IdDataIdentification dataIdentification = this.getDataIdentification();
        return this.getArchiveDataKinds().stream().map(dataIdentification::resolve).collect(Collectors.toList());
    }

    public Collection<? extends LockedContainerDirectory> getContainerDirectories(SyncKey<IdDataIdentification> lock) throws PersistenceException {
        assert (lock.getElement().equals(this.getDataIdentification()));
        return this.getArchiveDataKinds().stream().map(it -> new LockedContainerDirectory(lock, (ArchiveDataKind)it)).collect(Collectors.toList());
    }

    public PersistenceDirectory getPersistenceDirectory() {
        return this._persistenceDirectory;
    }
}

