/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.BasicContainerFileHandle;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.ContainerManagementIndex;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.DataSequence;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.util.BufferedRandomAccessFile;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public final class DeletedContainerFile {
    private static final Debug _debug = Debug.getLogger();
    public static final String DELETED_CONTAINER_FILENAME = "_deleted.dat";
    public static final String DELETED_CONTAINER_FILENAME_TMP = "_deleted.tmp";
    public static final String DELETED_CONTAINER_FILENAME_BACKUP = "_deleted.backup";
    private final Map<Long, DeletedContainerData> _map = new TreeMap<Long, DeletedContainerData>();
    private final Path _fileTmp;
    private final Path _fileBackup;
    private final Path _file;
    private final ContainerDirectory _containerFileDir;

    public DeletedContainerFile(Path adkPath, ContainerDirectory containerFileDir) {
        this._file = adkPath.resolve(DELETED_CONTAINER_FILENAME);
        this._fileTmp = adkPath.resolve(DELETED_CONTAINER_FILENAME_TMP);
        this._fileBackup = adkPath.resolve(DELETED_CONTAINER_FILENAME_BACKUP);
        this._containerFileDir = containerFileDir;
    }

    public DeletedContainerFile(ContainerDirectory containerFileDir, PersistenceDirectory persistenceDirectory) {
        this(persistenceDirectory.getPath(containerFileDir), containerFileDir);
    }

    public boolean exists() {
        return Files.exists(this._file, new LinkOption[0]);
    }

    public void read() throws PersistenceException {
        try (BufferedRandomAccessFile fileAccess = new BufferedRandomAccessFile(this._file.toFile(), "r");){
            int length = fileAccess.readInt();
            byte[] tmpHeaderData = new byte[ContainerManagementIndex.INDEX_CONTENT_DESCRIPTOR.getEntryLengthBytes()];
            for (int i = 0; i < length; ++i) {
                fileAccess.readFully(tmpHeaderData);
                DeletedContainerData data = new DeletedContainerData(tmpHeaderData, this._containerFileDir);
                this._map.put(data.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID), data);
                int numDeletedBlocks = fileAccess.readInt();
                for (int f = 0; f < numDeletedBlocks; ++f) {
                    int hashActual;
                    long from = fileAccess.readLong();
                    long to = fileAccess.readLong();
                    int hashExpected = Long.hashCode(from) ^ Long.hashCode(to);
                    if (hashExpected != (hashActual = fileAccess.readInt())) {
                        throw new PersistenceException("Fehler in der Pr\u00fcfsumme der Datei: " + hashExpected + "!=" + hashActual);
                    }
                    byte separator = fileAccess.readByte();
                    if (separator != 0) {
                        throw new PersistenceException("Fehler in der Datei-Struktur");
                    }
                    data.addIndexRange(from, to);
                }
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public void write() throws PersistenceException {
        try (BufferedRandomAccessFile fileAccess = new BufferedRandomAccessFile(this._fileTmp.toFile(), "rw");){
            fileAccess.writeInt(this._map.size());
            byte[] tmpHeaderData = new byte[ContainerManagementIndex.INDEX_CONTENT_DESCRIPTOR.getEntryLengthBytes()];
            for (Map.Entry<Long, DeletedContainerData> entry : this._map.entrySet()) {
                DeletedContainerData data = entry.getValue();
                data.serialize(tmpHeaderData);
                fileAccess.write(tmpHeaderData);
                List<IndexRange> blocks = data.getDeletedBlocks();
                fileAccess.writeInt(blocks.size());
                for (IndexRange block : blocks) {
                    fileAccess.writeLong(block.from);
                    fileAccess.writeLong(block.to);
                    int hashExpected = Long.hashCode(block.from) ^ Long.hashCode(block.to);
                    fileAccess.writeInt(hashExpected);
                    fileAccess.writeByte(0);
                }
            }
            fileAccess.setLength(fileAccess.getFilePointer());
        }
        catch (IOException e) {
            throw new PersistenceException("Kann Datei mit gel\u00f6schten Containern nicht schreiben", e);
        }
        boolean existed = false;
        try {
            if (Files.exists(this._file, new LinkOption[0])) {
                Files.move(this._file, this._fileBackup, StandardCopyOption.REPLACE_EXISTING);
                existed = true;
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Kann bestehende Datei nicht umbenennen: " + String.valueOf(this._file) + " -> " + String.valueOf(this._fileBackup), e);
        }
        try {
            Files.move(this._fileTmp, this._file, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            try {
                Files.move(this._fileBackup, this._file, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e1) {
                e.addSuppressed(e1);
            }
            throw new PersistenceException("Fehler beim Umbenennen der neuen Datei zur Speicherung der gel\u00f6schten Container", e);
        }
        if (existed) {
            try {
                Files.delete(this._fileBackup);
            }
            catch (IOException e) {
                _debug.warning("Backup-Datei konnte nicht gel\u00f6scht werden: " + String.valueOf(this._fileBackup), (Throwable)e);
            }
        }
    }

    public void addDeletedContainer(BasicContainerFileHandle existingContainer) throws PersistenceException, SynchronizationFailedException {
        this.addDeletedContainer(existingContainer, existingContainer);
    }

    public void addDeletedContainer(ContainerManagementData header, DataSequence data) throws PersistenceException, SynchronizationFailedException {
        this._map.put(header.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID), new DeletedContainerData(header, data));
    }

    public void removeDeletedContainer(long containerID) {
        this._map.remove(containerID);
    }

    public DataIterator dataIterator(long containerId) throws PersistenceException {
        DeletedContainerData deletedContainerData = this._map.get(containerId);
        if (deletedContainerData == null) {
            throw new PersistenceException("Gel\u00f6schter Container nicht in _deleted.dat gefunden: " + containerId);
        }
        return deletedContainerData.iterator();
    }

    public ContainerManagementData headers(long containerId) {
        return this._map.get(containerId);
    }

    @Nullable
    public List<IndexRange> deletedBlocks(long containerId) {
        DeletedContainerData data = this._map.get(containerId);
        if (data == null) {
            return null;
        }
        return Collections.unmodifiableList(data.getDeletedBlocks());
    }

    public Set<Long> containers() {
        return this._map.keySet();
    }

    public Path getFile() {
        return this._file;
    }

    private static final class DeletedContainerData
    implements ContainerManagementData,
    DataSequence {
        private final List<IndexRange> _deletedBlocks = new ArrayList<IndexRange>();
        private final byte[] _data;
        private final ContainerDirectory _containerDir;

        public DeletedContainerData(byte[] tmpHeaderData, ContainerDirectory containerFileDir) {
            this._data = (byte[])tmpHeaderData.clone();
            this._containerDir = containerFileDir;
        }

        public DeletedContainerData(ContainerManagementData header, DataSequence dataSequence) throws PersistenceException, SynchronizationFailedException {
            this._containerDir = header.getLocation();
            this._data = new byte[ContainerManagementIndex.INDEX_CONTENT_DESCRIPTOR.getEntryLengthBytes()];
            for (ContainerManagementInformation information : ContainerManagementInformation.values()) {
                if (information.isNumeric()) {
                    long paramAsLong = header.getContainerHeaderParamAsLong(information);
                    ContainerManagementIndex.INDEX_CONTENT_DESCRIPTOR.getColumn(information).writeBytes(paramAsLong, this._data);
                    continue;
                }
                String paramAsString = header.getContainerHeaderParamAsString(information);
                ContainerManagementIndex.INDEX_CONTENT_DESCRIPTOR.getColumn(information).writeBytes(paramAsString, this._data);
            }
            try (DataIterator dataIter = dataSequence.iterator();){
                ContainerDataResult result = new ContainerDataResult();
                while (!dataIter.isEmpty()) {
                    long from;
                    dataIter.peek(result);
                    long last = from = result.getDataIndex();
                    while (!dataIter.isEmpty()) {
                        dataIter.peek(result);
                        long to = result.getDataIndex();
                        if (DeletedContainerData.isGap(last, to)) break;
                        if (!result.isPotDataGap()) {
                            last = to;
                        }
                        dataIter.remove();
                    }
                    this.addIndexRange(from, last);
                }
            }
        }

        private static boolean isGap(long start, long end) {
            return start != -1L && Util.dIdxNoModBits((long)end) - Util.dIdxNoModBits((long)start) > 1L;
        }

        @Override
        public DataIterator iterator() {
            return new DeletedFullIterator(this._deletedBlocks, this, this._containerDir.archiveDataKind());
        }

        public void addIndexRange(long from, long to) {
            this._deletedBlocks.add(new IndexRange(from, to));
        }

        public void serialize(byte[] tmpHeaderData) {
            System.arraycopy(this._data, 0, tmpHeaderData, 0, this._data.length);
        }

        public List<IndexRange> getDeletedBlocks() {
            return this._deletedBlocks;
        }

        @Override
        public String getContainerHeaderParamAsString(ContainerManagementInformation param) {
            return ContainerManagementIndex.INDEX_CONTENT_DESCRIPTOR.getColumn(param).readString(this._data);
        }

        @Override
        public boolean getContainerHeaderParamAsBoolean(ContainerManagementInformation param) {
            return "1".equals(this.getContainerHeaderParamAsString(param));
        }

        @Override
        public long getContainerHeaderParamAsLong(ContainerManagementInformation param) {
            return ContainerManagementIndex.INDEX_CONTENT_DESCRIPTOR.getColumn(param).readLong(this._data);
        }

        @Override
        public int getContainerHeaderParamAsInt(ContainerManagementInformation param) {
            return (int)this.getContainerHeaderParamAsLong(param);
        }

        @Override
        public ContainerDirectory getLocation() {
            return this._containerDir;
        }
    }

    public record IndexRange(long from, long to) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexRange that = (IndexRange)o;
            if (this.from != that.from) {
                return false;
            }
            return this.to == that.to;
        }

        @Override
        public int hashCode() {
            int result = (int)(this.from ^ this.from >>> 32);
            result = 31 * result + (int)(this.to ^ this.to >>> 32);
            return result;
        }
    }

    private static class DeletedFullIterator
    implements DataIterator {
        private final List<Long> _indexes = new ArrayList<Long>();
        int _idx;
        private final ContainerManagementData _handle;
        private final ArchiveDataKind _adk;

        public DeletedFullIterator(List<IndexRange> deletedBlocks, ContainerManagementData handle, ArchiveDataKind adk) {
            this._handle = handle;
            this._adk = adk;
            for (IndexRange deletedBlock : deletedBlocks) {
                long from = deletedBlock.from;
                long to = deletedBlock.to;
                for (long l = from; l <= to; l += 4L) {
                    this._indexes.add(l);
                }
            }
        }

        @Override
        public void peek(ContainerDataResult result) throws PersistenceException {
            if (this._idx >= this._indexes.size()) {
                throw new NoSuchElementException();
            }
            result.setContainerID(this._handle.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID));
            result.setDataIndex(this._indexes.get(this._idx));
            result.setDataTime(0L);
            result.setArchiveTime(0L);
            result.setDataKind(this._adk);
            result.setData(null);
            result.setCompressed(false);
            result.setDataSize(0);
            result.setDataUncompressedSize(0);
            result.setDataState(DataState.DATA);
        }

        @Override
        public ContainerDataResult peekNext() {
            return null;
        }

        @Override
        public long peekDataIndex() {
            if (this._idx >= this._indexes.size()) {
                throw new NoSuchElementException();
            }
            return this._indexes.get(this._idx);
        }

        @Override
        public long peekDataTime() {
            return 0L;
        }

        @Override
        public long peekArchiveTime() {
            return 0L;
        }

        @Override
        public void remove() {
            if (this._idx >= this._indexes.size()) {
                throw new NoSuchElementException();
            }
            ++this._idx;
        }

        @Override
        public boolean isEmpty() {
            return this._idx >= this._indexes.size();
        }

        @Override
        public void close() {
        }

        @Override
        @NotNull
        public ContainerManagementData getContainerManagementData() {
            return this._handle;
        }
    }
}

