/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.util.NoSuchElementException;

public final class DeletedMinMaxIterator
implements DataIterator,
ContainerManagementData {
    private final ContainerHeaders _headers;
    private int _position;
    private final ArchiveDataKind _adk;
    private final IdDataIdentification _dataIdentification;

    public DeletedMinMaxIterator(ContainerHeaders headers, ArchiveDataKind adk, IdDataIdentification dataIdentification) {
        this._headers = headers;
        this._adk = adk;
        this._dataIdentification = dataIdentification;
    }

    @Override
    public void peek(ContainerDataResult result) {
        switch (this._position) {
            case 0: {
                result.setContainerID(this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID));
                result.setDataIndex(this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MIN));
                result.setDataTime(this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MIN));
                result.setArchiveTime(this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MIN));
                result.setDataKind(this._adk);
                result.setData(null);
                result.setCompressed(false);
                result.setDataSize(0);
                result.setDataUncompressedSize(0);
                result.setDataState(DataState.DATA);
                break;
            }
            case 1: {
                result.setContainerID(this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID));
                result.setDataIndex(this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX));
                result.setDataTime(this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX));
                result.setArchiveTime(this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX));
                result.setDataKind(this._adk);
                result.setData(null);
                result.setCompressed(false);
                result.setDataSize(0);
                result.setDataUncompressedSize(0);
                result.setDataState(DataState.DATA);
                break;
            }
            default: {
                throw new NoSuchElementException();
            }
        }
    }

    @Override
    public ContainerDataResult peekNext() {
        return null;
    }

    @Override
    public long peekDataIndex() {
        return switch (this._position) {
            case 0 -> this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MIN);
            case 1 -> this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX);
            default -> throw new NoSuchElementException();
        };
    }

    @Override
    public long peekDataTime() {
        return switch (this._position) {
            case 0 -> this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MIN);
            case 1 -> this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX);
            default -> throw new NoSuchElementException();
        };
    }

    @Override
    public long peekArchiveTime() {
        return switch (this._position) {
            case 0 -> this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MIN);
            case 1 -> this.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX);
            default -> throw new NoSuchElementException();
        };
    }

    @Override
    public void remove() {
        if (this._position > 1) {
            throw new NoSuchElementException();
        }
        ++this._position;
    }

    @Override
    public boolean isEmpty() {
        return this._position > 1;
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public ContainerManagementData getContainerManagementData() {
        return this;
    }

    @Override
    public String getContainerHeaderParamAsString(ContainerManagementInformation param) {
        return this._headers.getContainerHeaderParamAsString(param);
    }

    @Override
    public boolean getContainerHeaderParamAsBoolean(ContainerManagementInformation param) {
        return this._headers.getContainerHeaderParamAsBoolean(param);
    }

    @Override
    public long getContainerHeaderParamAsLong(ContainerManagementInformation param) {
        return this._headers.getContainerHeaderParamAsLong(param);
    }

    @Override
    public int getContainerHeaderParamAsInt(ContainerManagementInformation param) {
        return this._headers.getContainerHeaderParamAsInt(param);
    }

    @Override
    public IdContainerFileDir getLocation() {
        return new IdContainerFileDir(this._dataIdentification, this._adk);
    }
}

