/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import java.util.Objects;

public final class IdContainerFileDir
implements ContainerDirectory {
    private final IdDataIdentification idDataIdentification;
    private final ArchiveDataKind archiveDataKind;

    public IdContainerFileDir(long objectId, long atgId, long aspectId, int simVariant, ArchiveDataKind archiveDataKind) {
        this.idDataIdentification = new IdDataIdentification(objectId, atgId, aspectId, simVariant);
        this.archiveDataKind = Objects.requireNonNull(archiveDataKind);
    }

    public IdContainerFileDir(IdDataIdentification dataIdentification, ArchiveDataKind archiveDataKind) {
        this.idDataIdentification = Objects.requireNonNull(dataIdentification);
        this.archiveDataKind = Objects.requireNonNull(archiveDataKind);
    }

    public static IdContainerFileDir of(ContainerDirectory containerDirectory) {
        if (containerDirectory instanceof IdContainerFileDir) {
            IdContainerFileDir dir = (IdContainerFileDir)containerDirectory;
            return dir;
        }
        return new IdContainerFileDir(containerDirectory.dataIdentification(), containerDirectory.archiveDataKind());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdContainerFileDir that = (IdContainerFileDir)o;
        if (!this.idDataIdentification.equals(that.idDataIdentification)) {
            return false;
        }
        return this.archiveDataKind.equals((Object)that.archiveDataKind);
    }

    public int hashCode() {
        int result = this.idDataIdentification.hashCode();
        result = 31 * result + this.archiveDataKind.hashCode();
        return result;
    }

    @Override
    public ArchiveDataKind archiveDataKind() {
        return this.archiveDataKind;
    }

    @Override
    public IdDataIdentification dataIdentification() {
        return this.idDataIdentification;
    }

    public String toString() {
        return "obj: " + this.getObjectId() + " atg: " + this.getAtgId() + " asp: " + this.getAspectId() + " sv: " + this.getSimVariant() + " adk: " + String.valueOf(this.archiveDataKind);
    }
}

