/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.KeyValParam;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import java.util.Properties;

public abstract class KeyValProps {
    protected final Properties properties = new Properties();
    public static final int BYTES4_STR_LEN = 10;
    public static final int BYTES5_STR_LEN = 13;
    public static final int BYTES6_STR_LEN = 15;
    public static final int BYTES8_STR_LEN = 19;
    public static final int BOOL_STR_LEN = 1;
    protected static final long BYTE4_MAXVAL = Integer.MAX_VALUE;
    protected static final long BYTE5_MAXVAL = 0xFFFFFFFFFFL;
    protected static final long BYTE6_MAXVAL = 0xFFFFFFFFFFFFL;
    protected static final long BYTE8_MAXVAL = Long.MAX_VALUE;
    protected static final String TRUE = "1";
    protected static final String FALSE = "0";
    protected static final String CH_DELIM = "\n";

    public void clear() {
        this.properties.clear();
    }

    public void setVal(KeyValParam chp, boolean val) throws PersistenceException {
        String txtVal = val ? TRUE : FALSE;
        chp.checkVal(txtVal);
        this.properties.setProperty(chp.getKey(), chp.formatVal(txtVal));
    }

    public void setVal(KeyValParam chp, long val) throws PersistenceException {
        chp.checkVal(String.valueOf(val));
        this.properties.setProperty(chp.getKey(), chp.formatVal(val));
    }

    public void setVal(KeyValParam chp, String val) throws PersistenceException {
        chp.checkVal(val);
        this.properties.setProperty(chp.getKey(), chp.formatVal(val));
    }

    public void setDefaultVal(KeyValParam chp) {
        this.properties.setProperty(chp.getKey(), chp.getDefaultVal());
    }

    public String getValAsString(KeyValParam chp) {
        return this.properties.getProperty(chp.getKey());
    }

    public Long getValAsLong(KeyValParam chp) throws PersistenceException {
        if (!chp.isNumeric()) {
            throw new PersistenceException("ContainerHeaderParam ist kein Zahlwert: " + String.valueOf(chp) + " " + String.valueOf(this));
        }
        String val = this.properties.getProperty(chp.getKey());
        return val == null ? null : Long.valueOf(val);
    }

    public Boolean getValAsBool(KeyValParam chp) throws PersistenceException {
        if (chp.isNumeric()) {
            throw new PersistenceException("Parameter ist numerisch und nicht als Bool interpretierbar: " + String.valueOf(chp) + " " + String.valueOf(this));
        }
        String val = this.properties.getProperty(chp.getKey());
        return val == null ? null : Boolean.valueOf(val.equals(TRUE));
    }

    public Integer getValAsInt(KeyValParam chp) throws PersistenceException {
        Long l = this.getValAsLong(chp);
        if (l > Integer.MAX_VALUE) {
            throw new PersistenceException("Parameter ist nicht als Int (4 Bytes) interpretierbar: '" + l + "' " + String.valueOf(chp) + " " + String.valueOf(this));
        }
        return l.intValue();
    }
}

