/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.tasks.AbstractTask;
import de.bsvrz.ars.ars.mgmt.tasks.base.TaskManager;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.DataIdentificationManager;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.ars.ars.persistence.RebuildMode;
import de.bsvrz.ars.ars.persistence.RebuildResult;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndexImpl;
import de.bsvrz.ars.ars.persistence.index.ContainerManagementIndex;
import de.bsvrz.ars.ars.persistence.index.DataIndexIndexImpl;
import de.bsvrz.ars.ars.persistence.index.DataTimeIndexImpl;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.walk.DataIdentificationDirWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class RestorePersDirTsk
extends AbstractTask {
    public static volatile long test_totalDID;
    public static volatile long test_badDID;
    public static volatile long test_goodDID;
    private final RestoreWorker restoreWorker;

    public RestorePersDirTsk(PersistenceManager persistenceManager, String taskName, RebuildMode rebuildMode) {
        super(persistenceManager);
        this.restoreWorker = new RestoreWorker(taskName, rebuildMode, this.getPersistenceManager(), persistenceManager.getNumCheckPersistenceThreads());
        this.start();
    }

    @Override
    public void execute() {
        List<? extends PersistenceDirectory> directories = this.getPersistenceManager().getPersistenceDirectories(0);
        if (!directories.isEmpty()) {
            this.restoreWorker.doRestore(directories.get(directories.size() - 1));
        }
        super.execute();
    }

    @Override
    public void terminateTask() {
        super.terminateTask();
        this.restoreWorker.shouldTerminate = true;
    }

    public RestoreWorker getWorker() {
        return this.restoreWorker;
    }

    public static class RestoreWorker {
        private final AtomicLong maxArchiveTime = new AtomicLong();
        private final AtomicLong maxContID = new AtomicLong();
        private final AtomicLong totalDID = new AtomicLong();
        private final AtomicLong badDID = new AtomicLong();
        private final AtomicLong goodDID = new AtomicLong();
        private final AtomicLong _errorCount = new AtomicLong();
        private final AtomicLong containerRead = new AtomicLong();
        private final AtomicLong containerIgnored = new AtomicLong();
        private final AtomicLong indexesDeleted = new AtomicLong();
        private final String taskName;
        private final RebuildMode rebuildMode;
        private final int numThreads;
        private final DataIdentificationManager dataIdentificationManager;
        private volatile boolean shouldTerminate;

        public RestoreWorker(String taskName, RebuildMode rebuildMode, DataIdentificationManager dataIdentificationManager, int numCheckPersistenceThreads) {
            this.taskName = taskName;
            this.rebuildMode = rebuildMode;
            this.dataIdentificationManager = dataIdentificationManager;
            this.numThreads = numCheckPersistenceThreads;
        }

        private void cleanUpTask() {
            test_totalDID = this.getTotalDID();
            test_badDID = this.getBadDID();
            test_goodDID = this.getGoodDID();
        }

        public long getMaxArchiveTime() {
            return this.maxArchiveTime.get();
        }

        public long getMaxContID() {
            return this.maxContID.get();
        }

        public long getTotalDID() {
            return this.totalDID.get();
        }

        public long getBadDID() {
            return this.badDID.get();
        }

        public long getGoodDID() {
            return this.goodDID.get();
        }

        public long getContainerRead() {
            return this.containerRead.get();
        }

        public long getContainerIgnored() {
            return this.containerIgnored.get();
        }

        public long getIndexesDeleted() {
            return this.indexesDeleted.get();
        }

        public long getErrorCount() {
            return this._errorCount.get();
        }

        public boolean success() {
            return this.getBadDID() == 0L && this.getErrorCount() == 0L;
        }

        public void doRestore(PersistenceDirectory persistenceDirectory) {
            try {
                if (persistenceDirectory == null) {
                    return;
                }
                DataIdentificationDirWalk containerDirWalk = DataIdentificationDirWalk.allDirectories(persistenceDirectory);
                containerDirWalk.setStatusPrinter(new StatusPrinter(){

                    @Override
                    public String getStatusMessage(String actionName, Duration runtime, StatusPrinter.ApproximationType approximationType, long allContainerDirs, long visitedContainerDirs, long visitedContainerFiles) {
                        long goodDirs = this.getGoodDID();
                        long badDirs = this.getBadDID();
                        long sum = goodDirs + badDirs;
                        return super.getStatusMessage(actionName, runtime, approximationType, allContainerDirs, visitedContainerDirs, visitedContainerFiles) + "\n" + this.getProgressMessage(goodDirs, badDirs, sum);
                    }

                    @Override
                    public String getSuccessMessage(String actionName, Duration runtime, long visitedContainerDirs, long visitedContainerFiles) {
                        long goodDirs = this.getGoodDID();
                        long badDirs = this.getBadDID();
                        long sum = goodDirs + badDirs;
                        return super.getSuccessMessage(actionName, runtime, visitedContainerDirs, visitedContainerFiles) + "\n" + this.getProgressMessage(goodDirs, badDirs, sum);
                    }
                });
                TaskManager.runExclusively(this.taskName, tpi -> {
                    containerDirWalk.setPublisherTask(tpi);
                    this.doWalk(containerDirWalk, persistenceDirectory);
                });
            }
            catch (PersistenceException e) {
                this._errorCount.getAndIncrement();
                _debug.error(this.taskName + ": Unbehandelter Fehler in RestorePersDirTsk", (Throwable)e);
            }
            finally {
                this.cleanUpTask();
            }
        }

        private void doWalk(DataIdentificationDirWalk containerDirWalk, PersistenceDirectory directory) throws PersistenceException {
            containerDirWalk.execute(this.taskName, this.numThreads, (dataIdentificationDir, standardContainerDirWalk) -> {
                Path didDir = dataIdentificationDir.getDataIdentificationDir();
                IdDataIdentification dataIdentification = dataIdentificationDir.getDataIdentification();
                if (this.shouldTerminate) {
                    containerDirWalk.terminate();
                }
                try (SyncKey<IdDataIdentification> lock = this.dataIdentificationManager.lockIndex(dataIdentification);){
                    for (LockedContainerDirectory lockedContainerDirectory : dataIdentificationDir.getContainerDirectories(lock)) {
                        try {
                            IndexResult<ContainerManagementInformation> headers;
                            this.totalDID.getAndIncrement();
                            Path changedFlagFile = directory.getPath(lockedContainerDirectory).resolve("_rebuildIndex.flag");
                            boolean needsRebuild = this.isNeedsRebuild(directory, lockedContainerDirectory, changedFlagFile);
                            if (needsRebuild || this.rebuildMode.isFull()) {
                                long t2 = Util.startTimer();
                                RebuildResult result = new RebuildResult();
                                if (this.rebuildMode.isDelete()) {
                                    directory.deleteIndexes(lockedContainerDirectory, result);
                                } else {
                                    directory.rebuildIndexes(lockedContainerDirectory, result);
                                }
                                this.containerRead.addAndGet(result.getContainerRead());
                                this.containerIgnored.addAndGet(result.getContainerIgnored());
                                this.indexesDeleted.addAndGet(result.getIndexesDeleted());
                                try {
                                    Files.deleteIfExists(changedFlagFile);
                                }
                                catch (IOException e) {
                                    throw new IOException(this.taskName + ": '_rebuildIndex.flag' im Verzeichnis '" + String.valueOf(didDir) + "' konnte nicht geloescht werden.", e);
                                }
                                this.goodDID.getAndIncrement();
                                _debug.fine(this.taskName + ": Indexe in " + String.valueOf(didDir) + " erfolgreich neu aufgebaut (" + Util.stopTimer((long)t2) + ").");
                            }
                            if ((headers = directory.getContainerHeaders(lockedContainerDirectory)).isEmpty()) continue;
                            long contId = headers.getMax(ContainerManagementInformation.CHP_CONT_ID);
                            this.maxContID.updateAndGet(old -> Math.max(old, contId));
                            if (!(directory instanceof ActivePersistenceDirectory)) continue;
                            ActivePersistenceDirectory activePersistenceDirectory = (ActivePersistenceDirectory)directory;
                            long aTime = activePersistenceDirectory.maxATime(lockedContainerDirectory);
                            this.maxArchiveTime.updateAndGet(old -> Math.max(old, aTime));
                        }
                        catch (Exception e) {
                            this.badDID.getAndIncrement();
                            _debug.error(this.taskName + ": Index der Datenidentifikation '" + String.valueOf(didDir) + "' konnte nicht neu angelegt werden", (Throwable)e);
                        }
                    }
                }
            });
        }

        private boolean isNeedsRebuild(PersistenceDirectory directory, LockedContainerDirectory containerDirectory, Path changedFlagFile) {
            if (Files.exists(changedFlagFile, new LinkOption[0])) {
                return true;
            }
            if (this.rebuildMode.isDelete()) {
                return false;
            }
            Path path = directory.getPath(containerDirectory);
            if (!Files.exists(path.resolve(ContainerManagementIndex.IDX_FILENAME), new LinkOption[0])) {
                return true;
            }
            if (!Files.exists(path.resolve(ArchiveTimeIndexImpl.IDX_FILENAME), new LinkOption[0])) {
                return true;
            }
            if (!Files.exists(path.resolve(DataTimeIndexImpl.IDX_FILENAME), new LinkOption[0])) {
                return true;
            }
            return containerDirectory.archiveDataKind().isDelayed() && !Files.exists(path.resolve(DataIndexIndexImpl.IDX_FILENAME), new LinkOption[0]);
        }

        @NotNull
        private String getProgressMessage(long goodDirs, long badDirs, long sum) {
            String result;
            if (sum != 0L) {
                StringBuilder sb = new StringBuilder().append("bei ").append(sum).append(" Index-Neuaufbau notwendig, davon ").append(goodDirs).append(" erfolgreich und ").append(badDirs).append(" nicht erfolgreich.").append("\n");
                if (this.getContainerRead() != 0L) {
                    sb.append(String.format("%8d Container erfolgreich gelesen.\n", this.getContainerRead()));
                }
                if (this.getContainerIgnored() != 0L) {
                    sb.append(String.format("%8d defekte Container ignoriert.\n", this.getContainerIgnored()));
                }
                if (this.getIndexesDeleted() != 0L) {
                    sb.append(String.format("%8d inkonsistente Indexdateien gel\u00f6scht.\n", this.getIndexesDeleted()));
                }
                result = sb.toString();
            } else {
                result = "kein Index-Neuaufbau notwendig.";
            }
            return result;
        }
    }
}

