/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence;

import de.bsvrz.ars.ars.persistence.ContainerDataIterator;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerHdr;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.KeyValParam;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.iter.DataSequence;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.nio.file.Path;

public class StandaloneContainerFileHandle
implements AutoCloseable,
ContainerManagementData,
DataSequence {
    final ContainerFile _containerFile = new ContainerFile();

    protected StandaloneContainerFileHandle() {
    }

    public StandaloneContainerFileHandle(Path containerFile) throws PersistenceException {
        this._containerFile.accessContainerReadOnly(containerFile);
    }

    public final ContainerFile getContainerFile() {
        return this._containerFile;
    }

    public void leaveContainer() {
        this.getContainerFile().leaveContainer();
    }

    public String getContainerHeaderParamAsString(KeyValParam param) throws PersistenceException {
        return this.getContainerFile().getContHdrParamAsString(param);
    }

    public ArchiveDataKind getContainerHeaderParamAsArchiveDataKind(KeyValParam param) throws PersistenceException {
        return this.getContainerFile().getContHdrParamAsArchiveDataKind(param);
    }

    public boolean getContainerHeaderParamAsBoolean(KeyValParam param) throws PersistenceException {
        return this.getContainerFile().getContHdrParamAsBool(param);
    }

    public long getContainerHeaderParamAsLong(KeyValParam param) throws PersistenceException {
        return this.getContainerFile().getContHdrParamAsLong(param);
    }

    public int getContainerHeaderParamAsInt(KeyValParam param) throws PersistenceException {
        return this.getContainerFile().getContHdrParamAsInt(param);
    }

    @Override
    public String getContainerHeaderParamAsString(ContainerManagementInformation param) throws PersistenceException {
        return this.getContainerHeaderParamAsString(param.delegate());
    }

    @Override
    public boolean getContainerHeaderParamAsBoolean(ContainerManagementInformation param) throws PersistenceException {
        return this.getContainerHeaderParamAsBoolean(param.delegate());
    }

    @Override
    public long getContainerHeaderParamAsLong(ContainerManagementInformation param) throws PersistenceException {
        return this.getContainerHeaderParamAsLong(param.delegate());
    }

    @Override
    public int getContainerHeaderParamAsInt(ContainerManagementInformation param) throws PersistenceException {
        return this.getContainerHeaderParamAsInt(param.delegate());
    }

    @Override
    public ContainerDirectory getLocation() throws PersistenceException {
        return this.getLocationFromHeader();
    }

    public IdContainerFileDir getLocationFromHeader() throws PersistenceException {
        this.ensureHeaderRead();
        return new IdContainerFileDir(this.getContainerHeaderParamAsLong(ContainerHdr.CHP_OBJ_ID), this.getContainerHeaderParamAsLong(ContainerHdr.CHP_ATG_ID), this.getContainerHeaderParamAsLong(ContainerHdr.CHP_ASP_ID), this.getContainerHeaderParamAsInt(ContainerHdr.CHP_SIM_VAR), this.getContainerHeaderParamAsArchiveDataKind(ContainerHdr.CHP_DATA_KIND));
    }

    @Override
    public void close() {
        this.leaveContainer();
    }

    public void readContainerHeader() throws PersistenceException {
        this.getContainerFile().readContainerHeader();
    }

    @Override
    @NotNull
    public ContainerDataIterator iterator() throws PersistenceException {
        this.ensureHeaderRead();
        return new ContainerDataIterator(this);
    }

    public long getContainerId() {
        return this._containerFile.getContainerId();
    }

    public boolean isContainerClosed() throws PersistenceException {
        return this.isClosedInternal();
    }

    public boolean isClosedInternal() throws PersistenceException {
        return this.getContainerFile().isContainerClosed();
    }

    public Path getFile() {
        return this._containerFile.getContFile();
    }

    public String toString() {
        return this.getFile().toString();
    }

    public void ensureHeaderRead() throws PersistenceException {
        this._containerFile.ensureHeaderRead();
    }
}

