/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories;

import com.google.common.collect.ImmutableMap;
import de.bsvrz.ars.ars.mgmt.datatree.IndexTree;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.BasicContainerFileHandle;
import de.bsvrz.ars.ars.persistence.ContainerDataIterator;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerFileHandle;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.DataIdentificationManager;
import de.bsvrz.ars.ars.persistence.DeletedContainerFile;
import de.bsvrz.ars.ars.persistence.DeletedMinMaxIterator;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.RebuildResult;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.ReadonlyPersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.cache.DataRange;
import de.bsvrz.ars.ars.persistence.directories.cache.NoData;
import de.bsvrz.ars.ars.persistence.directories.cache.SimpleDataRange;
import de.bsvrz.ars.ars.persistence.index.ArchiveTimeIndex;
import de.bsvrz.ars.ars.persistence.index.ContainerManagementIndex;
import de.bsvrz.ars.ars.persistence.index.DataIndexIndex;
import de.bsvrz.ars.ars.persistence.index.DataTimeIndex;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.backend.management.BaseIndex;
import de.bsvrz.ars.ars.persistence.index.backend.management.LongRange;
import de.bsvrz.ars.ars.persistence.index.result.AggregateIndexResult;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.ars.ars.persistence.sequence.AllDataSpecification;
import de.bsvrz.ars.ars.persistence.sequence.ArchiveTimeSequenceSpecification;
import de.bsvrz.ars.ars.persistence.sequence.DataIndexSequenceSpecification;
import de.bsvrz.ars.ars.persistence.sequence.SequenceSpecification;
import de.bsvrz.ars.ars.persistence.walk.internal.CountEstimator;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Contract;

public abstract sealed class PersistenceDirectory
implements CountEstimator
permits ActivePersistenceDirectory, ReadonlyPersistenceDirectory {
    protected static final Debug debug = Debug.getLogger();
    protected final IndexTree indexTree;
    protected final ConcurrentSkipListSet<IdContainerFileDir> largeDataIdentifications = new ConcurrentSkipListSet();
    @NotNull
    private final DataIdentificationManager dataIdentificationManager;
    private final PersistenceDirectoryLayoutInstance layoutInstance;
    private final AtomicLong lastCount = new AtomicLong();

    public PersistenceDirectory(@NotNull DataIdentificationManager dataIdentificationManager, @NotNull PersistenceDirectoryLayoutInstance layoutInstance) {
        this.dataIdentificationManager = dataIdentificationManager;
        Path basePath = layoutInstance.basePath();
        boolean exists = Files.isDirectory(basePath, new LinkOption[0]);
        if (!exists) {
            debug.info("Persistenzverzeichnis '" + String.valueOf(basePath) + "' existiert nicht, wird neu angelegt.");
            try {
                Files.createDirectories(basePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                debug.warning("Kann Verzeichnis nicht anlegen: " + String.valueOf(basePath), (Throwable)e);
            }
        }
        this.indexTree = new IndexTree(dataIdentificationManager.getIndexCacheMaxSize(), this);
        this.layoutInstance = layoutInstance;
    }

    private static ContainerHeaders getHeaders(ContainerManagementIndex contHdrIdx, long containerID, ContainerDirectory location) throws IndexException {
        Map<ContainerManagementInformation, LongRange> query = Map.of(ContainerManagementInformation.CHP_CONT_ID, new LongRange(containerID, containerID));
        IndexResult<ContainerManagementInformation> result = contHdrIdx.query(query);
        if (!result.isEmpty() && result.get(0, ContainerManagementInformation.CHP_CONT_ID) == containerID) {
            return new ContainerHeaders(result, 0, location);
        }
        throw new IllegalArgumentException("Container " + containerID + " ist nicht im Index enthalten.");
    }

    @Nullable
    public ContainerHeaders getLastContainerHeaders(LockedContainerDirectory containerDirectory) throws IndexException {
        Optional<? extends ContainerManagementIndex> index = this.getIndexTree().getContainerManagementIndex(containerDirectory);
        if (index.isEmpty() || index.get().numEntries() == 0L) {
            return null;
        }
        long contId = index.get().getLast(ContainerManagementInformation.CHP_CONT_ID);
        return this.getContainerHeaders(containerDirectory, contId);
    }

    private static long getMinimumDataIndex(BasicContainerFileHandle containerFileHandle) throws PersistenceException {
        int numDs = containerFileHandle.getContainerHeaderParamAsInt(ContainerManagementInformation.CHP_ANZ_DS);
        if (numDs == -1) {
            try (ContainerDataIterator iterator = containerFileHandle.iterator();){
                long l = iterator.peekDataIndex();
                return l;
            }
        }
        return containerFileHandle.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MIN);
    }

    protected void executeOnContainer(Path contFile, ContainerCall action) throws PersistenceException, SynchronizationFailedException {
        try {
            action.call();
        }
        catch (PersistenceException e) {
            if (this.dataIdentificationManager.shouldDeleteBrokenContainers()) {
                this.renameContainerFile(contFile);
            } else {
                debug.error("Container " + String.valueOf(contFile) + " konnte nicht gelesen werden. Aufrufargument \"-defekteDateienVerschieben\" setzen, um defekte Dateien automatisch zu entfernen.");
            }
            throw new PersistenceException(e);
        }
    }

    protected void renameContainerFile(Path contFile) throws PersistenceException {
        Path target = contFile.resolveSibling(String.valueOf(contFile.getFileName()) + ".defect");
        try {
            Files.move(contFile, target, new CopyOption[0]);
            debug.fine("Container " + String.valueOf(contFile) + " konnte nicht gelesen werden und wurde in " + String.valueOf(target.getFileName()) + " umbenannt.");
        }
        catch (IOException e1) {
            throw new PersistenceException("Umbenennen der defekten Containerdatei fehlgeschlagen: " + String.valueOf(contFile), e1);
        }
    }

    public ContainerHeaders getContainerHeaders(LockedContainerDirectory containerDirectory, long containerID) throws IndexException {
        Optional<? extends ContainerManagementIndex> cmi = this.getIndexTree().getContainerManagementIndex(containerDirectory);
        if (cmi.isEmpty()) {
            throw new IllegalArgumentException("Container " + containerID + " ist nicht im Index enthalten.");
        }
        return PersistenceDirectory.getHeaders(cmi.get(), containerID, containerDirectory);
    }

    public IndexResult<ContainerManagementInformation> getContainerHeaders(LockedContainerDirectory containerDirectory) throws IndexException {
        Optional<? extends ContainerManagementIndex> containerManagementIndex = this.getIndexTree().getContainerManagementIndex(containerDirectory);
        if (containerManagementIndex.isEmpty()) {
            return new AggregateIndexResult<ContainerManagementInformation>();
        }
        return containerManagementIndex.get().query();
    }

    @NotNull
    public ContainerFileHandle accessContainer(LockedContainerDirectory containerDirectory, long containerId) throws PersistenceException {
        assert (containerDirectory.lock().isValid());
        return new ContainerFileHandle(containerDirectory, containerId, false, this.layoutInstance);
    }

    public final Path getBasePath() {
        return this.layoutInstance.basePath();
    }

    public static Path createDirectoriesIfAbsent(Path path) throws PersistenceException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new PersistenceException("Persistenzverzeichnis '" + String.valueOf(path.toAbsolutePath()) + "' konnte nicht angelegt werden.", e);
        }
        return path;
    }

    public final void rebuildStandardIndex(ContainerManagementIndex managementIndex, BaseIndex<IndexValues> index, LockedContainerDirectory containerDirectory) throws IndexException {
        debug.fine("Baue Index neu auf", (Object)index.toString());
        IndexResult<ContainerManagementInformation> result = managementIndex.query();
        for (int i = 0; i < result.size(); ++i) {
            int num = result.getSignedInt(i, ContainerManagementInformation.CHP_ANZ_DS);
            long contId = result.get(i, ContainerManagementInformation.CHP_CONT_ID);
            index.setInsertValue(IndexValues.ContainerId, contId);
            if (num == -1) {
                this.handleUnclosedContainer(managementIndex, containerDirectory, contId, index);
            } else {
                index.setInsertValue(IndexValues.DataIndexMin, result.get(i, ContainerManagementInformation.CHP_DATA_IDX_MIN));
                index.setInsertValue(IndexValues.DataIndexMax, result.get(i, ContainerManagementInformation.CHP_DATA_IDX_MAX));
                index.setInsertValue(IndexValues.DataTimeMin, result.get(i, ContainerManagementInformation.CHP_DATA_TIME_MIN));
                index.setInsertValue(IndexValues.DataTimeMax, result.get(i, ContainerManagementInformation.CHP_DATA_TIME_MAX));
                index.setInsertValue(IndexValues.ArchiveTimeMin, result.get(i, ContainerManagementInformation.CHP_ARC_TIME_MIN));
                index.setInsertValue(IndexValues.ArchiveTimeMax, result.get(i, ContainerManagementInformation.CHP_ARC_TIME_MAX));
            }
            index.insert();
        }
    }

    protected void handleUnclosedContainer(ContainerManagementIndex managementIndex, LockedContainerDirectory containerDirectory, long contId, BaseIndex<IndexValues> index) throws IndexException {
        throw new IndexException("Offener Container in abgeschlossenem Archivdatenverzeichnis", managementIndex.getFile());
    }

    public void rebuildContainerHeaderIndex(IdContainerFileDir containerFileDir, ContainerManagementIndex containerHeaderIndex, @Nullable RebuildResult rebuildResult) throws IndexException {
        debug.fine("Baue Verwaltungsdatenindex neu auf", (Object)containerHeaderIndex);
        Path dir = this.getPath(containerFileDir);
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Duration nextWarnTimeLimit = Duration.ofMinutes(1L);
        Instant startTime = Instant.now();
        try {
            HashMap<Long, Long> containerIndexToMinDataIndex = new HashMap<Long, Long>();
            DeletedContainerFile deletedContainerFile = new DeletedContainerFile(containerFileDir, this);
            if (deletedContainerFile.exists()) {
                try {
                    deletedContainerFile.read();
                }
                catch (PersistenceException e) {
                    debug.warning("Fehler beim Einlesen der Datei, die gel\u00f6schte Container enth\u00e4lt: " + String.valueOf(deletedContainerFile.getFile()) + ". Ung\u00fcltige Eintr\u00e4ge werden ignoriert.", (Throwable)e);
                }
                for (long containerId : deletedContainerFile.containers()) {
                    try {
                        ContainerManagementData headers = deletedContainerFile.headers(containerId);
                        ActivePersistenceDirectory.updateContainerIndex(headers, containerHeaderIndex);
                        containerIndexToMinDataIndex.put(containerId, headers.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MIN));
                    }
                    catch (PersistenceException e) {
                        throw new IndexException("Fehler beim Indizieren der Daten eines gel\u00f6schten Containers (" + containerId + ")", deletedContainerFile.getFile(), e);
                    }
                }
            }
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir);){
                for (Path path : paths) {
                    Duration durationOfRestore = Duration.between(startTime, Instant.now());
                    if (durationOfRestore.compareTo(nextWarnTimeLimit) > 0) {
                        try {
                            nextWarnTimeLimit = nextWarnTimeLimit.multipliedBy(2L);
                        }
                        catch (ArithmeticException arithmeticException) {
                            // empty catch block
                        }
                        this.warnAboutSlowRestore(containerFileDir, containerHeaderIndex.numEntries(), durationOfRestore);
                    }
                    if (!ContainerFile.isContainerFile(path)) continue;
                    try {
                        this.executeOnContainer(path, () -> {
                            try (BasicContainerFileHandle handle = new BasicContainerFileHandle(path, containerFileDir);){
                                handle.readContainerHeader();
                                ActivePersistenceDirectory.updateContainerIndex(handle, containerHeaderIndex);
                                if (rebuildResult != null) {
                                    ++rebuildResult.containerRead;
                                }
                                containerIndexToMinDataIndex.put(handle.getContainerId(), PersistenceDirectory.getMinimumDataIndex(handle));
                            }
                        });
                    }
                    catch (PersistenceException e) {
                        debug.warning("Container " + String.valueOf(path) + " konnte nicht gelesen werden und wird ignoriert.");
                    }
                }
            }
            HashSet<Long> knownMinDataIndexes = new HashSet<Long>((int)containerHeaderIndex.numEntries());
            IndexResult<ContainerManagementInformation> contents = containerHeaderIndex.query();
            for (int i = 0; i < contents.size(); ++i) {
                if (!this.hasError(contents, i, knownMinDataIndexes, containerIndexToMinDataIndex, !containerFileDir.archiveDataKind().isRequested())) continue;
                long containerId = contents.get(i, ContainerManagementInformation.CHP_CONT_ID);
                Path contFile = this.getPath(containerFileDir).resolve(ContainerFile.getContainerFileName(containerId));
                debug.fine("Container \"" + String.valueOf(contFile) + "\" enth\u00e4lt inkonsistente Daten und wird ignoriert.");
                if (this.dataIdentificationManager.shouldDeleteBrokenContainers()) {
                    this.renameContainerFile(contFile);
                }
                if (rebuildResult != null) {
                    ++rebuildResult.containerIgnored;
                }
                containerHeaderIndex.removeAll(ImmutableMap.of((Object)((Object)ContainerManagementInformation.CHP_CONT_ID), (Object)new LongRange(containerId, containerId)));
            }
        }
        catch (Exception e) {
            throw new IndexException("IO-Fehler beim Erstellen des Verwaltungsdaten-Index", containerHeaderIndex.getFile(), e);
        }
    }

    public boolean hasError(IndexResult<ContainerManagementInformation> contents, int i, HashSet<Long> knownMinDataIndexes, Map<Long, Long> contIdToMinDataIndex, boolean checkIndexMonotonic) {
        long prevContId;
        Long prevDataIndexMinValue;
        if (i != contents.size() - 1 && contents.getSignedInt(i, ContainerManagementInformation.CHP_ANZ_DS) == -1) {
            return true;
        }
        long myContId = contents.get(i, ContainerManagementInformation.CHP_CONT_ID);
        Long dataIndexMinValue = contIdToMinDataIndex.get(myContId);
        if (dataIndexMinValue == null) {
            return true;
        }
        if (checkIndexMonotonic && i > 0 && (prevDataIndexMinValue = contIdToMinDataIndex.get(prevContId = contents.get(i - 1, ContainerManagementInformation.CHP_CONT_ID))) > 0L && dataIndexMinValue <= prevDataIndexMinValue) {
            return true;
        }
        return !knownMinDataIndexes.add(dataIndexMinValue);
    }

    public void warnAboutSlowRestore(IdContainerFileDir location, long currentEntries, Duration currentDuration) {
        if (!this.largeDataIdentifications.add(location)) {
            return;
        }
        debug.warning("Die Wiederherstellung des Verwaltungsdatenindexes f\u00fcr die Datenidentifikation " + this.dataIdentificationManager.formatContainerDirectory(location) + " im Verzeichnis '" + String.valueOf(this.getPath(location)) + "' ben\u00f6tigt l\u00e4nger als " + currentDuration.toMinutes() + " Minuten. Es wurden bereits " + currentEntries + " Containerdateien indiziert. Es sollte gepr\u00fcft werden, ob eine Software \u00fcberm\u00e4\u00dfig viele Daten generiert, ob viele Datenzeitspr\u00fcnge auftreten oder ob der Vorhaltezeitraum verk\u00fcrzt werden kann. Falls fehlerhafte Daten archiviert wurden, sollten diese ggf. endg\u00fcltig gel\u00f6scht werden.");
    }

    public final PersistenceDirectoryLayoutInstance getLayoutInstance() {
        return this.layoutInstance;
    }

    @NotNull
    @Contract(pure=true)
    public Path getPath(IdDataIdentification dataIdentification) {
        if (dataIdentification.getSimVariant() != this.layoutInstance.simulationVariant()) {
            throw new IllegalArgumentException("Falsche \u00fcbergebene Simulationsvariante");
        }
        return this.layoutInstance.getPath(dataIdentification);
    }

    @NotNull
    @Contract(pure=true)
    public Path getPath(ContainerDirectory containerDirectory) {
        if (containerDirectory.getSimVariant() != this.layoutInstance.simulationVariant()) {
            throw new IllegalArgumentException("Falsche \u00fcbergebene Simulationsvariante");
        }
        return this.layoutInstance.getPath(containerDirectory);
    }

    public IndexTree getIndexTree() {
        return this.indexTree;
    }

    public Set<IdContainerFileDir> getLargeDataIdentifications() {
        return Collections.unmodifiableSortedSet(this.largeDataIdentifications);
    }

    public Path getLockFile() {
        return this.getBasePath().resolve("_isActive.flag");
    }

    public void warnAboutHugeContainerDirectory(IdContainerFileDir location, long numEntries) {
        if (!this.largeDataIdentifications.add(location)) {
            return;
        }
        debug.warning("F\u00fcr die Datenidentifikation " + this.dataIdentificationManager.formatContainerDirectory(location) + " im Verzeichnis '" + String.valueOf(this.getPath(location)) + "' sind eine gro\u00dfe Zahl (" + numEntries + ") Container vorhanden, was zu Problemen und schlechter Performance f\u00fchren kann. Es sollte gepr\u00fcft werden, ob eine Software \u00fcberm\u00e4\u00dfig viele Daten generiert, ob viele Datenzeitspr\u00fcnge auftreten oder ob der Vorhaltezeitraum verk\u00fcrzt werden kann. Falls fehlerhafte Daten archiviert wurden, sollten diese ggf. endg\u00fcltig gel\u00f6scht werden.");
    }

    public DeletedContainerFile openDeletedContainerFile(LockedContainerDirectory containerDirectory) throws PersistenceException, SynchronizationFailedException {
        DeletedContainerFile deletedContainerFile = new DeletedContainerFile(containerDirectory, this);
        if (!deletedContainerFile.exists()) {
            try {
                this.initiallyBuildDeletedContainerFile(containerDirectory, deletedContainerFile);
            }
            catch (IndexException e) {
                throw new PersistenceException(e);
            }
        }
        try {
            deletedContainerFile.read();
        }
        catch (PersistenceException e) {
            debug.warning("Fehler beim Einlesen der Datei, die gel\u00f6schte Container enth\u00e4lt: " + String.valueOf(deletedContainerFile.getFile()) + ". Ung\u00fcltige Eintr\u00e4ge werden ignoriert.", (Throwable)e);
        }
        return deletedContainerFile;
    }

    private void initiallyBuildDeletedContainerFile(LockedContainerDirectory containerDirectory, DeletedContainerFile deletedContainerFile) throws PersistenceException, IndexException, SynchronizationFailedException {
        IndexResult<ContainerManagementInformation> headers = this.getContainerHeaders(containerDirectory);
        ArrayList containersToDelete = new ArrayList();
        for (int i = 0; i < headers.size(); ++i) {
            if (!headers.getBoolean(i, ContainerManagementInformation.CHP_DELETED)) continue;
            long containerId = headers.get(i, ContainerManagementInformation.CHP_CONT_ID);
            try (ContainerFileHandle handle = this.accessContainer(containerDirectory, containerId);){
                if (!handle.existsContainer()) continue;
                this.executeOnContainer(handle.getFile(), () -> {
                    handle.readContainerHeader();
                    deletedContainerFile.addDeletedContainer(handle);
                    containersToDelete.add(containerId);
                });
                continue;
            }
        }
        deletedContainerFile.write();
        for (Long contId : containersToDelete) {
            Path contFile = this.getPath(containerDirectory).resolve(ContainerFile.getContainerFileName(contId));
            try {
                Files.delete(contFile);
            }
            catch (IOException e) {
                debug.warning("Kann Containerdatei nicht l\u00f6schen: " + String.valueOf(contFile), (Throwable)e);
            }
        }
    }

    @NotNull
    public DataIterator iterator(ArchiveDataKind adk, long containerId, IdDataIdentification dataIdentification) throws PersistenceException {
        try (ContainerFileHandle handle = new ContainerFileHandle(dataIdentification.resolve(adk), containerId, true, this.layoutInstance);){
            if (handle.existsContainer()) {
                ContainerDataIterator containerDataIterator = handle.iterator();
                return containerDataIterator;
            }
        }
        SyncKey<IdDataIdentification> indexLock = this.dataIdentificationManager.lockIndex(dataIdentification);
        try {
            ContainerHeaders headers = this.getContainerHeaders(new LockedContainerDirectory(indexLock, adk), containerId);
            DeletedMinMaxIterator deletedMinMaxIterator = new DeletedMinMaxIterator(headers, adk, indexLock.getElement());
            if (indexLock != null) {
                indexLock.close();
            }
            return deletedMinMaxIterator;
        }
        catch (Throwable throwable) {
            try {
                if (indexLock != null) {
                    try {
                        indexLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SynchronizationFailedException | IndexException e) {
                throw new PersistenceException(e);
            }
        }
    }

    public void removeContainerFromIndex(LockedContainerDirectory containerDirectory, long containerId) throws IndexException {
        Optional<? extends ContainerManagementIndex> headerIdx;
        Optional<? extends ArchiveTimeIndex> aTimeMonoIdx;
        Optional<? extends DataIndexIndex> diIdx;
        Optional<? extends DataTimeIndex> dtIdx = this.getIndexTree().getDataTimeIndex(containerDirectory);
        if (dtIdx.isPresent()) {
            dtIdx.get().removeAll(ImmutableMap.of((Object)((Object)IndexValues.ContainerId), (Object)new LongRange(containerId, containerId)));
        }
        if (containerDirectory.archiveDataKind().isDelayed() && (diIdx = this.getIndexTree().getDataIndexIndex(containerDirectory)).isPresent()) {
            diIdx.get().removeAll(ImmutableMap.of((Object)((Object)IndexValues.ContainerId), (Object)new LongRange(containerId, containerId)));
        }
        if ((aTimeMonoIdx = this.getIndexTree().getArchiveTimeIndex(containerDirectory)).isPresent()) {
            aTimeMonoIdx.get().removeAll(ImmutableMap.of((Object)((Object)IndexValues.ContainerId), (Object)new LongRange(containerId, containerId)));
        }
        if ((headerIdx = this.getIndexTree().getContainerManagementIndex(containerDirectory)).isPresent()) {
            headerIdx.get().removeAll(ImmutableMap.of((Object)((Object)ContainerManagementInformation.CHP_CONT_ID), (Object)new LongRange(containerId, containerId)));
        }
    }

    public IndexResult<IndexValues> getIndexResult(LockedContainerDirectory containerDirectory, SequenceSpecification sequenceSpecification) throws IndexException, SynchronizationFailedException {
        if (sequenceSpecification instanceof DataIndexSequenceSpecification) {
            DataIndexSequenceSpecification spec = (DataIndexSequenceSpecification)sequenceSpecification;
            Optional<? extends DataIndexIndex> dataIndexIndex = this.getIndexTree().getDataIndexIndex(containerDirectory);
            if (dataIndexIndex.isEmpty()) {
                return new AggregateIndexResult<IndexValues>();
            }
            return dataIndexIndex.get().getContainerIDByDataIndex(spec.minimumIndex(), spec.maximumIndex());
        }
        if (sequenceSpecification instanceof ArchiveTimeSequenceSpecification) {
            ArchiveTimeSequenceSpecification spec = (ArchiveTimeSequenceSpecification)sequenceSpecification;
            Optional<? extends ArchiveTimeIndex> archiveTimeIndex = this.getIndexTree().getArchiveTimeIndex(containerDirectory);
            if (archiveTimeIndex.isEmpty()) {
                return new AggregateIndexResult<IndexValues>();
            }
            return archiveTimeIndex.get().getContainerIDByArchiveTime(spec.minimumTime(), spec.maximumTime());
        }
        if (sequenceSpecification instanceof AllDataSpecification) {
            Optional<? extends DataIndexIndex> dataIndexIndex = this.getIndexTree().getDataIndexIndex(containerDirectory);
            if (dataIndexIndex.isEmpty()) {
                return new AggregateIndexResult<IndexValues>();
            }
            return dataIndexIndex.get().query();
        }
        throw new AssertionError();
    }

    public void rebuildIndexes(LockedContainerDirectory containerDirectory, @Nullable RebuildResult rebuildResult) throws IndexException {
        this.getIndexTree().recreateIndex(containerDirectory, rebuildResult);
    }

    public void deleteIndexes(LockedContainerDirectory containerDirectory, @Nullable RebuildResult rebuildResult) throws IndexException {
        this.getIndexTree().deleteIndex(containerDirectory, rebuildResult);
    }

    public long maxContainerId(LockedContainerDirectory containerDirectory) throws IndexException {
        Optional<? extends ContainerManagementIndex> index = this.getIndexTree().getContainerManagementIndex(containerDirectory);
        if (index.isEmpty()) {
            return -1L;
        }
        return index.get().getLast(ContainerManagementInformation.CHP_CONT_ID);
    }

    public int getSimulationVariant() {
        return this.getLayoutInstance().simulationVariant();
    }

    public String toString() {
        return this.layoutInstance.basePath().toString();
    }

    @Override
    public long estimate() {
        return this.lastCount.get();
    }

    @Override
    public void setCount(long actualCount) {
        this.lastCount.set(actualCount);
    }

    public abstract DataRange getDataRange(LockedContainerDirectory var1) throws IndexException;

    protected DataRange computeDataRange(LockedContainerDirectory directory) {
        try {
            Optional<? extends DataIndexIndex> dataIndexIndex = this.getIndexTree().getDataIndexIndex(directory);
            Optional<? extends DataTimeIndex> dataTimeIndex = this.getIndexTree().getDataTimeIndex(directory);
            Optional<? extends ArchiveTimeIndex> archiveTimeIndex = this.getIndexTree().getArchiveTimeIndex(directory);
            if (dataTimeIndex.isEmpty() || dataIndexIndex.isEmpty() || archiveTimeIndex.isEmpty()) {
                return NoData.Instance;
            }
            return new SimpleDataRange(archiveTimeIndex.get().getFirst(IndexValues.ArchiveTimeMin), archiveTimeIndex.get().getLast(IndexValues.ArchiveTimeMax), dataTimeIndex.get().getFirst(IndexValues.DataTimeMin), dataTimeIndex.get().getLast(IndexValues.DataTimeMax), dataIndexIndex.get().getFirst(IndexValues.DataIndexMin), dataIndexIndex.get().getLast(IndexValues.DataIndexMax));
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface ContainerCall {
        public void call() throws PersistenceException, SynchronizationFailedException;
    }
}

