/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories;

import de.bsvrz.ars.ars.persistence.DataIdentificationManager;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.cache.DataRange;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.layout.PersistenceDirectoryLayoutInstance;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ReadonlyPersistenceDirectory
extends PersistenceDirectory {
    private Map<IdContainerFileDir, DataRange> rangeCacheMap = new ConcurrentHashMap<IdContainerFileDir, DataRange>();

    public ReadonlyPersistenceDirectory(@NotNull DataIdentificationManager dataIdentificationManager, @NotNull PersistenceDirectoryLayoutInstance layoutInstance) {
        super(dataIdentificationManager, layoutInstance);
    }

    @Override
    public DataRange getDataRange(LockedContainerDirectory directory) throws IndexException {
        try {
            return this.rangeCacheMap.computeIfAbsent(IdContainerFileDir.of(directory), it -> this.computeDataRange(directory));
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IndexException) {
                IndexException idx = (IndexException)throwable;
                throw idx;
            }
            throw e;
        }
    }
}

