/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories.mgmt.lock;

import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.DirectoryIsLockedException;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.DirectoryStatus;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;

public class LockFileManager {
    private static final Debug _debug = Debug.getLogger();
    public static final String ACCESS_FLAG_FILE_NAME = "_isActive.flag";
    public static final String NOT_PROTECTED_FLAG_FILE_NAME = ".isOpen.flag";
    private final ConcurrentHashMap<Path, DirectoryToken> cache = new ConcurrentHashMap();

    public void createWritable(Path path) throws IOException {
        DirectoryToken token = this.openPath(path);
        token.createWritable();
    }

    public DirectoryStatus open(Path path) throws IOException, DirectoryIsLockedException {
        DirectoryToken token = this.openPath(path);
        try {
            token.access();
        }
        catch (FileAlreadyExistsException e) {
            throw new DirectoryIsLockedException("Die Sperrdatei \"" + e.getFile() + "\" zeigt an, dass bereits ein Archivsystem im Persistenzverzeichnis aktiv ist.", e);
        }
        return token.writeStatus();
    }

    public void forceWritable(Path path) throws IOException {
        DirectoryToken token = this.openPath(path);
        token.forceWritable();
    }

    public void writeProtectPermanently(Path path) throws IOException {
        DirectoryToken token = this.openPath(path);
        token.writeProtectPermanently();
    }

    public void close(Path path) throws IOException {
        DirectoryToken token = this.openPath(path);
        token.close();
    }

    private DirectoryToken openPath(Path path) {
        return this.cache.computeIfAbsent(path, DirectoryToken::new);
    }

    private static class DirectoryToken {
        private final Path path;
        private final Path accessFile;
        private final Path openFile;
        boolean accessed = false;
        DirectoryStatus status = null;

        public DirectoryToken(Path path) {
            this.path = path;
            this.accessFile = path.resolve(LockFileManager.ACCESS_FLAG_FILE_NAME);
            this.openFile = path.resolve(LockFileManager.NOT_PROTECTED_FLAG_FILE_NAME);
        }

        public void createWritable() throws IOException {
            if (Files.isDirectory(this.path, new LinkOption[0]) && !Files.deleteIfExists(this.path)) {
                throw new FileAlreadyExistsException(this.path.toAbsolutePath().toString());
            }
            Files.createDirectories(this.path, new FileAttribute[0]);
            Files.createFile(this.accessFile, new FileAttribute[0]);
            Files.createFile(this.openFile, new FileAttribute[0]);
            this.status = DirectoryStatus.Writable;
            this.accessed = true;
        }

        public void forceWritable() throws IOException {
            Files.createDirectories(this.path, new FileAttribute[0]);
            if (!Files.exists(this.accessFile, new LinkOption[0])) {
                Files.createFile(this.accessFile, new FileAttribute[0]);
            }
            if (!Files.exists(this.openFile, new LinkOption[0])) {
                Files.createFile(this.openFile, new FileAttribute[0]);
            }
            this.status = DirectoryStatus.Writable;
            this.accessed = true;
        }

        public void access() throws IOException {
            if (!Files.isDirectory(this.path, new LinkOption[0])) {
                throw new NoSuchFileException(this.path.toAbsolutePath().toString());
            }
            if (Files.exists(this.openFile, new LinkOption[0])) {
                Files.createFile(this.accessFile, new FileAttribute[0]);
                this.status = DirectoryStatus.Writable;
            } else {
                try {
                    Files.createFile(this.accessFile, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException e) {
                    _debug.fine("Ignoriere existierende Lock-Datei in geschlossenem Verzeichnis", (Throwable)e);
                }
                this.status = DirectoryStatus.Finalized;
            }
            this.accessed = true;
        }

        public DirectoryStatus writeStatus() {
            return this.status;
        }

        public void writeProtectPermanently() throws IOException {
            assert (this.accessed);
            if (this.status != DirectoryStatus.Writable) {
                throw new IOException("Verzeichnis ist nicht beschreibbar: " + String.valueOf(this.path.toAbsolutePath()));
            }
            Files.deleteIfExists(this.openFile);
        }

        public void close() throws IOException {
            Files.deleteIfExists(this.accessFile);
            this.status = null;
            this.accessed = false;
        }
    }
}

