/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories.mgmt.range;

import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class RangeList<T extends TimeRange<T>>
extends AbstractSequentialList<T> {
    private final T start;
    private final T end;

    public RangeList(T start, T end) {
        this.start = start;
        this.end = end;
        if (start.stepsUntil(end) < 0L) {
            throw new IllegalArgumentException("Start ist hinter Ende");
        }
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        MyIterator iterator = new MyIterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public int size() {
        long size = 1L + this.start.stepsUntil(this.end);
        if (size < 0L || size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public boolean contains(Object o) {
        return this.start.compareTo((TimeRange)((TimeRange)o)) >= 0 && this.end.compareTo((TimeRange)((TimeRange)o)) <= 0;
    }

    private class MyIterator
    implements ListIterator<T> {
        T nextItem;
        int nextIndex;

        private MyIterator() {
            this.nextItem = RangeList.this.start;
            this.nextIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return !this.nextItem.equals(RangeList.this.end.next());
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Object tmp = this.nextItem;
            this.nextItem = (TimeRange)tmp.next();
            return tmp;
        }

        @Override
        public boolean hasPrevious() {
            return !this.nextItem.equals(RangeList.this.start);
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            this.nextItem = (TimeRange)this.nextItem.previous();
            return this.nextItem;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }
    }
}

