/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories.mgmt.range;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.RangeList;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import org.jetbrains.annotations.Contract;

public abstract class TimeDomain<T extends TimeRange<T>>
extends DiscreteDomain<T> {
    public List<T> getIntervals(@NotNull Range<Instant> timeRange) {
        T start = this.ofEpochMillis(((Instant)timeRange.lowerEndpoint()).toEpochMilli());
        T end = this.ofEpochMillis(((Instant)timeRange.upperEndpoint()).toEpochMilli());
        return new RangeList<T>(start, end);
    }

    @Contract(pure=true)
    @NotNull
    public abstract T ofEpochMillis(long var1);

    @Contract(pure=true)
    @Nullable
    public abstract T ofPath(Path var1);

    @Contract(pure=true)
    @NotNull
    public abstract Path getPath(T var1);

    public abstract int getMaxDepth();
}

