/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories.mgmt.range;

import com.google.common.collect.Range;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeRange;
import java.time.LocalDate;
import java.time.ZoneOffset;

public record Week(long internalWeekNumber) implements TimeRange<Week>
{
    static final LocalDate root = LocalDate.of(2017, 1, 1);
    private static final long MAX_WEEK_NUMBER = 15250282000L;
    private static final long MIN_WEEK_NUMBER = -15250286905L;

    public Week {
        if (internalWeekNumber > 15250282000L || internalWeekNumber < -15250286905L) {
            throw new IllegalArgumentException("internalWeekNumber: " + internalWeekNumber);
        }
    }

    @Override
    public int compareTo(Week o) {
        return Long.compare(this.internalWeekNumber, o.internalWeekNumber);
    }

    public LocalDate getFirstDay() {
        return root.plusDays(this.internalWeekNumber * 7L);
    }

    public LocalDate getLastDay() {
        return root.plusDays(6L + this.internalWeekNumber * 7L);
    }

    @Override
    public Range<LocalDate> getDayRange() {
        return Range.closed((Comparable)this.getFirstDay(), (Comparable)this.getLastDay());
    }

    public long getFirstEpochMillis() {
        return this.getFirstDay().atStartOfDay().atOffset(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    public long getLastEpochMillis() {
        return this.getLastDay().plusDays(1L).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    @Override
    public Range<Long> getEpochMillisRange() {
        return Range.closedOpen((Comparable)Long.valueOf(this.getFirstEpochMillis()), (Comparable)Long.valueOf(this.getLastEpochMillis()));
    }

    @Override
    public Week next() {
        return new Week(this.internalWeekNumber + 1L);
    }

    @Override
    public Week previous() {
        return new Week(this.internalWeekNumber - 1L);
    }

    @Override
    public long stepsUntil(Week other) {
        return other.internalWeekNumber - this.internalWeekNumber;
    }
}

