/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.directories.mgmt.range;

import de.bsvrz.ars.ars.persistence.directories.mgmt.range.TimeDomain;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.Week;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;

public final class WeekDomain
extends TimeDomain<Week> {
    private static final Debug _debug = Debug.getLogger();

    public Week ofDate(LocalDate date) {
        return new Week(Math.floorDiv(ChronoUnit.DAYS.between(Week.root, date), 7));
    }

    @Override
    @NotNull
    public Week ofEpochMillis(long epochMillis) {
        return this.ofDate(Instant.ofEpochMilli(epochMillis).atOffset(ZoneOffset.UTC).toLocalDate());
    }

    @Override
    public Week ofPath(Path relativePath) {
        if (relativePath.isAbsolute()) {
            throw new IllegalArgumentException("Pfad ist absolut: " + String.valueOf(relativePath));
        }
        if (relativePath.getNameCount() != 2) {
            _debug.fine("Ignoriere Verzeichnis: Ben\u00f6tige 2 Komponenten: " + String.valueOf(relativePath));
            return null;
        }
        String year = relativePath.getName(0).toString();
        String weekStart = relativePath.getName(1).toString();
        try {
            LocalDate date = LocalDate.parse(weekStart);
            Week week = this.ofDate(date);
            if (week.getFirstDay().equals(date)) {
                if (!String.valueOf(date.getYear()).equals(year)) {
                    _debug.fine("Ignoriere Verzeichnis: Falsches Jahr: " + String.valueOf(relativePath));
                    return null;
                }
                return week;
            }
        }
        catch (DateTimeParseException e) {
            _debug.fine("Ignoriere Verzeichnis: Kein g\u00fcltiger Zeitbereich: " + weekStart, (Throwable)e);
            return null;
        }
        _debug.fine("Ignoriere Verzeichnis: Kein g\u00fcltiger Zeitbereich: " + weekStart);
        return null;
    }

    @Override
    @NotNull
    public Path getPath(Week timeRange) {
        LocalDate firstDay = timeRange.getFirstDay();
        return Path.of(String.valueOf(firstDay.getYear()), firstDay.toString());
    }

    @Override
    public int getMaxDepth() {
        return 2;
    }

    @NotNull
    public Week next(Week value) {
        return value.next();
    }

    @NotNull
    public Week previous(Week value) {
        return value.previous();
    }

    public long distance(Week start, Week end) {
        return end.internalWeekNumber() - start.internalWeekNumber();
    }

    public static boolean isYearDir(Path path) {
        try {
            int year = Integer.parseInt(path.getFileName().toString());
            return year > 1900 && year <= 9999;
        }
        catch (Exception e) {
            return false;
        }
    }
}

