/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index;

import de.bsvrz.ars.ars.mgmt.datatree.IndexImpl;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.index.CorruptIndexException;
import de.bsvrz.ars.ars.persistence.index.backend.management.AbstractIndex;
import de.bsvrz.ars.ars.persistence.index.backend.management.ColumnType;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;
import java.nio.file.Path;

public class ContainerManagementIndex
extends AbstractIndex<ContainerManagementInformation> {
    public static final String IDX_FILENAME = IndexImpl.ManagementData.getFileName();
    public static final IndexContentDescriptor<ContainerManagementInformation> INDEX_CONTENT_DESCRIPTOR = new IndexContentDescriptor<ContainerManagementInformation>(ContainerManagementInformation.class);

    public ContainerManagementIndex(int bufferSize, Path file) throws CorruptIndexException {
        super(INDEX_CONTENT_DESCRIPTOR, bufferSize, file);
    }

    public static int entrySize() {
        return INDEX_CONTENT_DESCRIPTOR.getEntryLengthBytes();
    }

    static {
        for (ContainerManagementInformation containerHeaderParam : ContainerManagementInformation.values()) {
            int byteLength = containerHeaderParam.getByteLength();
            ColumnType type = containerHeaderParam == ContainerManagementInformation.CHP_CONT_ID ? ColumnType.StrictlyIncreasing : (containerHeaderParam.isNumeric() ? ColumnType.Unordered : ColumnType.String);
            INDEX_CONTENT_DESCRIPTOR.addColumn(byteLength, containerHeaderParam, type);
        }
    }
}

