/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index;

import de.bsvrz.ars.ars.mgmt.datatree.IndexImpl;
import de.bsvrz.ars.ars.persistence.index.CorruptIndexException;
import de.bsvrz.ars.ars.persistence.index.DataIndexIndex;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.backend.management.AbstractIndex;
import de.bsvrz.ars.ars.persistence.index.backend.management.ColumnType;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;
import java.nio.file.Path;

public final class DataIndexIndexImpl
extends AbstractIndex<IndexValues>
implements DataIndexIndex {
    public static final String IDX_FILENAME = IndexImpl.DataIndex.getFileName();
    private static final IndexContentDescriptor<IndexValues> INDEX_CONTENT_DESCRIPTOR = new IndexContentDescriptor<IndexValues>(IndexValues.class);

    public DataIndexIndexImpl(int bufferSize, Path file) throws CorruptIndexException {
        super(INDEX_CONTENT_DESCRIPTOR, bufferSize, file);
    }

    public void add(long dIMin, long dIMax, long contId) throws IndexException {
        this.checkAdd(dIMin, dIMax, contId);
        this.setInsertValue(IndexValues.DataIndexMin, dIMin);
        this.setInsertValue(IndexValues.DataIndexMax, dIMax);
        this.setInsertValue(IndexValues.ContainerId, contId);
        this.insert();
    }

    private void checkAdd(long dIMin, long dIMax, long contId) throws IndexException {
        if (dIMin < 0L || dIMax < 0L || contId <= 0L) {
            throw new CorruptIndexException("DatenIndexIndex: neuer Eintrag ung\u00fcltig: (dIMin=" + dIMin + ", dIMax=" + dIMax + ", contID=" + contId + ")", this.getFile());
        }
    }

    public static int entrySize() {
        return INDEX_CONTENT_DESCRIPTOR.getEntryLengthBytes();
    }

    static {
        INDEX_CONTENT_DESCRIPTOR.addRange(8, IndexValues.DataIndexMin, ColumnType.Increasing, IndexValues.DataIndexMax, ColumnType.Unordered);
        INDEX_CONTENT_DESCRIPTOR.addColumn(5, IndexValues.ContainerId, ColumnType.Unique);
    }
}

