/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.backend.management;

import de.bsvrz.ars.ars.persistence.index.backend.management.ColumnType;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public class IndexContentDescriptor<E extends Enum<E>> {
    private final EnumMap<E, IndexColumn> _columnMap;
    private final List<IndexColumn> _columns = new ArrayList<IndexColumn>();
    private int _lengthBytes;

    public IndexContentDescriptor(Class<E> elementClass) {
        this._columnMap = new EnumMap(elementClass);
    }

    public List<IndexColumn> getColumns() {
        return Collections.unmodifiableList(this._columns);
    }

    public int getEntryLengthBytes() {
        return this._lengthBytes;
    }

    public void addColumn(int bytes, E data, ColumnType type) {
        this.addColumn(bytes, data, type, false);
    }

    public void addRange(int bytes, E data1, ColumnType type1, E data2, ColumnType type2) {
        this.addColumn(bytes, data1, type1, false);
        this.addColumn(bytes, data2, type2, true);
    }

    private void addColumn(int bytes, E data, ColumnType type, boolean prevIsMin) {
        IndexColumn min = null;
        if (prevIsMin) {
            min = this._columns.get(this._columns.size() - 1);
        }
        IndexColumn column = new IndexColumn(this._columns.size(), bytes, this._lengthBytes, type, (Enum<?>)data, min);
        this._columns.add(column);
        this._columnMap.put(data, column);
        this._lengthBytes += bytes;
    }

    public IndexColumn getColumn(E value) {
        return this._columnMap.get(value);
    }

    public String toString() {
        return "IndexContentDescriptor{" + String.valueOf(this._columnMap) + "}";
    }

    public static class IndexColumn {
        private final int _index;
        private final int _lengthBytes;
        private final int _offsetBytes;
        private final ColumnType _type;
        private final Enum<?> _data;
        @Nullable
        private final IndexColumn _minColumn;

        private IndexColumn(int index, int lengthBytes, int offsetBytes, ColumnType type, Enum<?> data, @Nullable IndexColumn minColumn) {
            this._index = index;
            this._lengthBytes = lengthBytes;
            this._offsetBytes = offsetBytes;
            this._type = type;
            this._data = data;
            this._minColumn = minColumn;
        }

        private static byte long7(long x) {
            return (byte)(x >> 56);
        }

        private static byte long6(long x) {
            return (byte)(x >> 48);
        }

        private static byte long5(long x) {
            return (byte)(x >> 40);
        }

        private static byte long4(long x) {
            return (byte)(x >> 32);
        }

        private static byte long3(long x) {
            return (byte)(x >> 24);
        }

        private static byte long2(long x) {
            return (byte)(x >> 16);
        }

        private static byte long1(long x) {
            return (byte)(x >> 8);
        }

        private static byte long0(long x) {
            return (byte)x;
        }

        private static long readLong7(byte x) {
            return ((long)x & 0xFFL) << 56;
        }

        private static long readLong6(byte x) {
            return ((long)x & 0xFFL) << 48;
        }

        private static long readLong5(byte x) {
            return ((long)x & 0xFFL) << 40;
        }

        private static long readLong4(byte x) {
            return ((long)x & 0xFFL) << 32;
        }

        private static long readLong3(byte x) {
            return ((long)x & 0xFFL) << 24;
        }

        private static long readLong2(byte x) {
            return ((long)x & 0xFFL) << 16;
        }

        private static long readLong1(byte x) {
            return ((long)x & 0xFFL) << 8;
        }

        private static long readLong0(byte x) {
            return (long)x & 0xFFL;
        }

        public int getLengthBytes() {
            return this._lengthBytes;
        }

        public ColumnType getType() {
            return this._type;
        }

        public long readLong(byte[] data) {
            return this.readLong(data, 0);
        }

        public long readLong(byte[] data, int baseOffset) {
            int offset = this._offsetBytes + baseOffset;
            long result = 0L;
            switch (this._lengthBytes) {
                case 8: {
                    result |= IndexColumn.readLong7(data[offset++]);
                }
                case 7: {
                    result |= IndexColumn.readLong6(data[offset++]);
                }
                case 6: {
                    result |= IndexColumn.readLong5(data[offset++]);
                }
                case 5: {
                    result |= IndexColumn.readLong4(data[offset++]);
                }
                case 4: {
                    result |= IndexColumn.readLong3(data[offset++]);
                }
                case 3: {
                    result |= IndexColumn.readLong2(data[offset++]);
                }
                case 2: {
                    result |= IndexColumn.readLong1(data[offset++]);
                }
                case 1: {
                    result |= IndexColumn.readLong0(data[offset]);
                }
            }
            return result;
        }

        public String readString(byte[] data) {
            return new String(data, this._offsetBytes, this._lengthBytes, StandardCharsets.ISO_8859_1);
        }

        public int getColumnIndex() {
            return this._index;
        }

        public Enum<?> getData() {
            return this._data;
        }

        public void writeBytes(long value, byte[] result) {
            int offset = this._offsetBytes;
            switch (this._lengthBytes) {
                case 8: {
                    result[offset++] = IndexColumn.long7(value);
                }
                case 7: {
                    result[offset++] = IndexColumn.long6(value);
                }
                case 6: {
                    result[offset++] = IndexColumn.long5(value);
                }
                case 5: {
                    result[offset++] = IndexColumn.long4(value);
                }
                case 4: {
                    result[offset++] = IndexColumn.long3(value);
                }
                case 3: {
                    result[offset++] = IndexColumn.long2(value);
                }
                case 2: {
                    result[offset++] = IndexColumn.long1(value);
                }
                case 1: {
                    result[offset] = IndexColumn.long0(value);
                    return;
                }
            }
            throw new UnsupportedOperationException(this._lengthBytes + " L\u00e4nge");
        }

        public void writeBytes(String value, byte[] result) {
            int i;
            int offset = this._offsetBytes;
            for (i = 0; i < value.length(); ++i) {
                result[offset++] = (byte)value.charAt(i);
            }
            for (i = value.length(); i < this._lengthBytes; ++i) {
                result[offset++] = 0;
            }
        }

        public String toString() {
            return "IndexColumn{type=" + String.valueOf((Object)this._type) + ", data=" + String.valueOf(this._data) + "}";
        }

        @NotNull
        public IndexColumn getMinColumn() {
            if (this._minColumn == null) {
                return this;
            }
            return this._minColumn;
        }
    }
}

