/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.backend.management;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.NoSuchElementException;

public class LongRange {
    @Nullable
    private final Long _lowerEndPoint;
    @Nullable
    private final Long _upperEndPoint;

    public LongRange(@Nullable Long lowerEndPoint, @Nullable Long upperEndPoint) {
        this._lowerEndPoint = lowerEndPoint;
        this._upperEndPoint = upperEndPoint;
    }

    public long lowerEndpoint() {
        if (this._lowerEndPoint == null) {
            throw new NoSuchElementException("Keine untere Begrenzung der Anfrage");
        }
        return this._lowerEndPoint;
    }

    public long upperEndpoint() {
        if (this._upperEndPoint == null) {
            throw new NoSuchElementException("Keine obere Begrenzung der Anfrage");
        }
        return this._upperEndPoint;
    }

    public boolean hasLowerBound() {
        return this._lowerEndPoint != null;
    }

    public boolean hasUpperBound() {
        return this._upperEndPoint != null;
    }

    public boolean contains(long value) {
        return !(this._lowerEndPoint != null && this._lowerEndPoint > value || this._upperEndPoint != null && this._upperEndPoint < value);
    }

    @Nullable
    public LongRange intersection(LongRange other) {
        Long lowerEndPoint = LongRange.nullsafeMax(this._lowerEndPoint, other._lowerEndPoint);
        Long upperEndPoint = LongRange.nullsafeMin(this._upperEndPoint, other._upperEndPoint);
        if (lowerEndPoint != null && upperEndPoint != null && lowerEndPoint > upperEndPoint) {
            return null;
        }
        return new LongRange(lowerEndPoint, upperEndPoint);
    }

    @Nullable
    private static Long nullsafeMin(@Nullable Long a, @Nullable Long b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.min(a, b);
    }

    @Nullable
    private static Long nullsafeMax(@Nullable Long a, @Nullable Long b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.max(a, b);
    }

    public String toString() {
        return LongRange.format(this._lowerEndPoint) + "..." + LongRange.format(this._upperEndPoint);
    }

    private static String format(@Nullable Long point) {
        if (point == null) {
            return "~";
        }
        return point.toString();
    }
}

