/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.backend.storage;

import de.bsvrz.ars.ars.persistence.index.backend.storage.IndexStorage;
import de.bsvrz.dav.daf.util.BufferedRandomAccessFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class FileIndexStorage
implements IndexStorage,
AutoCloseable {
    private final BufferedRandomAccessFile _file;
    private final int _entryByteSize;

    public FileIndexStorage(Path file, int entryByteSize) throws IOException {
        Path parentDir = file.getParent();
        if (parentDir != null && !Files.isDirectory(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        this._file = new BufferedRandomAccessFile(file.toFile());
        this._entryByteSize = entryByteSize;
        long length = this._file.length();
        if (length % (long)entryByteSize != 0L) {
            throw new IOException("Dateil\u00e4nge ist ung\u00fcltig: " + length + ". Erwarte Vielfaches von " + entryByteSize + ".");
        }
    }

    @Override
    public void getEntries(long entryIndex, int numEntries, byte[] result, int destPos) throws IOException {
        this._file.position(entryIndex * (long)this._entryByteSize);
        this._file.readFully(result, destPos, numEntries * this._entryByteSize);
    }

    @Override
    public void setEntries(long entryIndex, int numEntries, byte[] data, int fromPos) throws IOException {
        this._file.position(entryIndex * (long)this._entryByteSize);
        this._file.write(data, fromPos, numEntries * this._entryByteSize);
        this._file.flush();
    }

    @Override
    public void insertEntries(long entryIndex, int numEntries, byte[] data, int fromPos) throws IOException {
        this.shiftFileRight(entryIndex * (long)this._entryByteSize, numEntries * this._entryByteSize);
        this.setEntries(entryIndex, numEntries, data, fromPos);
    }

    private void shiftFileRight(long fromPosition, int shiftDistance) throws IOException {
        long readPosLowerBound;
        if (shiftDistance == 0) {
            return;
        }
        if (shiftDistance < 0) {
            throw new IllegalArgumentException();
        }
        byte[] buffer = new byte[8192];
        long readPosUpperBound = this._file.length();
        if (readPosUpperBound % (long)this.entryByteSize() != 0L) {
            throw new IOException("Dateil\u00e4nge ist ung\u00fcltig: " + readPosUpperBound + ". Erwarte Vielfaches von " + this.entryByteSize() + ".");
        }
        while ((readPosLowerBound = Math.max(readPosUpperBound - (long)buffer.length, fromPosition)) != readPosUpperBound) {
            this._file.position(readPosLowerBound);
            int len = (int)(readPosUpperBound - readPosLowerBound);
            this._file.readFully(buffer, 0, len);
            if (len == this._entryByteSize) {
                this._file.position(0L);
            }
            this._file.position(readPosLowerBound + (long)shiftDistance);
            this._file.write(buffer, 0, len);
            readPosUpperBound = readPosLowerBound;
        }
    }

    @Override
    public void deleteEntryAtIndex(long entryIndex) throws IOException {
        this.shiftFileLeft((1L + entryIndex) * (long)this._entryByteSize, this._entryByteSize);
    }

    public void flush() throws IOException {
        this._file.flush();
    }

    private void shiftFileLeft(long fromPosition, int shiftDistance) throws IOException {
        long readPosUpperBound;
        if (shiftDistance == 0) {
            return;
        }
        if (shiftDistance < 0) {
            throw new IllegalArgumentException();
        }
        byte[] buffer = new byte[8192];
        long fileLength = this._file.length();
        if (fileLength % (long)this.entryByteSize() != 0L) {
            throw new IOException("Dateil\u00e4nge ist ung\u00fcltig: " + fileLength + ". Erwarte Vielfaches von " + this.entryByteSize() + ".");
        }
        long readPosLowerBound = fromPosition;
        while (readPosLowerBound != (readPosUpperBound = Math.min(readPosLowerBound + (long)buffer.length, fileLength))) {
            this._file.position(readPosLowerBound);
            int len = (int)(readPosUpperBound - readPosLowerBound);
            this._file.readFully(buffer, 0, len);
            this._file.position(readPosLowerBound - (long)shiftDistance);
            this._file.write(buffer, 0, len);
            readPosLowerBound = readPosUpperBound;
        }
        this._file.setLength(this._file.length() - (long)this._entryByteSize);
    }

    @Override
    public long numEntries() throws IOException {
        long length = this._file.length();
        if (length % (long)this.entryByteSize() != 0L) {
            throw new IOException("Dateil\u00e4nge ist ung\u00fcltig: " + length + ". Erwarte Vielfaches von " + this.entryByteSize() + ".");
        }
        return length / (long)this._entryByteSize;
    }

    @Override
    public int entryByteSize() {
        return this._entryByteSize;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void close() throws IOException {
        this._file.close();
    }
}

