/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.backend.storage;

import de.bsvrz.ars.ars.persistence.index.backend.storage.BufferedIndexStorage;
import de.bsvrz.ars.ars.persistence.index.backend.storage.FileIndexStorage;
import de.bsvrz.ars.ars.persistence.index.backend.storage.IndexStorage;
import de.bsvrz.ars.ars.persistence.index.backend.storage.MemoryIndexStorage;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class HybridStorage
implements IndexStorage,
AutoCloseable {
    private final MemoryIndexStorage _memoryIndexStorage;
    private final Path _file;
    private long _fileEntries;
    @Nullable
    private BufferedIndexStorage _fileIndexStorage;
    private static final Debug _debug = Debug.getLogger();
    private final int _memoryLimit;

    public HybridStorage(int entryByteSize, int memoryLimit, @Nullable Path file) throws IOException {
        this._memoryLimit = memoryLimit;
        this._memoryIndexStorage = new MemoryIndexStorage(entryByteSize, this._memoryLimit);
        this._file = file;
        if (this._file != null && Files.exists(this._file, new LinkOption[0])) {
            long size = Files.size(this._file);
            if (size % (long)entryByteSize != 0L) {
                throw new IOException("Dateil\u00e4nge ist nicht durch " + entryByteSize + " teilbar: " + size);
            }
            this._fileEntries = size / (long)entryByteSize;
        } else if (this._file == null) {
            _debug.warning("Initialisierung mit _file == null");
        }
    }

    @Override
    public void getEntries(long entryIndex, int numEntries, byte[] result, int destPos) throws IOException {
        if (entryIndex >= this._fileEntries) {
            this._memoryIndexStorage.getEntries(entryIndex - this._fileEntries, numEntries, result, destPos);
            return;
        }
        BufferedIndexStorage storage = this.getFileStorage();
        int numFileEntries = (int)Math.min(this._fileEntries - entryIndex, (long)numEntries);
        storage.getEntries(entryIndex, numFileEntries, result, destPos);
        if (numFileEntries < numEntries) {
            this._memoryIndexStorage.getEntries(0L, numEntries - numFileEntries, result, destPos + numFileEntries * this.entryByteSize());
        }
    }

    @Override
    public void setEntries(long entryIndex, int numEntries, byte[] data, int fromPos) throws IOException {
        if (entryIndex >= this._fileEntries) {
            this._memoryIndexStorage.setEntries(entryIndex - this._fileEntries, numEntries, data, fromPos);
            return;
        }
        BufferedIndexStorage storage = this.getFileStorage();
        int numFileEntries = (int)Math.min(this._fileEntries - entryIndex, (long)numEntries);
        storage.setEntries(entryIndex, numFileEntries, data, fromPos);
        if (numFileEntries < numEntries) {
            this._memoryIndexStorage.setEntries(0L, numEntries - numFileEntries, data, fromPos + numFileEntries * this.entryByteSize());
        }
    }

    @Override
    public void insertEntries(long entryIndex, int numEntries, byte[] data, int fromPos) throws IOException {
        if (entryIndex >= this._fileEntries && this._memoryIndexStorage.numEntries() + (long)numEntries < (long)this._memoryIndexStorage.maxNumEntries()) {
            this._memoryIndexStorage.insertEntries(entryIndex - this._fileEntries, numEntries, data);
            return;
        }
        BufferedIndexStorage storage = this.getFileStorage();
        this.flushMemory(storage);
        storage.insertEntries(entryIndex, numEntries, data);
        this._fileEntries += (long)numEntries;
    }

    private void flushMemory(BufferedIndexStorage fileStorage) throws IOException {
        this._memoryIndexStorage.flushTo(fileStorage);
        this._fileEntries = fileStorage.numEntries();
    }

    private BufferedIndexStorage getFileStorage() throws IOException {
        if (this._fileIndexStorage == null) {
            this._fileIndexStorage = new BufferedIndexStorage(new FileIndexStorage(this._file, this.entryByteSize()), this._memoryLimit);
        }
        return this._fileIndexStorage;
    }

    public Path getFile() {
        return this._file;
    }

    @Override
    public long numEntries() {
        return this._fileEntries + this._memoryIndexStorage.numEntries();
    }

    public long firstMemoryIndex() {
        return this._fileEntries;
    }

    public int memoryEntries() {
        return (int)this._memoryIndexStorage.numEntries();
    }

    @Override
    public int entryByteSize() {
        return this._memoryIndexStorage.entryByteSize();
    }

    public String toString() {
        BufferedIndexStorage fileIndexStorage = this._fileIndexStorage;
        if (fileIndexStorage == null) {
            return this.getClass().getSimpleName() + " (" + this.numEntries() + " Eintr\u00e4ge, davon 0 im Lesecache und " + this.memoryEntries() + " im Schreibcache)";
        }
        return this.getClass().getSimpleName() + " (" + this.numEntries() + " Eintr\u00e4ge, davon " + fileIndexStorage.getBufferedCount() + " im Lesecache und " + this.memoryEntries() + " im Schreibcache)";
    }

    @Override
    public void close() throws IOException {
        if (this._file == null) {
            return;
        }
        if (this._fileIndexStorage == null && this._memoryIndexStorage.numEntries() == 0L && (Files.exists(this._file, new LinkOption[0]) || !Files.exists(this._file.getParent(), new LinkOption[0]))) {
            return;
        }
        try (BufferedIndexStorage storage = this.getFileStorage();){
            this.flushMemory(storage);
            this._fileIndexStorage.close();
        }
        this._fileIndexStorage = null;
    }

    @Override
    public void deleteEntryAtIndex(long entryIndex) throws IOException {
        if (entryIndex >= this._fileEntries) {
            this._memoryIndexStorage.deleteEntryAtIndex(entryIndex - this._fileEntries);
            return;
        }
        BufferedIndexStorage storage = this.getFileStorage();
        storage.deleteEntryAtIndex(entryIndex);
        --this._fileEntries;
    }

    public void flush() throws IOException {
        if (this._file == null) {
            return;
        }
        if (this._fileIndexStorage == null && this._memoryIndexStorage.numEntries() == 0L && (Files.exists(this._file, new LinkOption[0]) || !Files.exists(this._file.getParent(), new LinkOption[0]))) {
            return;
        }
        BufferedIndexStorage storage = this.getFileStorage();
        this.flushMemory(storage);
        this._fileIndexStorage.flush();
    }
}

