/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.backend.storage;

import de.bsvrz.ars.ars.persistence.index.backend.storage.IndexStorage;
import java.io.IOException;
import java.util.Arrays;

public final class MemoryIndexStorage
implements IndexStorage {
    private final int _entryByteSize;
    private int _numEntries;
    private final byte[] _data;
    private final int _limit;

    public MemoryIndexStorage(int entryByteSize, int limit) {
        this._entryByteSize = entryByteSize;
        this._limit = limit;
        this._data = new byte[this._limit * entryByteSize];
    }

    @Override
    public void getEntries(long entryIndex, int numEntries, byte[] result, int destPos) {
        if (numEntries == 0) {
            return;
        }
        if (entryIndex + (long)numEntries > this.numEntries()) {
            throw new IllegalArgumentException("Enth\u00e4lt nur " + this.numEntries() + " Elemente, abgefragt wurde aber Element " + entryIndex + " bis " + (entryIndex + (long)numEntries) + ".");
        }
        if (numEntries < 0) {
            throw new IllegalArgumentException("numEntries < 0: " + numEntries);
        }
        int startByte = (int)entryIndex * this._entryByteSize;
        System.arraycopy(this._data, startByte, result, destPos, numEntries * this._entryByteSize);
    }

    @Override
    public void setEntries(long entryIndex, int numEntries, byte[] data, int fromPos) {
        if (entryIndex + (long)numEntries > this.numEntries()) {
            throw new IllegalArgumentException("Enth\u00e4lt nur " + this.numEntries() + " Elemente, abgefragt wurde aber Element " + entryIndex + " bis " + (entryIndex + (long)numEntries) + ".");
        }
        if (numEntries <= 0) {
            throw new IllegalArgumentException("numEntries <= 0: " + numEntries);
        }
        int startByte = (int)entryIndex * this._entryByteSize;
        System.arraycopy(data, fromPos, this._data, startByte, numEntries * this._entryByteSize);
    }

    @Override
    public void insertEntries(long entryIndex, int numEntries, byte[] data, int fromPos) {
        long currentEntries = this.numEntries();
        if ((long)numEntries + currentEntries > (long)this._limit || numEntries < 0 || entryIndex < 0L || entryIndex > currentEntries) {
            throw new IllegalArgumentException();
        }
        int endShiftByte = this._numEntries * this._entryByteSize;
        int startShiftByte = (int)entryIndex * this._entryByteSize;
        if (endShiftByte > startShiftByte) {
            System.arraycopy(this._data, startShiftByte, this._data, startShiftByte + numEntries * this._entryByteSize, endShiftByte - startShiftByte);
        }
        System.arraycopy(data, fromPos, this._data, startShiftByte, numEntries * this._entryByteSize);
        this._numEntries += numEntries;
    }

    public void flushTo(IndexStorage other) throws IOException {
        if (this == other) {
            throw new IllegalArgumentException();
        }
        other.insertEntries(other.numEntries(), this._numEntries, this._data, 0);
        this._numEntries = 0;
    }

    @Override
    public long numEntries() {
        return this._numEntries;
    }

    public int maxNumEntries() {
        return this._limit;
    }

    @Override
    public int entryByteSize() {
        return this._entryByteSize;
    }

    @Override
    public void deleteEntryAtIndex(long entryIndex) {
        int index = (int)entryIndex;
        System.arraycopy(this._data, this._entryByteSize * (index + 1), this._data, this._entryByteSize * index, this._entryByteSize * (this._numEntries - (index + 1)));
        --this._numEntries;
    }

    public String toString() {
        byte[] bytes = new byte[(int)(this.numEntries() * (long)this._entryByteSize)];
        this.getEntries(0L, (int)this.numEntries(), bytes, 0);
        return Arrays.toString(bytes);
    }
}

