/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.index.result;

import de.bsvrz.ars.ars.persistence.index.backend.management.ColumnType;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import java.util.ArrayList;
import java.util.List;

public class BinaryIndexResult<E extends Enum<E>>
implements IndexResult<E> {
    private final List<byte[]> _dataSets = new ArrayList<byte[]>();
    private final IndexContentDescriptor<E> _indexContentDescriptor;
    private byte[] _next;

    public BinaryIndexResult(IndexContentDescriptor<E> indexContentDescriptor) {
        this._indexContentDescriptor = indexContentDescriptor;
    }

    public void add(byte[] data) {
        this._dataSets.add(data);
    }

    public void setNext(byte[] data) {
        this._next = data;
    }

    @Override
    public int size() {
        return this._dataSets.size();
    }

    @Override
    public long get(int index, E value) {
        if (this._indexContentDescriptor == null) {
            throw new IllegalArgumentException("Index: " + index + " Size: " + this.size());
        }
        IndexContentDescriptor.IndexColumn column = this._indexContentDescriptor.getColumn(value);
        if (column == null) {
            return -1L;
        }
        if (column.getType() == ColumnType.String) {
            throw new IllegalArgumentException("Spalte " + String.valueOf(column) + " kann nicht als Long-Wert abgerufen werden.");
        }
        if (index < 0 || index >= this._dataSets.size()) {
            throw new IllegalArgumentException("Index: " + index + " Size: " + this.size());
        }
        return column.readLong(this._dataSets.get(index));
    }

    @Override
    public int getSignedInt(int index, E value) {
        return (int)this.get(index, value);
    }

    @Override
    public String getString(int index, E value) {
        if (this._indexContentDescriptor == null) {
            throw new IllegalArgumentException("Index: " + index + " Size: " + this.size());
        }
        IndexContentDescriptor.IndexColumn column = this._indexContentDescriptor.getColumn(value);
        if (column == null) {
            return null;
        }
        if (column.getType() != ColumnType.String) {
            throw new IllegalArgumentException("Spalte " + String.valueOf(column) + " kann nur als Long-Wert abgerufen werden.");
        }
        if (index < 0 || index >= this._dataSets.size()) {
            throw new IllegalArgumentException("Index: " + index + " Size: " + this.size());
        }
        return column.readString(this._dataSets.get(index));
    }

    @Override
    public boolean getBoolean(int index, E value) {
        return "1".equals(this.getString(index, value));
    }

    @Override
    public boolean hasNext() {
        return this._next != null;
    }

    @Override
    public long getNext(E value) {
        IndexContentDescriptor.IndexColumn column = this._indexContentDescriptor.getColumn(value);
        return column.readLong(this._next);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public long getMin(E value) {
        IndexContentDescriptor.IndexColumn column = this._indexContentDescriptor.getColumn(value);
        if (column == null || this.isEmpty()) {
            throw new IllegalStateException();
        }
        if (column.getType() == ColumnType.String) {
            throw new IllegalArgumentException("Strings k\u00f6nnen aktuell nicht verglichen werden.");
        }
        if (column.getType() == ColumnType.Increasing || column.getType() == ColumnType.StrictlyIncreasing) {
            return this.get(0, value);
        }
        return this._dataSets.stream().mapToLong(column::readLong).min().getAsLong();
    }

    @Override
    public long getMax(E value) {
        IndexContentDescriptor.IndexColumn column = this._indexContentDescriptor.getColumn(value);
        if (column == null || this.isEmpty()) {
            throw new IllegalStateException();
        }
        if (column.getType() == ColumnType.String) {
            throw new IllegalArgumentException("Strings k\u00f6nnen aktuell nicht verglichen werden.");
        }
        if (column.getType() == ColumnType.Increasing || column.getType() == ColumnType.StrictlyIncreasing) {
            return this.get(this.size() - 1, value);
        }
        return this._dataSets.stream().mapToLong(column::readLong).max().getAsLong();
    }

    @Override
    public List<IndexContentDescriptor.IndexColumn> getColumns() {
        return this._indexContentDescriptor.getColumns();
    }

    @Override
    public String toString() {
        return "IndexResult[" + this.size() + "]";
    }
}

