/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.iter;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerManagementData;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.iter.CombineDataIterator;
import de.bsvrz.ars.ars.persistence.iter.DataGapManager;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.QueryDataSequence;
import de.bsvrz.ars.ars.persistence.iter.SequentialContainerIterator;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveOrder;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public class BucketContainerIterator
implements DataIterator {
    private final List<List<QueryDataSequence.IndexedContainer>> _containerFiles;
    private final ArchiveDataKind _adk;
    private DataIterator _currentDelegate;
    private int _index;
    private final ArchiveOrder _order;
    private final IdDataIdentification _idDataIdentification;
    private final DataGapManager gapManager;

    public BucketContainerIterator(List<List<QueryDataSequence.IndexedContainer>> containerFiles, ArchiveDataKind adk, ArchiveOrder order, IdDataIdentification idDataIdentification, DataGapManager gapManager) throws PersistenceException {
        this._containerFiles = containerFiles;
        this._idDataIdentification = idDataIdentification;
        this._adk = adk;
        this._order = order;
        this.gapManager = gapManager;
        if (containerFiles.isEmpty()) {
            throw new IllegalArgumentException("containerFiles");
        }
        this.openBucket(this._index);
    }

    private void openBucket(int index) throws PersistenceException {
        List<QueryDataSequence.IndexedContainer> bucket = this._containerFiles.get(index);
        if (bucket.size() == 1) {
            this._currentDelegate = new SequentialContainerIterator(bucket, this._adk, null, this._idDataIdentification, this.gapManager);
        } else {
            ArrayList<DataIterator> iterators = new ArrayList<DataIterator>();
            for (QueryDataSequence.IndexedContainer indexedContainer : bucket) {
                iterators.add(new SequentialContainerIterator(Collections.singletonList(indexedContainer), this._adk, null, this._idDataIdentification, this.gapManager));
            }
            this._currentDelegate = new CombineDataIterator((List<DataIterator>)iterators, this._order);
        }
    }

    private void closeBucket() {
        this._currentDelegate.close();
    }

    @Override
    public void peek(ContainerDataResult result) throws PersistenceException {
        this._currentDelegate.peek(result);
    }

    @Override
    public ContainerDataResult peekNext() {
        if (!this.isEmpty()) {
            throw new IllegalStateException();
        }
        return null;
    }

    @Override
    public long peekDataIndex() {
        return this._currentDelegate.peekDataIndex();
    }

    @Override
    public long peekDataTime() {
        return this._currentDelegate.peekDataTime();
    }

    @Override
    public long peekArchiveTime() {
        return this._currentDelegate.peekArchiveTime();
    }

    @Override
    public void remove() throws PersistenceException, SynchronizationFailedException {
        this._currentDelegate.remove();
        if (this._currentDelegate.isEmpty() && this._index < this._containerFiles.size() - 1) {
            this.closeBucket();
            ++this._index;
            this.openBucket(this._index);
        }
    }

    @Override
    public boolean isEmpty() {
        return this._currentDelegate.isEmpty();
    }

    @Override
    public void close() {
        this._currentDelegate.close();
    }

    @Override
    @NotNull
    public ContainerManagementData getContainerManagementData() throws PersistenceException {
        if (this._currentDelegate == null) {
            throw new NoSuchElementException();
        }
        return this._currentDelegate.getContainerManagementData();
    }
}

