/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.persistence.iter;

import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.PersistenceManager;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.IndexValues;
import de.bsvrz.ars.ars.persistence.index.result.LocatedIndexResult;
import de.bsvrz.ars.ars.persistence.iter.BucketContainerIterator;
import de.bsvrz.ars.ars.persistence.iter.CombineDataIterator;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.iter.DataSequence;
import de.bsvrz.ars.ars.persistence.iter.SequentialContainerIterator;
import de.bsvrz.ars.ars.persistence.iter.TimeSpecificationCombineDataIterator;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.archive.ArchiveOrder;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class QueryDataSequence
implements DataSequence {
    private final ArchiveDataKindCombination _archiveDataKinds;
    @NotNull
    private final ArchiveTimeSpecification _archiveTimeSpecification;
    private final PersistenceManager _persMgr;
    private final IdDataIdentification _idDataIdentification;
    private final List<DataSequence> _containerSequences = new ArrayList<DataSequence>();
    private final ArchiveOrder _order;
    private static final int MAX_INTERVAL = 16000;

    public QueryDataSequence(PersistenceManager persistenceManager, ArchiveDataKindCombination archiveDataKinds, @Nullable ArchiveTimeSpecification archiveTimeSpecification, ArchiveOrder order, IdDataIdentification idDataIdentification) throws PersistenceException {
        this._persMgr = persistenceManager;
        this._archiveDataKinds = archiveDataKinds;
        this._order = order;
        this._idDataIdentification = idDataIdentification;
        try (SyncKey<IdDataIdentification> indexLock = this._persMgr.lockIndex(idDataIdentification);){
            DataSequence containerSequence;
            if (archiveTimeSpecification == null) {
                this._archiveTimeSpecification = new ArchiveTimeSpecification(TimingType.DATA_INDEX, false, 0L, Long.MAX_VALUE);
            } else if (archiveTimeSpecification.isStartRelative()) {
                try {
                    this._archiveTimeSpecification = this.createAbsoluteTimeSpecification(indexLock, archiveTimeSpecification);
                }
                catch (IndexException e) {
                    throw new PersistenceException("Fehler beim \u00dcbersetzen der Relativanfrage", e);
                }
            } else {
                this._archiveTimeSpecification = archiveTimeSpecification;
            }
            if (archiveDataKinds.isOnline() && (containerSequence = this.getContainerSequence(new LockedContainerDirectory(indexLock, ArchiveDataKind.ONLINE))) != null) {
                this._containerSequences.add(containerSequence);
            }
            if (archiveDataKinds.isOnlineDelayed() && (containerSequence = this.getContainerSequence(new LockedContainerDirectory(indexLock, ArchiveDataKind.ONLINE_DELAYED))) != null) {
                this._containerSequences.add(containerSequence);
            }
            if (archiveDataKinds.isRequested() && (containerSequence = this.getContainerSequence(new LockedContainerDirectory(indexLock, ArchiveDataKind.REQUESTED))) != null) {
                this._containerSequences.add(containerSequence);
            }
            if (archiveDataKinds.isRequestedDelayed() && (containerSequence = this.getContainerSequence(new LockedContainerDirectory(indexLock, ArchiveDataKind.REQUESTED_DELAYED))) != null) {
                this._containerSequences.add(containerSequence);
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Fehler beim Auflisten der Container f\u00fcr die Iteration", e);
        }
    }

    private QueryDataSequence(ArchiveDataKindCombination archiveDataKinds, @NotNull ArchiveTimeSpecification archiveTimeSpecification, PersistenceManager persistenceManager, ArchiveOrder order, Collection<? extends DataSequence> sequences, IdDataIdentification idDataIdentification) {
        this._archiveDataKinds = archiveDataKinds;
        this._archiveTimeSpecification = archiveTimeSpecification;
        this._persMgr = persistenceManager;
        this._order = order;
        this._containerSequences.addAll(sequences);
        this._idDataIdentification = idDataIdentification;
    }

    @Nullable
    private DataSequence getContainerSequence(LockedContainerDirectory containerDirectory) throws Exception {
        LocatedIndexResult<IndexValues> indexResult = this._persMgr.getIndexResult(containerDirectory, this._archiveTimeSpecification);
        return this.getDataSequence(containerDirectory, indexResult, 0, indexResult.size() - 1);
    }

    @Nullable
    private DataSequence getDataSequence(LockedContainerDirectory containerDirectory, LocatedIndexResult<IndexValues> indexResult, int lowerBound, int upperBound) {
        long containerId;
        if (indexResult.isEmpty()) {
            return null;
        }
        ArchiveDataKind adk = containerDirectory.archiveDataKind();
        ArrayList<IndexedContainer> indexedContainers = new ArrayList<IndexedContainer>(indexResult.size());
        for (int i = lowerBound; i <= upperBound; ++i) {
            containerId = indexResult.get(i, IndexValues.ContainerId);
            indexedContainers.add(new IndexedContainer(adk, containerId, indexResult.get(i, IndexValues.DataIndexMin), indexResult.get(i, IndexValues.DataIndexMax), indexResult.get(i, IndexValues.DataTimeMin), indexResult.get(i, IndexValues.DataTimeMax), indexResult.getPersistenceDirectory(i)));
        }
        IndexedContainer nextContainer = null;
        if (indexResult.hasNext()) {
            containerId = indexResult.getNext(IndexValues.ContainerId);
            nextContainer = new IndexedContainer(adk, containerId, indexResult.getNext(IndexValues.DataIndexMin), indexResult.getNext(IndexValues.DataIndexMax), indexResult.getNext(IndexValues.DataTimeMin), indexResult.getNext(IndexValues.DataTimeMax), indexResult.getNextPersistenceDirectory());
        }
        if (adk.isDelayed() && this._order == ArchiveOrder.BY_DATA_TIME) {
            return new BucketContainerSequence(containerDirectory, indexedContainers);
        }
        if (adk.isRequested()) {
            return new BucketContainerSequence(containerDirectory, indexedContainers);
        }
        indexedContainers.sort(Comparator.comparing(IndexedContainer::getDataIndexMinimum));
        return new SimpleContainerSequence(indexedContainers, nextContainer, adk);
    }

    private ArchiveTimeSpecification createAbsoluteTimeSpecification(SyncKey<IdDataIdentification> lock, ArchiveTimeSpecification ats) throws IndexException, PersistenceException, SynchronizationFailedException {
        ArrayDeque<Long> tmpDeque;
        long numDs = ats.getIntervalStart();
        if (numDs > 16000L) {
            numDs = 16000L;
        }
        TimingType timingType = ats.getTimingType();
        if (numDs <= 0L) {
            return new ArchiveTimeSpecification(timingType, false, ats.getIntervalEnd(), ats.getIntervalEnd());
        }
        ArchiveTimeSpecification timeSpecification = new ArchiveTimeSpecification(timingType, false, 0L, ats.getIntervalEnd());
        ArrayList<DataSequence> sequences = new ArrayList<DataSequence>();
        for (ArchiveDataKind adk : this._archiveDataKinds) {
            int firstIndex;
            DataSequence sequence;
            LockedContainerDirectory containerDirectory = new LockedContainerDirectory(lock, adk);
            LocatedIndexResult<IndexValues> indexResult = this._persMgr.getIndexResult(containerDirectory, timeSpecification);
            int lastIndex = indexResult.size() - 1;
            long remainingDs = numDs;
            int tmpIndex = lastIndex;
            if (tmpIndex > 0) {
                --tmpIndex;
                while (true) {
                    long containerId = indexResult.get(tmpIndex, IndexValues.ContainerId);
                    if ((remainingDs -= (long)indexResult.getPersistenceDirectory(tmpIndex).getContainerHeaders(containerDirectory, containerId).getContainerHeaderParamAsInt(ContainerManagementInformation.CHP_ANZ_DS)) <= 0L || tmpIndex == 0) break;
                    --tmpIndex;
                }
            }
            if ((sequence = this.getDataSequence(containerDirectory, indexResult, firstIndex = tmpIndex, lastIndex)) == null) continue;
            sequences.add(sequence);
        }
        QueryDataSequence sequence = new QueryDataSequence(this._archiveDataKinds, timeSpecification, this._persMgr, this._order, sequences, this._idDataIdentification);
        try (DataIterator iterator = sequence.iterator();){
            tmpDeque = new ArrayDeque<Long>((int)numDs);
            while (!iterator.isEmpty()) {
                if ((long)tmpDeque.size() == numDs) {
                    tmpDeque.removeFirst();
                }
                if (timingType == TimingType.DATA_INDEX) {
                    tmpDeque.addLast(iterator.peekDataIndex());
                } else if (timingType == TimingType.DATA_TIME) {
                    tmpDeque.addLast(iterator.peekDataTime());
                } else if (timingType == TimingType.ARCHIVE_TIME) {
                    tmpDeque.addLast(iterator.peekArchiveTime());
                }
                iterator.remove();
            }
        }
        if (tmpDeque.isEmpty()) {
            return new ArchiveTimeSpecification(timingType, false, ats.getIntervalEnd(), ats.getIntervalEnd());
        }
        return new ArchiveTimeSpecification(timingType, false, ((Long)tmpDeque.peekFirst()).longValue(), ((Long)tmpDeque.peekLast()).longValue());
    }

    @Override
    public DataIterator iterator() throws PersistenceException, SynchronizationFailedException {
        return new TimeSpecificationCombineDataIterator(this._containerSequences, this._order, this._archiveTimeSpecification);
    }

    public DataIterator iteratorWithoutTimeFilter() throws PersistenceException, SynchronizationFailedException {
        return new CombineDataIterator((Collection<DataSequence>)this._containerSequences, this._order);
    }

    public static class IndexedContainer {
        private final ArchiveDataKind _adk;
        private final long _containerId;
        private final long _dataIndexMinimum;
        private final long _dataIndexMaximum;
        private long _dataTimeMinimum;
        private long _dataTimeMaximum;
        private final PersistenceDirectory _directory;

        public IndexedContainer(ArchiveDataKind adk, long containerId, long dataIndexMinimum, long dataIndexMaximum, long dataTimeMinimum, long dataTimeMaximum, PersistenceDirectory directory) {
            this._adk = adk;
            this._containerId = containerId;
            this._dataIndexMinimum = dataIndexMinimum;
            this._dataIndexMaximum = dataIndexMaximum;
            this._dataTimeMinimum = dataTimeMinimum;
            this._dataTimeMaximum = dataTimeMaximum;
            this._directory = directory;
        }

        public long getContainerId() {
            return this._containerId;
        }

        public long getDataIndexMinimum() {
            return this._dataIndexMinimum;
        }

        public long getDataIndexMaximum() {
            return this._dataIndexMaximum;
        }

        public long getDataTimeMinimum(SyncKey<IdDataIdentification> lock) {
            if (this._dataIndexMinimum == -1L) {
                try {
                    this._dataTimeMinimum = this._directory.getContainerHeaders(new LockedContainerDirectory(lock, this._adk), this._containerId).getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MIN);
                }
                catch (IndexException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return this._dataTimeMinimum;
        }

        public long getDataTimeMaximum(SyncKey<IdDataIdentification> lock) {
            if (this._dataIndexMaximum == -1L) {
                try {
                    this._dataTimeMaximum = this._directory.getContainerHeaders(new LockedContainerDirectory(lock, this._adk), this._containerId).getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX);
                }
                catch (IndexException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return this._dataTimeMaximum;
        }

        public PersistenceDirectory getDirectory() {
            return this._directory;
        }
    }

    private final class BucketContainerSequence
    implements DataSequence {
        private final List<List<IndexedContainer>> _containerFiles = new ArrayList<List<IndexedContainer>>();
        private final LockedContainerDirectory directory;

        public BucketContainerSequence(LockedContainerDirectory directory, List<IndexedContainer> containerFiles) {
            this.directory = directory;
            if (QueryDataSequence.this._order == ArchiveOrder.BY_INDEX) {
                this.initByIndex(containerFiles);
            } else {
                this.initByDataTime(directory.lock(), containerFiles);
            }
        }

        private void initByIndex(List<IndexedContainer> containerFiles) {
            ArrayList<IndexedContainer> tmpBlock = new ArrayList<IndexedContainer>();
            ArrayList<IndexedContainer> tmp = new ArrayList<IndexedContainer>(containerFiles);
            tmp.sort(Comparator.comparing(IndexedContainer::getDataIndexMinimum).reversed());
            while (!tmp.isEmpty()) {
                boolean doContinue;
                IndexedContainer last = tmp.remove(tmp.size() - 1);
                tmpBlock.add(last);
                long min = last.getDataIndexMinimum();
                long max = last.getDataIndexMaximum();
                do {
                    doContinue = false;
                    Iterator<IndexedContainer> iterator = tmp.iterator();
                    while (iterator.hasNext()) {
                        IndexedContainer indexedContainer = iterator.next();
                        if (!this.overlapIndex(indexedContainer, min, max)) continue;
                        iterator.remove();
                        tmpBlock.add(indexedContainer);
                        min = Math.min(min, indexedContainer.getDataIndexMinimum());
                        max = Math.max(max, indexedContainer.getDataIndexMaximum());
                        doContinue = true;
                    }
                } while (doContinue);
                this._containerFiles.add(new ArrayList(tmpBlock));
                tmpBlock.clear();
            }
        }

        public void initByDataTime(SyncKey<IdDataIdentification> lock, List<IndexedContainer> containerFiles) {
            ArrayList<IndexedContainer> tmpBlock = new ArrayList<IndexedContainer>();
            ArrayList<IndexedContainer> tmp = new ArrayList<IndexedContainer>(containerFiles);
            tmp.sort(Comparator.comparing(indexedContainer1 -> indexedContainer1.getDataTimeMinimum(lock)).reversed());
            while (!tmp.isEmpty()) {
                boolean doContinue;
                IndexedContainer last = tmp.remove(tmp.size() - 1);
                tmpBlock.add(last);
                long min = last.getDataTimeMinimum(lock);
                long max = last.getDataTimeMaximum(lock);
                do {
                    doContinue = false;
                    Iterator<IndexedContainer> iterator = tmp.iterator();
                    while (iterator.hasNext()) {
                        IndexedContainer indexedContainer = iterator.next();
                        if (!this.overlapDataTime(lock, indexedContainer, min, max)) continue;
                        iterator.remove();
                        tmpBlock.add(indexedContainer);
                        min = Math.min(min, indexedContainer.getDataTimeMinimum(lock));
                        max = Math.max(max, indexedContainer.getDataTimeMaximum(lock));
                        doContinue = true;
                    }
                } while (doContinue);
                this._containerFiles.add(new ArrayList(tmpBlock));
                tmpBlock.clear();
            }
        }

        private boolean overlapIndex(IndexedContainer indexedContainer, long min, long max) {
            return indexedContainer.getDataIndexMinimum() <= max && indexedContainer.getDataIndexMaximum() >= min;
        }

        private boolean overlapDataTime(SyncKey<IdDataIdentification> lock, IndexedContainer indexedContainer, long min, long max) {
            return indexedContainer.getDataTimeMinimum(lock) <= max && indexedContainer.getDataTimeMaximum(lock) >= min;
        }

        @Override
        public DataIterator iterator() throws PersistenceException {
            return new BucketContainerIterator(this._containerFiles, this.directory.archiveDataKind(), QueryDataSequence.this._order, QueryDataSequence.this._idDataIdentification, QueryDataSequence.this._persMgr);
        }
    }

    private class SimpleContainerSequence
    implements DataSequence {
        private final List<IndexedContainer> _containerFiles;
        private final ArchiveDataKind _adk;
        private final IndexedContainer _nextContainer;

        public SimpleContainerSequence(@Nullable List<IndexedContainer> containerFiles, IndexedContainer nextContainer, ArchiveDataKind adk) {
            this._containerFiles = containerFiles;
            this._nextContainer = nextContainer;
            this._adk = adk;
        }

        @Override
        public DataIterator iterator() throws PersistenceException {
            return new SequentialContainerIterator(this._containerFiles, this._adk, this._nextContainer, QueryDataSequence.this._idDataIdentification, QueryDataSequence.this._persMgr);
        }
    }
}

